/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.module;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.context.module.ModuleProvider;
import com.espertech.esper.common.internal.context.module.ModuleProviderResult;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;

public class ModuleProviderUtil {
    public static ModuleProviderResult analyze(EPCompiled compiled, ClassLoader classLoaderParent) {
        ModuleProvider moduleResource;
        Class<?> clazz;
        ByteArrayProvidingClassLoader classLoader = new ByteArrayProvidingClassLoader(compiled.getClasses(), classLoaderParent);
        String resourceClassName = compiled.getManifest().getModuleProviderClassName();
        try {
            clazz = classLoader.loadClass(resourceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new EPException(e);
        }
        try {
            moduleResource = (ModuleProvider)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EPException(e);
        }
        return new ModuleProviderResult(classLoader, moduleResource);
    }
}

