/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.event.core.NaturalEventBean;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalRoutePreprocessView
extends ViewSupport {
    private static final Logger log = LoggerFactory.getLogger(InternalRoutePreprocessView.class);
    private final EventType eventType;
    private final StatementResultService statementResultService;

    public InternalRoutePreprocessView(EventType eventType, StatementResultService statementResultService) {
        this.eventType = eventType;
        this.statementResultService = statementResultService;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }

    public boolean isIndicate() {
        return this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic();
    }

    public void indicate(EventBean newEvent, EventBean oldEvent) {
        try {
            if (this.statementResultService.isMakeNatural()) {
                NaturalEventBean natural = new NaturalEventBean(this.eventType, new Object[]{newEvent.getUnderlying()}, newEvent);
                NaturalEventBean naturalOld = new NaturalEventBean(this.eventType, new Object[]{oldEvent.getUnderlying()}, oldEvent);
                this.child.update(new NaturalEventBean[]{natural}, new NaturalEventBean[]{naturalOld});
            } else {
                this.child.update(new EventBean[]{newEvent}, new EventBean[]{oldEvent});
            }
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error updating child view: " + ex.getMessage());
        }
    }

    public StatementResultService getStatementResultService() {
        return this.statementResultService;
    }
}

