/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParentClassLoader
extends ClassLoader {
    private final Map<String, Class> classes = new HashMap<String, Class>(4);
    private final Map<String, List<String>> deploymentIds = new HashMap<String, List<String>>(4);

    public ParentClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class existing = this.classes.get(name);
        if (existing != null) {
            return existing;
        }
        return super.findClass(name);
    }

    public void add(String underlyingClassName, Class clazz, String optionalDeploymentId, boolean allowDuplicate) {
        if (!allowDuplicate && this.classes.containsKey(underlyingClassName)) {
            throw new IllegalStateException("Attempt to add duplicate class " + underlyingClassName + " to parent cloass loader");
        }
        this.classes.put(underlyingClassName, clazz);
        if (optionalDeploymentId != null) {
            List<String> existing = this.deploymentIds.get(optionalDeploymentId);
            if (existing == null) {
                existing = new ArrayList<String>(2);
                this.deploymentIds.put(optionalDeploymentId, existing);
            }
            existing.add(underlyingClassName);
        }
    }

    public void remove(String deploymentId) {
        List<String> existing = this.deploymentIds.remove(deploymentId);
        if (existing == null) {
            return;
        }
        for (String className : existing) {
            this.classes.remove(className);
        }
    }
}

