/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.access.countminsketch;

import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchAggState;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchSpec;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchState;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchStateHashes;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchStateTopk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AggregationStateSerdeCountMinSketch {
    public static void writeCountMinSketch(DataOutput output, CountMinSketchAggState state) throws IOException {
        AggregationStateSerdeCountMinSketch.writeState(output, state.getState());
    }

    public static CountMinSketchAggState readCountMinSketch(DataInput input, CountMinSketchSpec spec) throws IOException {
        CountMinSketchAggState state = spec.makeAggState();
        AggregationStateSerdeCountMinSketch.readState(input, state.getState());
        return state;
    }

    private static void writeState(DataOutput output, CountMinSketchState state) throws IOException {
        CountMinSketchStateHashes hashes = state.getHashes();
        output.writeInt(hashes.getDepth());
        output.writeInt(hashes.getWidth());
        long[][] table = hashes.getTable();
        output.writeInt(table.length);
        for (long[] row : table) {
            output.writeInt(row.length);
            for (long col : row) {
                output.writeLong(col);
            }
        }
        long[] hash = hashes.getHash();
        output.writeInt(hash.length);
        for (long aHash : hash) {
            output.writeLong(aHash);
        }
        output.writeLong(hashes.getTotal());
        CountMinSketchStateTopk topk = state.getTopk();
        output.writeBoolean(topk != null);
        if (topk != null) {
            output.writeInt(topk.getTopkMax());
            TreeMap<Long, Object> topMap = topk.getTopk();
            output.writeInt(topMap.size());
            for (Map.Entry<Long, Object> entry : topMap.entrySet()) {
                output.writeLong(entry.getKey());
                if (entry.getValue() instanceof ByteBuffer) {
                    output.writeInt(1);
                    AggregationStateSerdeCountMinSketch.writeBytes(output, (ByteBuffer)entry.getValue());
                    continue;
                }
                Deque q = (Deque)entry.getValue();
                output.writeInt(q.size());
                for (ByteBuffer buf : q) {
                    AggregationStateSerdeCountMinSketch.writeBytes(output, buf);
                }
            }
        }
    }

    private static void readState(DataInput input, CountMinSketchState state) throws IOException {
        int depth = input.readInt();
        int width = input.readInt();
        int rowsTable = input.readInt();
        long[][] table = new long[rowsTable][];
        for (int i = 0; i < rowsTable; ++i) {
            int colsRows = input.readInt();
            table[i] = new long[colsRows];
            for (int j = 0; j < colsRows; ++j) {
                table[i][j] = input.readLong();
            }
        }
        int rowsHash = input.readInt();
        long[] hash = new long[rowsHash];
        for (int i = 0; i < rowsTable; ++i) {
            hash[i] = input.readLong();
        }
        long total = input.readLong();
        state.setHashes(new CountMinSketchStateHashes(depth, width, table, hash, total));
        boolean hasTopk = input.readBoolean();
        state.setTopk(null);
        if (hasTopk) {
            int topkMax = input.readInt();
            TreeMap<Long, Object> topMap = new TreeMap<Long, Object>(Collections.reverseOrder());
            HashMap<ByteBuffer, Long> refMap = new HashMap<ByteBuffer, Long>();
            int numRows = input.readInt();
            for (int i = 0; i < numRows; ++i) {
                long freq = input.readLong();
                int numEntries = input.readInt();
                if (numEntries == 1) {
                    ByteBuffer buf = AggregationStateSerdeCountMinSketch.readBytes(input);
                    topMap.put(freq, buf);
                    refMap.put(buf, freq);
                    continue;
                }
                ArrayDeque<ByteBuffer> q = new ArrayDeque<ByteBuffer>(numEntries);
                for (int j = 0; j < numEntries; ++j) {
                    ByteBuffer buf = AggregationStateSerdeCountMinSketch.readBytes(input);
                    q.add(buf);
                    refMap.put(buf, freq);
                }
                topMap.put(freq, q);
            }
            state.setTopk(new CountMinSketchStateTopk(topkMax, topMap, refMap));
        }
    }

    private static void writeBytes(DataOutput output, ByteBuffer value) throws IOException {
        byte[] bytes = value.array();
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    private static ByteBuffer readBytes(DataInput input) throws IOException {
        int byteSize = input.readInt();
        byte[] bytes = new byte[byteSize];
        input.readFully(bytes);
        return ByteBuffer.wrap(bytes);
    }
}

