/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.groupby;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationCodegenRowLevelDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowCtorDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceCodegenNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryForgeWMethodGen;
import com.espertech.esper.common.internal.epl.agg.groupby.AggGroupByDesc;
import com.espertech.esper.common.internal.epl.agg.groupby.AggSvcGroupByReclaimAgedImpl;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacusField;
import com.espertech.esper.common.internal.epl.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregationServiceGroupByForge
implements AggregationServiceFactoryForgeWMethodGen {
    private static final CodegenExpressionMember MEMBER_CURRENTROW = CodegenExpressionBuilder.member("currentRow");
    private static final CodegenExpressionMember MEMBER_CURRENTGROUPKEY = CodegenExpressionBuilder.member("currentGroupKey");
    static final CodegenExpressionMember MEMBER_AGGREGATORSPERGROUP = CodegenExpressionBuilder.member("aggregatorsPerGroup");
    private static final CodegenExpressionMember MEMBER_REMOVEDKEYS = CodegenExpressionBuilder.member("removedKeys");
    protected final AggGroupByDesc aggGroupByDesc;
    protected final TimeAbacus timeAbacus;
    protected CodegenExpression reclaimAge;
    protected CodegenExpression reclaimFreq;

    public AggregationServiceGroupByForge(AggGroupByDesc aggGroupByDesc, TimeAbacus timeAbacus) {
        this.aggGroupByDesc = aggGroupByDesc;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public void providerCodegen(CodegenMethod method, CodegenClassScope classScope, AggregationClassNames classNames) {
        Class[] groupByTypes = ExprNodeUtilityQuery.getExprResultTypes(this.aggGroupByDesc.getGroupByNodes());
        if (this.aggGroupByDesc.isReclaimAged()) {
            this.reclaimAge = this.aggGroupByDesc.getReclaimEvaluationFunctionMaxAge().make(classScope);
            this.reclaimFreq = this.aggGroupByDesc.getReclaimEvaluationFunctionFrequency().make(classScope);
        } else {
            this.reclaimAge = CodegenExpressionBuilder.constantNull();
            this.reclaimFreq = CodegenExpressionBuilder.constantNull();
        }
        CodegenExpressionField timeAbacus = classScope.addOrGetFieldSharable(TimeAbacusField.INSTANCE);
        method.getBlock().declareVar(AggregationRowFactory.class, "rowFactory", CodegenExpressionBuilder.newInstance(classNames.getRowFactoryTop(), CodegenExpressionBuilder.ref("this"))).declareVar(DataInputOutputSerde.class, "rowSerde", CodegenExpressionBuilder.newInstance(classNames.getRowSerdeTop(), CodegenExpressionBuilder.ref("this"))).declareVar(AggregationServiceFactory.class, "svcFactory", CodegenExpressionBuilder.newInstance(classNames.getServiceFactory(), CodegenExpressionBuilder.ref("this"))).declareVar(DataInputOutputSerde.class, "serde", this.aggGroupByDesc.getGroupByMultiKey().getExprMKSerde(method, classScope)).methodReturn(CodegenExpressionBuilder.exprDotMethodChain(EPStatementInitServices.REF).add("getAggregationServiceFactoryService", new CodegenExpression[0]).add("groupBy", CodegenExpressionBuilder.ref("svcFactory"), CodegenExpressionBuilder.ref("rowFactory"), this.aggGroupByDesc.getRowStateForgeDescs().getUseFlags().toExpression(), CodegenExpressionBuilder.ref("rowSerde"), CodegenExpressionBuilder.constant(groupByTypes), this.reclaimAge, this.reclaimFreq, timeAbacus, CodegenExpressionBuilder.ref("serde")));
    }

    @Override
    public void rowCtorCodegen(AggregationRowCtorDesc rowCtorDesc) {
        AggregationServiceCodegenUtil.generateIncidentals(this.hasRefCounting(), this.aggGroupByDesc.isReclaimAged(), rowCtorDesc);
    }

    @Override
    public void rowWriteMethodCodegen(CodegenMethod method, int level) {
        if (this.hasRefCounting()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("output"), "writeInt", CodegenExpressionBuilder.ref("row.refcount"));
        }
        if (this.aggGroupByDesc.isReclaimAged()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("output"), "writeLong", CodegenExpressionBuilder.ref("row.lastUpd"));
        }
    }

    @Override
    public void rowReadMethodCodegen(CodegenMethod method, int level) {
        if (this.hasRefCounting()) {
            method.getBlock().assignRef("row.refcount", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("input"), "readInt", new CodegenExpression[0]));
        }
        if (this.aggGroupByDesc.isReclaimAged()) {
            method.getBlock().assignRef("row.lastUpd", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("input"), "readLong", new CodegenExpression[0]));
        }
    }

    @Override
    public void makeServiceCodegen(CodegenMethod method, CodegenClassScope classScope, AggregationClassNames classNames) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(classNames.getService(), CodegenExpressionBuilder.ref("o"), ResultSetProcessorCodegenNames.MEMBER_AGENTINSTANCECONTEXT));
    }

    @Override
    public void ctorCodegen(CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassScope classScope, AggregationClassNames classNames) {
        ctor.getCtorParams().add(new CodegenTypedParam(AgentInstanceContext.class, "agentInstanceContext"));
        explicitMembers.add(new CodegenTypedParam(Map.class, MEMBER_AGGREGATORSPERGROUP.getRef()));
        explicitMembers.add(new CodegenTypedParam(Object.class, MEMBER_CURRENTGROUPKEY.getRef()));
        explicitMembers.add(new CodegenTypedParam(classNames.getRowTop(), MEMBER_CURRENTROW.getRef()));
        ctor.getBlock().assignRef(MEMBER_AGGREGATORSPERGROUP, CodegenExpressionBuilder.newInstance(HashMap.class, new CodegenExpression[0]));
        if (this.aggGroupByDesc.isReclaimAged()) {
            AggSvcGroupByReclaimAgedImpl.ctorCodegenReclaim(ctor, explicitMembers, classScope, this.reclaimAge, this.reclaimFreq);
        }
        if (this.hasRefCounting()) {
            explicitMembers.add(new CodegenTypedParam(List.class, MEMBER_REMOVEDKEYS.getRef()));
            ctor.getBlock().assignRef(MEMBER_REMOVEDKEYS, CodegenExpressionBuilder.newInstance(ArrayList.class, CodegenExpressionBuilder.constant(4)));
        }
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(MEMBER_CURRENTROW, "getValue", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void getEventBeanCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(MEMBER_CURRENTROW, "getEventBean", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void getCollectionScalarCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(MEMBER_CURRENTROW, "getCollectionScalar", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void getCollectionOfEventsCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(MEMBER_CURRENTROW, "getCollectionOfEvents", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void applyEnterCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods, AggregationClassNames classNames) {
        method.getBlock().apply(InstrumentationCode.instblock(classScope, "qAggregationGroupedApplyEnterLeave", CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constant(this.aggGroupByDesc.getNumMethods()), CodegenExpressionBuilder.constant(this.aggGroupByDesc.getNumAccess()), AggregationServiceCodegenNames.REF_GROUPKEY));
        if (this.aggGroupByDesc.isReclaimAged()) {
            AggSvcGroupByReclaimAgedImpl.applyEnterCodegenSweep(method, classScope, classNames);
        }
        if (this.hasRefCounting()) {
            method.getBlock().localMethod(this.handleRemovedKeysCodegen(method, classScope), new CodegenExpression[0]);
        }
        CodegenBlock block = method.getBlock().assignRef(MEMBER_CURRENTROW, CodegenExpressionBuilder.cast(classNames.getRowTop(), CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "get", AggregationServiceCodegenNames.REF_GROUPKEY)));
        block.ifCondition(CodegenExpressionBuilder.equalsNull(MEMBER_CURRENTROW)).assignRef(MEMBER_CURRENTROW, CodegenExpressionBuilder.newInstance(classNames.getRowTop(), new CodegenExpression[0])).exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "put", AggregationServiceCodegenNames.REF_GROUPKEY, MEMBER_CURRENTROW);
        if (this.hasRefCounting()) {
            block.exprDotMethod(MEMBER_CURRENTROW, "increaseRefcount", new CodegenExpression[0]);
        }
        if (this.aggGroupByDesc.isReclaimAged()) {
            block.exprDotMethod(MEMBER_CURRENTROW, "setLastUpdateTime", CodegenExpressionBuilder.ref("currentTime"));
        }
        block.exprDotMethod(MEMBER_CURRENTROW, "applyEnter", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT).apply(InstrumentationCode.instblock(classScope, "aAggregationGroupedApplyEnterLeave", CodegenExpressionBuilder.constantTrue()));
    }

    @Override
    public void applyLeaveCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods, AggregationClassNames classNames) {
        method.getBlock().apply(InstrumentationCode.instblock(classScope, "qAggregationGroupedApplyEnterLeave", CodegenExpressionBuilder.constantFalse(), CodegenExpressionBuilder.constant(this.aggGroupByDesc.getNumMethods()), CodegenExpressionBuilder.constant(this.aggGroupByDesc.getNumAccess()), AggregationServiceCodegenNames.REF_GROUPKEY)).assignRef(MEMBER_CURRENTROW, CodegenExpressionBuilder.cast(classNames.getRowTop(), CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "get", AggregationServiceCodegenNames.REF_GROUPKEY))).ifCondition(CodegenExpressionBuilder.equalsNull(MEMBER_CURRENTROW)).assignRef(MEMBER_CURRENTROW, CodegenExpressionBuilder.newInstance(classNames.getRowTop(), new CodegenExpression[0])).exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "put", AggregationServiceCodegenNames.REF_GROUPKEY, MEMBER_CURRENTROW);
        if (this.hasRefCounting()) {
            method.getBlock().exprDotMethod(MEMBER_CURRENTROW, "decreaseRefcount", new CodegenExpression[0]);
        }
        if (this.aggGroupByDesc.isReclaimAged()) {
            method.getBlock().exprDotMethod(MEMBER_CURRENTROW, "setLastUpdateTime", CodegenExpressionBuilder.exprDotMethodChain(ExprForgeCodegenNames.REF_EXPREVALCONTEXT).add("getTimeProvider", new CodegenExpression[0]).add("getTime", new CodegenExpression[0]));
        }
        method.getBlock().exprDotMethod(MEMBER_CURRENTROW, "applyLeave", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
        if (this.hasRefCounting()) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(MEMBER_CURRENTROW, "getRefcount", new CodegenExpression[0]), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0))).exprDotMethod(MEMBER_REMOVEDKEYS, "add", AggregationServiceCodegenNames.REF_GROUPKEY);
        }
        method.getBlock().apply(InstrumentationCode.instblock(classScope, "aAggregationGroupedApplyEnterLeave", CodegenExpressionBuilder.constantFalse()));
    }

    @Override
    public void stopMethodCodegen(AggregationServiceFactoryForgeWMethodGen forge, CodegenMethod method) {
    }

    @Override
    public void setRemovedCallbackCodegen(CodegenMethod method) {
        if (this.aggGroupByDesc.isReclaimAged()) {
            method.getBlock().assignRef("removedCallback", (CodegenExpression)AggregationServiceCodegenNames.REF_CALLBACK);
        }
    }

    @Override
    public void setCurrentAccessCodegen(CodegenMethod method, CodegenClassScope classScope, AggregationClassNames classNames) {
        method.getBlock().assignRef(MEMBER_CURRENTGROUPKEY, (CodegenExpression)AggregationServiceCodegenNames.REF_GROUPKEY).assignRef(MEMBER_CURRENTROW, CodegenExpressionBuilder.cast(classNames.getRowTop(), CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "get", AggregationServiceCodegenNames.REF_GROUPKEY))).ifCondition(CodegenExpressionBuilder.equalsNull(MEMBER_CURRENTROW)).assignRef(MEMBER_CURRENTROW, CodegenExpressionBuilder.newInstance(classNames.getRowTop(), new CodegenExpression[0]));
    }

    @Override
    public void clearResultsCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "clear", new CodegenExpression[0]);
    }

    @Override
    public AggregationCodegenRowLevelDesc getRowLevelDesc() {
        return AggregationCodegenRowLevelDesc.fromTopOnly(this.aggGroupByDesc.getRowStateForgeDescs());
    }

    @Override
    public void acceptCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitAggregations", CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "size", new CodegenExpression[0]), MEMBER_AGGREGATORSPERGROUP);
    }

    @Override
    public void getGroupKeysCodegen(CodegenMethod method, CodegenClassScope classScope) {
        if (this.aggGroupByDesc.isRefcounted()) {
            method.getBlock().localMethod(this.handleRemovedKeysCodegen(method, classScope), new CodegenExpression[0]);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "keySet", new CodegenExpression[0]));
    }

    @Override
    public void getGroupKeyCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(MEMBER_CURRENTGROUPKEY);
    }

    @Override
    public void acceptGroupDetailCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGrouped", CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "size", new CodegenExpression[0])).forEach(Map.Entry.class, "entry", CodegenExpressionBuilder.exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "entrySet", new CodegenExpression[0])).exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGroup", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getKey", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getValue", new CodegenExpression[0]));
    }

    @Override
    public void isGroupedCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.constantTrue());
    }

    @Override
    public void getRowCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(MEMBER_CURRENTROW);
    }

    private boolean hasRefCounting() {
        return this.aggGroupByDesc.isRefcounted() || this.aggGroupByDesc.isReclaimAged();
    }

    private CodegenMethod handleRemovedKeysCodegen(CodegenMethod scope, CodegenClassScope classScope) {
        CodegenMethod method = scope.makeChild(Void.TYPE, AggregationServiceGroupByForge.class, (CodegenScope)classScope);
        method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(MEMBER_REMOVEDKEYS, "isEmpty", new CodegenExpression[0]))).forEach(Object.class, "removedKey", MEMBER_REMOVEDKEYS).exprDotMethod(MEMBER_AGGREGATORSPERGROUP, "remove", CodegenExpressionBuilder.ref("removedKey")).blockEnd().exprDotMethod(MEMBER_REMOVEDKEYS, "clear", new CodegenExpression[0]);
        return method;
    }
}

