/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.median;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.SortedDoubleVector;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodWDistinctWFilterWValueBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AggregatorMedian
extends AggregatorMethodWDistinctWFilterWValueBase {
    protected CodegenExpressionMember vector;

    public AggregatorMedian(AggregationForgeFactory factory, int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope, Class optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter) {
        super(factory, col, rowCtor, membersColumnized, classScope, optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter);
        this.vector = membersColumnized.addMember(col, SortedDoubleVector.class, "vector");
        rowCtor.getBlock().assignRef(this.vector, CodegenExpressionBuilder.newInstance(SortedDoubleVector.class, new CodegenExpression[0]));
    }

    @Override
    protected void applyEvalEnterNonNull(CodegenExpressionRef value, Class valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(this.vector, "add", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value, valueType));
    }

    @Override
    protected void applyEvalLeaveNonNull(CodegenExpressionRef value, Class valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(this.vector, "remove", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value, valueType));
    }

    @Override
    protected void applyTableEnterNonNull(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(this.vector, "add", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, (CodegenExpression)value), "doubleValue", new CodegenExpression[0]));
    }

    @Override
    protected void applyTableLeaveNonNull(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(this.vector, "remove", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, (CodegenExpression)value), "doubleValue", new CodegenExpression[0]));
    }

    @Override
    protected void clearWODistinct(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(this.vector, "clear", new CodegenExpression[0]);
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(AggregatorMedian.class, "medianCompute", this.vector));
    }

    @Override
    protected void writeWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef output, CodegenExpressionRef unitKey, CodegenExpressionRef writer, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().staticMethod(this.getClass(), "writePoints", output, AggregatorCodegenUtil.rowDotMember(row, this.vector));
    }

    @Override
    protected void readWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef input, CodegenExpressionRef unitKey, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(AggregatorCodegenUtil.rowDotMember(row, this.vector), CodegenExpressionBuilder.staticMethod(this.getClass(), "readPoints", input));
    }

    public static void writePoints(DataOutput output, SortedDoubleVector vector) throws IOException {
        output.writeInt(vector.getValues().size());
        for (double num : vector.getValues()) {
            output.writeDouble(num);
        }
    }

    public static SortedDoubleVector readPoints(DataInput input) throws IOException {
        SortedDoubleVector points = new SortedDoubleVector();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            double d = input.readDouble();
            points.add(d);
        }
        return points;
    }

    public static Object medianCompute(SortedDoubleVector vector) {
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return vector.getValue(0);
        }
        int middle = vector.size() >> 1;
        if (vector.size() % 2 == 0) {
            return (vector.getValue(middle - 1) + vector.getValue(middle)) / 2.0;
        }
        return vector.getValue(middle);
    }
}

