/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.sum;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregationForgeFactoryBase;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethod;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregationPortableValidationSum;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumBig;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumNonBig;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprMethodAggUtil;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprSumNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AggregationForgeFactorySum
extends AggregationForgeFactoryBase {
    protected final ExprSumNode parent;
    protected final Class resultType;
    protected final Class inputValueType;
    protected final DataInputOutputSerdeForge distinctSerde;
    protected AggregatorMethod aggregator;

    public AggregationForgeFactorySum(ExprSumNode parent, Class inputValueType, DataInputOutputSerdeForge distinctSerde) {
        this.parent = parent;
        this.inputValueType = inputValueType;
        this.distinctSerde = distinctSerde;
        this.resultType = this.getSumAggregatorType(inputValueType);
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void initMethodForge(int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope) {
        Class distinctValueType = !this.parent.isDistinct() ? null : this.inputValueType;
        this.aggregator = this.resultType == BigInteger.class || this.resultType == BigDecimal.class ? new AggregatorSumBig(this, col, rowCtor, membersColumnized, classScope, distinctValueType, this.distinctSerde, this.parent.isHasFilter(), this.parent.getOptionalFilter(), this.resultType) : new AggregatorSumNonBig(this, col, rowCtor, membersColumnized, classScope, distinctValueType, this.distinctSerde, this.parent.isHasFilter(), this.parent.getOptionalFilter(), this.resultType);
    }

    @Override
    public AggregatorMethod getAggregator() {
        return this.aggregator;
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    @Override
    public AggregationPortableValidation getAggregationPortableValidation() {
        return new AggregationPortableValidationSum(this.parent.isDistinct(), this.parent.isHasFilter(), this.inputValueType);
    }

    private Class getSumAggregatorType(Class type) {
        if (type == BigInteger.class) {
            return BigInteger.class;
        }
        if (type == BigDecimal.class) {
            return BigDecimal.class;
        }
        return JavaClassHelper.getBoxedType(AggregationForgeFactorySum.getMemberType(type));
    }

    protected static SimpleNumberCoercer getCoercerNonBigIntDec(Class inputValueType) {
        SimpleNumberCoercer coercer = inputValueType == Long.class || inputValueType == Long.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerLong.INSTANCE : (inputValueType == Integer.class || inputValueType == Integer.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerInt.INSTANCE : (inputValueType == Double.class || inputValueType == Double.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.INSTANCE : (inputValueType == Float.class || inputValueType == Float.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerFloat.INSTANCE : SimpleNumberCoercerFactory.SimpleNumberCoercerInt.INSTANCE)));
        return coercer;
    }

    protected static Class getMemberType(Class inputValueType) {
        if (inputValueType == Long.class || inputValueType == Long.TYPE) {
            return Long.TYPE;
        }
        if (inputValueType == Integer.class || inputValueType == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (inputValueType == Double.class || inputValueType == Double.TYPE) {
            return Double.TYPE;
        }
        if (inputValueType == Float.class || inputValueType == Float.TYPE) {
            return Float.TYPE;
        }
        return Integer.TYPE;
    }
}

