/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.sum;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalBigIntegerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AggregatorSumBig
extends AggregatorSumBase {
    public AggregatorSumBig(AggregationForgeFactory factory, int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope, Class optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter, Class sumType) {
        super(factory, col, rowCtor, membersColumnized, classScope, optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter, sumType);
        if (sumType != BigInteger.class && sumType != BigDecimal.class) {
            throw new IllegalArgumentException("Invalid type " + sumType);
        }
    }

    @Override
    protected CodegenExpression initOfSum() {
        return this.sumType == BigInteger.class ? CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.constant(0)) : CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0));
    }

    @Override
    protected void applyAggEnterSum(CodegenExpressionRef value, Class valueType, CodegenMethod method) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", valueType == this.sumType ? value : CodegenExpressionBuilder.cast(this.sumType, (CodegenExpression)value)));
    }

    @Override
    protected void applyAggLeaveSum(CodegenExpressionRef value, Class valueType, CodegenMethod method) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", valueType == this.sumType ? value : CodegenExpressionBuilder.cast(this.sumType, (CodegenExpression)value)));
    }

    @Override
    protected void applyTableEnterSum(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", CodegenExpressionBuilder.cast(evaluationTypes[0], (CodegenExpression)value)));
    }

    @Override
    protected void applyTableLeaveSum(CodegenExpressionRef value, Class[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", CodegenExpressionBuilder.cast(evaluationTypes[0], (CodegenExpression)value)));
    }

    @Override
    protected void writeSum(CodegenExpressionRef row, CodegenExpressionRef output, CodegenMethod method, CodegenClassScope classScope) {
        if (this.sumType == BigInteger.class) {
            method.getBlock().staticMethod(DIOBigDecimalBigIntegerUtil.class, "writeBigInt", AggregatorCodegenUtil.rowDotMember(row, this.sum), output);
        } else {
            method.getBlock().staticMethod(DIOBigDecimalBigIntegerUtil.class, "writeBigDec", AggregatorCodegenUtil.rowDotMember(row, this.sum), output);
        }
    }

    @Override
    protected void readSum(CodegenExpressionRef row, CodegenExpressionRef input, CodegenMethod method, CodegenClassScope classScope) {
        if (this.sumType == BigInteger.class) {
            method.getBlock().assignRef(AggregatorCodegenUtil.rowDotMember(row, this.sum), CodegenExpressionBuilder.staticMethod(DIOBigDecimalBigIntegerUtil.class, "readBigInt", input));
        } else {
            method.getBlock().assignRef(AggregatorCodegenUtil.rowDotMember(row, this.sum), CodegenExpressionBuilder.staticMethod(DIOBigDecimalBigIntegerUtil.class, "readBigDec", input));
        }
    }
}

