/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.annotation;

import com.espertech.esper.common.client.annotation.Audit;
import com.espertech.esper.common.client.annotation.AvroSchemaField;
import com.espertech.esper.common.client.annotation.BusEventType;
import com.espertech.esper.common.client.annotation.Description;
import com.espertech.esper.common.client.annotation.Drop;
import com.espertech.esper.common.client.annotation.EventRepresentation;
import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.client.annotation.Hook;
import com.espertech.esper.common.client.annotation.HookType;
import com.espertech.esper.common.client.annotation.IterableUnbound;
import com.espertech.esper.common.client.annotation.JsonSchema;
import com.espertech.esper.common.client.annotation.Name;
import com.espertech.esper.common.client.annotation.NoLock;
import com.espertech.esper.common.client.annotation.Priority;
import com.espertech.esper.common.client.annotation.Private;
import com.espertech.esper.common.client.annotation.Protected;
import com.espertech.esper.common.client.annotation.Public;
import com.espertech.esper.common.client.annotation.Tag;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.AnnotationDesc;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.epl.annotation.AnnotationAttribute;
import com.espertech.esper.common.internal.epl.annotation.AnnotationException;
import com.espertech.esper.common.internal.epl.annotation.EPLAnnotationInvocationHandler;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.type.AnnotationAudit;
import com.espertech.esper.common.internal.type.AnnotationBusEventType;
import com.espertech.esper.common.internal.type.AnnotationDescription;
import com.espertech.esper.common.internal.type.AnnotationDrop;
import com.espertech.esper.common.internal.type.AnnotationEventRepresentation;
import com.espertech.esper.common.internal.type.AnnotationHint;
import com.espertech.esper.common.internal.type.AnnotationHook;
import com.espertech.esper.common.internal.type.AnnotationIterableUnbound;
import com.espertech.esper.common.internal.type.AnnotationJsonSchema;
import com.espertech.esper.common.internal.type.AnnotationName;
import com.espertech.esper.common.internal.type.AnnotationNoLock;
import com.espertech.esper.common.internal.type.AnnotationPriority;
import com.espertech.esper.common.internal.type.AnnotationPrivate;
import com.espertech.esper.common.internal.type.AnnotationProtected;
import com.espertech.esper.common.internal.type.AnnotationPublic;
import com.espertech.esper.common.internal.type.AnnotationTag;
import com.espertech.esper.common.internal.type.AvroSchemaFieldHook;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    private static final Logger log = LoggerFactory.getLogger(AnnotationUtil.class);

    public static Map<String, List<AnnotationDesc>> mapByNameLowerCase(List<AnnotationDesc> annotations) {
        HashMap<String, List<AnnotationDesc>> map = new HashMap<String, List<AnnotationDesc>>();
        for (AnnotationDesc desc : annotations) {
            String key = desc.getName().toLowerCase(Locale.ENGLISH);
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(desc);
                continue;
            }
            ArrayList<AnnotationDesc> annos = new ArrayList<AnnotationDesc>(2);
            annos.add(desc);
            map.put(key, annos);
        }
        return map;
    }

    public static Object getValue(AnnotationDesc desc) {
        for (Pair<String, Object> pair : desc.getAttributes()) {
            if (!pair.getFirst().toLowerCase(Locale.ENGLISH).equals("value")) continue;
            return pair.getSecond();
        }
        return null;
    }

    public static Annotation[] compileAnnotations(List<AnnotationDesc> annotationSpec, ClasspathImportServiceCompileTime classpathImportService, Compilable compilable) throws StatementSpecCompileException {
        Annotation[] annotations;
        try {
            annotations = AnnotationUtil.compileAnnotations(annotationSpec, classpathImportService);
        }
        catch (AnnotationException e) {
            throw new StatementSpecCompileException("Failed to process statement annotations: " + e.getMessage(), e, compilable.toEPL());
        }
        catch (RuntimeException ex) {
            String message = "Unexpected exception compiling annotations in statement, please consult the log file and report the exception: " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new StatementSpecCompileException(message, ex, compilable.toEPL());
        }
        return annotations;
    }

    public static CodegenMethod makeAnnotations(Class arrayType, Annotation[] annotations, CodegenMethod parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(arrayType, AnnotationUtil.class, (CodegenScope)classScope);
        method.getBlock().declareVar(arrayType, "annotations", CodegenExpressionBuilder.newArrayByLength(arrayType.getComponentType(), CodegenExpressionBuilder.constant(annotations.length)));
        for (int i = 0; i < annotations.length; ++i) {
            method.getBlock().assignArrayElement("annotations", CodegenExpressionBuilder.constant(i), AnnotationUtil.makeAnnotation(annotations[i], parent, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("annotations"));
        return method;
    }

    private static Annotation[] compileAnnotations(List<AnnotationDesc> desc, ClasspathImportServiceCompileTime classpathImportService) throws AnnotationException {
        Annotation[] annotations = new Annotation[desc.size()];
        for (int i = 0; i < desc.size(); ++i) {
            annotations[i] = AnnotationUtil.createProxy(desc.get(i), classpathImportService);
            if (!(annotations[i] instanceof Hint)) continue;
            HintEnum.validateGetListed(annotations[i]);
        }
        return annotations;
    }

    private static Annotation createProxy(AnnotationDesc desc, ClasspathImportServiceCompileTime classpathImportService) throws AnnotationException {
        Class annotationClass;
        try {
            annotationClass = classpathImportService.resolveAnnotation(desc.getName());
        }
        catch (ClasspathImportException e) {
            throw new AnnotationException("Failed to resolve @-annotation class: " + e.getMessage());
        }
        List<AnnotationAttribute> annotationAttributeLists = AnnotationUtil.getAttributes(annotationClass);
        HashSet<String> allAttributes = new HashSet<String>();
        LinkedHashSet<String> requiredAttributes = new LinkedHashSet<String>();
        for (AnnotationAttribute annotationAttribute : annotationAttributeLists) {
            allAttributes.add(annotationAttribute.getName());
            if (annotationAttribute.getDefaultValue() == null) continue;
            requiredAttributes.add(annotationAttribute.getName());
        }
        ArrayList<String> providedValues = new ArrayList<String>();
        for (Pair<String, Object> pair : desc.getAttributes()) {
            providedValues.add(pair.getFirst());
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (AnnotationAttribute annotationAttribute : annotationAttributeLists) {
            String attributeName = annotationAttribute.getName();
            Pair<String, Object> pairFound = null;
            for (Pair<String, Object> annotationValuePair : desc.getAttributes()) {
                if (!annotationValuePair.getFirst().equals(attributeName)) continue;
                pairFound = annotationValuePair;
            }
            Object valueProvided = pairFound == null ? null : pairFound.getSecond();
            Object value = AnnotationUtil.getFinalValue(annotationClass, annotationAttribute, valueProvided, classpathImportService);
            linkedHashMap.put(attributeName, value);
            providedValues.remove(attributeName);
            requiredAttributes.remove(attributeName);
        }
        if (requiredAttributes.size() > 0) {
            ArrayList arrayList = new ArrayList(requiredAttributes);
            Collections.sort(arrayList);
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a value for attribute '" + (String)arrayList.iterator().next() + "'");
        }
        if (providedValues.size() > 0) {
            ArrayList arrayList = new ArrayList(providedValues);
            Collections.sort(arrayList);
            if (allAttributes.contains(arrayList.get(0))) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' has duplicate attribute values for attribute '" + (String)arrayList.get(0) + "'");
            }
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' does not have an attribute '" + (String)arrayList.get(0) + "'");
        }
        EPLAnnotationInvocationHandler ePLAnnotationInvocationHandler = new EPLAnnotationInvocationHandler(annotationClass, linkedHashMap);
        return (Annotation)Proxy.newProxyInstance(classpathImportService.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)ePLAnnotationInvocationHandler);
    }

    private static Object getFinalValue(Class annotationClass, AnnotationAttribute annotationAttribute, Object value, ClasspathImportServiceCompileTime classpathImportService) throws AnnotationException {
        if (value == null) {
            if (annotationAttribute.getDefaultValue() == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a value for attribute '" + annotationAttribute.getName() + "'");
            }
            return annotationAttribute.getDefaultValue();
        }
        if (!annotationAttribute.getType().isArray()) {
            if (!annotationAttribute.getType().isAnnotation()) {
                if (annotationAttribute.getType().isEnum() && JavaClassHelper.isImplementsInterface(value.getClass(), CharSequence.class)) {
                    String valueString = value.toString().trim();
                    for (Object constant : annotationAttribute.getType().getEnumConstants()) {
                        Enum e = (Enum)constant;
                        if (!e.name().equals(valueString)) continue;
                        return constant;
                    }
                    String valueUppercase = valueString.toUpperCase(Locale.ENGLISH);
                    for (Object constant : annotationAttribute.getType().getEnumConstants()) {
                        Enum e = (Enum)constant;
                        if (!e.name().toUpperCase(Locale.ENGLISH).equals(valueUppercase)) continue;
                        return constant;
                    }
                    throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires an enum-value '" + annotationAttribute.getType().getSimpleName() + "' for attribute '" + annotationAttribute.getName() + "' but received '" + value + "' which is not one of the enum choices");
                }
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(value.getClass(), annotationAttribute.getType());
                Object finalValue = caster.cast(value);
                if (finalValue == null) {
                    throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received a " + value.getClass().getSimpleName() + "-typed value");
                }
                return finalValue;
            }
            if (!(value instanceof AnnotationDesc)) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received a " + value.getClass().getSimpleName() + "-typed value");
            }
            return AnnotationUtil.createProxy((AnnotationDesc)value, classpathImportService);
        }
        if (!value.getClass().isArray()) {
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received a " + value.getClass().getSimpleName() + "-typed value");
        }
        Class<?> componentType = annotationAttribute.getType().getComponentType();
        Object array = Array.newInstance(componentType, Array.getLength(value));
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object finalValue;
            Object arrayValue = Array.get(value, i);
            if (arrayValue == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a non-null value for array elements for attribute '" + annotationAttribute.getName() + "'");
            }
            if (arrayValue instanceof AnnotationDesc) {
                Annotation inner = AnnotationUtil.createProxy((AnnotationDesc)arrayValue, classpathImportService);
                if (inner.annotationType() != componentType) {
                    throw AnnotationUtil.makeArrayMismatchException(annotationClass, componentType, annotationAttribute.getName(), inner.annotationType());
                }
                finalValue = inner;
            } else {
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(arrayValue.getClass(), annotationAttribute.getType().getComponentType());
                finalValue = caster.cast(arrayValue);
                if (finalValue == null) {
                    throw AnnotationUtil.makeArrayMismatchException(annotationClass, componentType, annotationAttribute.getName(), arrayValue.getClass());
                }
            }
            Array.set(array, i, finalValue);
        }
        return array;
    }

    private static List<AnnotationAttribute> getAttributes(Class annotationClass) {
        ArrayList<AnnotationAttribute> props = new ArrayList<AnnotationAttribute>();
        Method[] methods = annotationClass.getMethods();
        if (methods == null) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getReturnType() == Void.TYPE || methods[i].getParameterTypes().length > 0 || methods[i].getName().equals("class") || methods[i].getName().equals("getClass") || methods[i].getName().equals("toString") || methods[i].getName().equals("annotationType") || methods[i].getName().equals("hashCode")) continue;
            props.add(new AnnotationAttribute(methods[i].getName(), methods[i].getReturnType(), methods[i].getDefaultValue()));
        }
        Collections.sort(props, new Comparator<AnnotationAttribute>(){

            @Override
            public int compare(AnnotationAttribute o1, AnnotationAttribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return props;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotationClass.getName() + " is not an annotation class");
        }
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        for (Annotation anno : annotations) {
            if (JavaClassHelper.isImplementsInterface(anno.getClass(), annotationClass)) {
                return true;
            }
            Annotation[] declared = anno.annotationType().getDeclaredAnnotations();
            if (declared == null || declared.length <= 0 || !AnnotationUtil.hasAnnotationDeclared(declared, annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static Annotation findAnnotation(Annotation[] annotations, Class annotationClass) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotationClass.getName() + " is not an annotation class");
        }
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation anno : annotations) {
            if (!JavaClassHelper.isImplementsInterface(anno.getClass(), annotationClass)) continue;
            return anno;
        }
        return null;
    }

    private static boolean hasAnnotationDeclared(Annotation[] annotations, Class<? extends Annotation> target) {
        return AnnotationUtil.hasAnnotationDeclaredRecursive(annotations, target, new HashSet<Annotation>());
    }

    private static boolean hasAnnotationDeclaredRecursive(Annotation[] annotations, Class<? extends Annotation> target, Set<Annotation> visited) {
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == target) {
                return true;
            }
            if (!visited.add(annotation)) {
                return false;
            }
            Annotation[] declared = annotationType.getDeclaredAnnotations();
            if (!AnnotationUtil.hasAnnotationDeclaredRecursive(declared, target, visited)) continue;
            return true;
        }
        return false;
    }

    public static List<Annotation> findAnnotations(Annotation[] annotations, Class annotationClass) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotationClass.getName() + " is not an annotation class");
        }
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        ArrayList<Annotation> annotationsList = new ArrayList<Annotation>();
        for (Annotation anno : annotations) {
            if (!JavaClassHelper.isImplementsInterface(anno.getClass(), annotationClass)) continue;
            annotationsList.add(anno);
        }
        return annotationsList;
    }

    public static Annotation[] mergeAnnotations(Annotation[] first, Annotation[] second) {
        return (Annotation[])CollectionUtil.addArrays(first, second);
    }

    public static String getExpectSingleStringValue(String msgPrefix, List<AnnotationDesc> annotationsSameName) throws ExprValidationException {
        if (annotationsSameName.size() > 1) {
            throw new ExprValidationException(msgPrefix + " multiple annotations provided named '" + annotationsSameName.get(0).getName() + "'");
        }
        AnnotationDesc annotation = annotationsSameName.get(0);
        Object value = AnnotationUtil.getValue(annotation);
        if (value == null) {
            throw new ExprValidationException(msgPrefix + " no value provided for annotation '" + annotation.getName() + "', expected a value");
        }
        if (!(value instanceof String)) {
            throw new ExprValidationException(msgPrefix + " string value expected for annotation '" + annotation.getName() + "'");
        }
        return (String)value;
    }

    private static AnnotationException makeArrayMismatchException(Class annotationClass, Class componentType, String attributeName, Class unexpected) {
        return new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + componentType.getSimpleName() + "-typed value for array elements for attribute '" + attributeName + "' but received a " + unexpected.getSimpleName() + "-typed value");
    }

    private static CodegenExpression makeAnnotation(Annotation annotation, CodegenMethod parent, CodegenClassScope codegenClassScope) {
        if (annotation == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (annotation instanceof Name) {
            return CodegenExpressionBuilder.newInstance(AnnotationName.class, CodegenExpressionBuilder.constant(((Name)annotation).value()));
        }
        if (annotation instanceof Priority) {
            return CodegenExpressionBuilder.newInstance(AnnotationPriority.class, CodegenExpressionBuilder.constant(((Priority)annotation).value()));
        }
        if (annotation instanceof Tag) {
            Tag tag = (Tag)annotation;
            return CodegenExpressionBuilder.newInstance(AnnotationTag.class, CodegenExpressionBuilder.constant(tag.name()), CodegenExpressionBuilder.constant(tag.value()));
        }
        if (annotation instanceof Drop) {
            return CodegenExpressionBuilder.newInstance(AnnotationDrop.class, new CodegenExpression[0]);
        }
        if (annotation instanceof Description) {
            return CodegenExpressionBuilder.newInstance(AnnotationDescription.class, CodegenExpressionBuilder.constant(((Description)annotation).value()));
        }
        if (annotation instanceof Hint) {
            Hint hint = (Hint)annotation;
            return CodegenExpressionBuilder.newInstance(AnnotationHint.class, CodegenExpressionBuilder.constant(hint.value()), CodegenExpressionBuilder.constant((Object)hint.applies()), CodegenExpressionBuilder.constant(hint.model()));
        }
        if (annotation instanceof NoLock) {
            return CodegenExpressionBuilder.newInstance(AnnotationNoLock.class, new CodegenExpression[0]);
        }
        if (annotation instanceof Audit) {
            Audit hint = (Audit)annotation;
            return CodegenExpressionBuilder.newInstance(AnnotationAudit.class, CodegenExpressionBuilder.constant(hint.value()));
        }
        if (annotation instanceof EventRepresentation) {
            EventRepresentation anno = (EventRepresentation)annotation;
            return CodegenExpressionBuilder.newInstance(AnnotationEventRepresentation.class, CodegenExpressionBuilder.enumValue(((Object)((Object)anno.value())).getClass(), anno.value().name()));
        }
        if (annotation instanceof IterableUnbound) {
            return CodegenExpressionBuilder.newInstance(AnnotationIterableUnbound.class, new CodegenExpression[0]);
        }
        if (annotation instanceof Hook) {
            Hook hook = (Hook)annotation;
            return CodegenExpressionBuilder.newInstance(AnnotationHook.class, CodegenExpressionBuilder.enumValue(HookType.class, hook.type().name()), CodegenExpressionBuilder.constant(hook.hook()));
        }
        if (annotation instanceof AvroSchemaField) {
            AvroSchemaField field = (AvroSchemaField)annotation;
            return CodegenExpressionBuilder.newInstance(AvroSchemaFieldHook.class, CodegenExpressionBuilder.constant(field.name()), CodegenExpressionBuilder.constant(field.schema()));
        }
        if (annotation instanceof Private) {
            return CodegenExpressionBuilder.newInstance(AnnotationPrivate.class, new CodegenExpression[0]);
        }
        if (annotation instanceof Protected) {
            return CodegenExpressionBuilder.newInstance(AnnotationProtected.class, new CodegenExpression[0]);
        }
        if (annotation instanceof Public) {
            return CodegenExpressionBuilder.newInstance(AnnotationPublic.class, new CodegenExpression[0]);
        }
        if (annotation instanceof BusEventType) {
            return CodegenExpressionBuilder.newInstance(AnnotationBusEventType.class, new CodegenExpression[0]);
        }
        if (annotation instanceof JsonSchema) {
            return CodegenExpressionBuilder.newInstance(AnnotationJsonSchema.class, CodegenExpressionBuilder.constant(((JsonSchema)annotation).dynamic()));
        }
        if (annotation.annotationType().getPackage().equals(Name.class.getPackage())) {
            throw new IllegalStateException("Unrecognized annotation residing in the '" + Name.class.getPackage() + " package having type" + annotation.annotationType().getName());
        }
        EPLAnnotationInvocationHandler innerProxy = (EPLAnnotationInvocationHandler)Proxy.getInvocationHandler(annotation);
        CodegenMethod methodNode = parent.makeChild(Annotation.class, AnnotationUtil.class, (CodegenScope)codegenClassScope);
        CodegenExpressionNewAnonymousClass clazz = CodegenExpressionBuilder.newAnonymousClass(methodNode.getBlock(), annotation.annotationType());
        CodegenMethod annotationType = CodegenMethod.makeParentNode(Class.class, AnnotationUtil.class, codegenClassScope);
        clazz.addMethod("annotationType", annotationType);
        annotationType.getBlock().methodReturn(CodegenExpressionBuilder.clazz(innerProxy.getAnnotationClass()));
        for (Method method : innerProxy.getAnnotationClass().getMethods()) {
            if (method.getName().equals("equals") || method.getName().equals("hashCode") || method.getName().equals("toString") || method.getName().equals("annotationType")) continue;
            CodegenMethod annotationValue = CodegenMethod.makeParentNode(method.getReturnType(), AnnotationUtil.class, codegenClassScope);
            Object value = innerProxy.getAttributes().get(method.getName());
            clazz.addMethod(method.getName(), annotationValue);
            CodegenExpression valueExpression = value == null ? CodegenExpressionBuilder.constantNull() : (method.getReturnType() == Class.class ? CodegenExpressionBuilder.clazz((Class)value) : (method.getReturnType().isArray() && method.getReturnType().getComponentType().isAnnotation() ? CodegenExpressionBuilder.localMethod(AnnotationUtil.makeAnnotations(method.getReturnType(), (Annotation[])value, methodNode, codegenClassScope), new CodegenExpression[0]) : (!method.getReturnType().isAnnotation() ? CodegenExpressionBuilder.constant(value) : CodegenExpressionBuilder.cast(method.getReturnType(), AnnotationUtil.makeAnnotation((Annotation)value, methodNode, codegenClassScope)))));
            annotationValue.getBlock().methodReturn(valueExpression);
        }
        methodNode.getBlock().methodReturn(clazz);
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

