/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.approx.countminsketch;

import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchSpec;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchStateHashes;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchStateTopk;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

public class CountMinSketchState {
    private CountMinSketchStateHashes hashes;
    private CountMinSketchStateTopk topk;

    public static CountMinSketchState makeState(CountMinSketchSpec spec) {
        CountMinSketchStateHashes hashes = CountMinSketchStateHashes.makeState(spec.getHashesSpec());
        CountMinSketchStateTopk topk = null;
        if (spec.getTopkSpec() != null && spec.getTopkSpec() > 0) {
            topk = new CountMinSketchStateTopk(spec.getTopkSpec());
        }
        return new CountMinSketchState(hashes, topk);
    }

    public CountMinSketchState(CountMinSketchStateHashes hashes, CountMinSketchStateTopk topk) {
        this.hashes = hashes;
        this.topk = topk;
    }

    public void add(byte[] bytes, int count) {
        this.hashes.add(bytes, count);
        if (this.topk != null) {
            long frequency = this.hashes.estimateCount(bytes);
            this.topk.updateExpectIncreasing(bytes, frequency);
        }
    }

    public long frequency(byte[] bytes) {
        return this.hashes.estimateCount(bytes);
    }

    public Collection<ByteBuffer> getTopKValues() {
        if (this.topk == null) {
            return Collections.emptyList();
        }
        return this.topk.getTopKValues();
    }

    public CountMinSketchStateHashes getHashes() {
        return this.hashes;
    }

    public CountMinSketchStateTopk getTopk() {
        return this.topk;
    }

    public void setHashes(CountMinSketchStateHashes hashes) {
        this.hashes = hashes;
    }

    public void setTopk(CountMinSketchStateTopk topk) {
        this.topk = topk;
    }
}

