/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.contained;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.contained.ContainedEventEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.filterspec.PropertyEvaluator;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;

public class PropertyEvaluatorNested
implements PropertyEvaluator {
    private ContainedEventEval[] containedEventEvals;
    private boolean[] fragmentEventTypeIsIndexed;
    private ExprEvaluator[] whereClauses;
    private EventBean[] eventsPerStream;
    private String[] expressionTexts;
    private EventType resultEventType;

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean> resultEvents = new ArrayDeque<EventBean>();
        this.eventsPerStream[0] = theEvent;
        this.populateEvents(theEvent, 0, resultEvents, exprEvaluatorContext);
        if (resultEvents.isEmpty()) {
            return null;
        }
        return resultEvents.toArray(new EventBean[resultEvents.size()]);
    }

    @Override
    public EventType getFragmentEventType() {
        return this.resultEventType;
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        return false;
    }

    public void setContainedEventEvals(ContainedEventEval[] containedEventEvals) {
        this.containedEventEvals = containedEventEvals;
    }

    public void setFragmentEventTypeIsIndexed(boolean[] fragmentEventTypeIsIndexed) {
        this.fragmentEventTypeIsIndexed = fragmentEventTypeIsIndexed;
        this.eventsPerStream = new EventBean[fragmentEventTypeIsIndexed.length + 1];
    }

    public void setWhereClauses(ExprEvaluator[] whereClauses) {
        this.whereClauses = whereClauses;
    }

    public void setExpressionTexts(String[] expressionTexts) {
        this.expressionTexts = expressionTexts;
    }

    public void setResultEventType(EventType resultEventType) {
        this.resultEventType = resultEventType;
    }

    private void populateEvents(EventBean branch, int level, Collection<EventBean> events, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEvals[level].getFragment(branch, this.eventsPerStream, exprEvaluatorContext);
            int lastLevel = this.fragmentEventTypeIsIndexed.length - 1;
            if (this.fragmentEventTypeIsIndexed[level]) {
                EventBean[] fragments = (EventBean[])result;
                if (level == lastLevel) {
                    if (this.whereClauses[level] != null) {
                        EventBean[] eventBeanArray = fragments;
                        int n = eventBeanArray.length;
                        for (int i = 0; i < n; ++i) {
                            EventBean theEvent;
                            this.eventsPerStream[level + 1] = theEvent = eventBeanArray[i];
                            if (!ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                            events.add(theEvent);
                        }
                    } else {
                        events.addAll(Arrays.asList(fragments));
                    }
                } else if (this.whereClauses[level] != null) {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = eventBeanArray[i];
                        if (!ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = eventBeanArray[i];
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                }
            } else {
                EventBean fragment = (EventBean)result;
                if (level == lastLevel) {
                    if (this.whereClauses[level] != null) {
                        this.eventsPerStream[level + 1] = fragment;
                        if (ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                            events.add(fragment);
                        }
                    } else {
                        events.add(fragment);
                    }
                } else if (this.whereClauses[level] != null) {
                    this.eventsPerStream[level + 1] = fragment;
                    if (ExprNodeUtilityEvaluate.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                        this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    this.eventsPerStream[level + 1] = fragment;
                    this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                }
            }
        }
        catch (RuntimeException ex) {
            String message = "Unexpected error evaluating property expression for event of type '" + branch.getEventType().getName() + "' and property '" + this.expressionTexts[level + 1] + "': " + ex.getMessage();
            throw new EPException(message, ex);
        }
    }
}

