/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.core;

import com.espertech.esper.common.client.dataflow.core.EPDataFlowCancellationException;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowEmitterOperator;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowExecutionException;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowInstance;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowInstanceCaptive;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowInstanceStatistics;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowState;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.DataflowDesc;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpCloseContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpOpenContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorLifecycle;
import com.espertech.esper.common.internal.epl.dataflow.realize.OperatorStatisticsProvider;
import com.espertech.esper.common.internal.epl.dataflow.runnables.CompletionListener;
import com.espertech.esper.common.internal.epl.dataflow.runnables.GraphSourceRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPDataFlowInstanceImpl
implements EPDataFlowInstance {
    private static final Logger log = LoggerFactory.getLogger(EPDataFlowInstanceImpl.class);
    private final Object dataFlowInstanceUserObject;
    private final String dataFlowInstanceId;
    private final OperatorStatisticsProvider statistics;
    private final DataflowDesc dataflowDesc;
    private final AgentInstanceContext agentInstanceContext;
    private final Map<Integer, Pair<Object, Boolean>> operators;
    private final List<GraphSourceRunnable> sourceRunnables;
    private final EPDataFlowInstanceStatistics statisticsProvider;
    private final Map<String, Object> parametersURIs;
    private EPDataFlowState state;
    private List<Thread> threads;
    private List<CountDownLatch> joinedThreadLatches;
    private Thread runCurrentThread;

    public EPDataFlowInstanceImpl(Object dataFlowInstanceUserObject, String dataFlowInstanceId, OperatorStatisticsProvider statistics, Map<Integer, Object> operators, List<GraphSourceRunnable> sourceRunnables, DataflowDesc dataflowDesc, AgentInstanceContext agentInstanceContext, EPDataFlowInstanceStatistics statisticsProvider, Map<String, Object> parametersURIs) {
        this.dataFlowInstanceUserObject = dataFlowInstanceUserObject;
        this.dataFlowInstanceId = dataFlowInstanceId;
        this.statistics = statistics;
        this.dataflowDesc = dataflowDesc;
        this.agentInstanceContext = agentInstanceContext;
        this.sourceRunnables = sourceRunnables;
        this.statisticsProvider = statisticsProvider;
        this.parametersURIs = parametersURIs;
        this.setState(EPDataFlowState.INSTANTIATED);
        this.operators = new TreeMap<Integer, Pair<Object, Boolean>>();
        for (Map.Entry<Integer, Object> entry : operators.entrySet()) {
            this.operators.put(entry.getKey(), new Pair<Object, Boolean>(entry.getValue(), false));
        }
    }

    @Override
    public String getDataFlowName() {
        return this.dataflowDesc.getDataflowName();
    }

    @Override
    public String getDataFlowDeploymentId() {
        return this.dataflowDesc.getStatementContext().getDeploymentId();
    }

    @Override
    public EPDataFlowState getState() {
        return this.state;
    }

    @Override
    public synchronized void run() throws IllegalStateException, EPDataFlowExecutionException, EPDataFlowCancellationException {
        this.checkExecCompleteState();
        this.checkExecCancelledState();
        this.checkExecRunningState();
        String dataFlowName = this.dataflowDesc.getDataflowName();
        if (this.sourceRunnables.size() != 1) {
            throw new UnsupportedOperationException("The data flow '" + dataFlowName + "' has zero or multiple sources and requires the use of the start method instead");
        }
        this.callOperatorOpen();
        GraphSourceRunnable sourceRunnable = this.sourceRunnables.get(0);
        this.setState(EPDataFlowState.RUNNING);
        this.runCurrentThread = Thread.currentThread();
        try {
            sourceRunnable.runSync();
        }
        catch (InterruptedException ex) {
            this.callOperatorClose();
            this.setState(EPDataFlowState.CANCELLED);
            throw new EPDataFlowCancellationException("Data flow '" + dataFlowName + "' execution was cancelled", dataFlowName);
        }
        catch (Throwable t) {
            this.callOperatorClose();
            this.setState(EPDataFlowState.COMPLETE);
            throw new EPDataFlowExecutionException("Exception encountered running data flow '" + dataFlowName + "': " + t.getMessage(), t, dataFlowName);
        }
        this.callOperatorClose();
        if (this.state != EPDataFlowState.CANCELLED) {
            this.setState(EPDataFlowState.COMPLETE);
        }
    }

    @Override
    public void start() throws IllegalStateException {
        this.checkExecCompleteState();
        this.checkExecCancelledState();
        this.checkExecRunningState();
        this.callOperatorOpen();
        final AtomicInteger countdown = new AtomicInteger(this.sourceRunnables.size());
        this.threads = new ArrayList<Thread>();
        for (int i = 0; i < this.sourceRunnables.size(); ++i) {
            GraphSourceRunnable runnable = this.sourceRunnables.get(i);
            String threadName = "esper." + this.dataflowDesc.getDataflowName() + "-" + i;
            Thread thread = new Thread((Runnable)runnable, threadName);
            thread.setContextClassLoader(this.agentInstanceContext.getClasspathImportServiceRuntime().getClassLoader());
            thread.setDaemon(true);
            runnable.addCompletionListener(new CompletionListener(){

                @Override
                public void completed() {
                    int remaining = countdown.decrementAndGet();
                    if (remaining == 0) {
                        EPDataFlowInstanceImpl.this.completed();
                    }
                }
            });
            this.threads.add(thread);
            thread.start();
        }
        this.setState(EPDataFlowState.RUNNING);
    }

    @Override
    public synchronized EPDataFlowInstanceCaptive startCaptive() {
        this.checkExecCompleteState();
        this.checkExecCancelledState();
        this.checkExecRunningState();
        this.setState(EPDataFlowState.RUNNING);
        this.callOperatorOpen();
        HashMap<String, EPDataFlowEmitterOperator> emitters = new HashMap<String, EPDataFlowEmitterOperator>();
        for (Pair<Object, Boolean> operatorStatePair : this.operators.values()) {
            if (!(operatorStatePair.getFirst() instanceof EPDataFlowEmitterOperator)) continue;
            EPDataFlowEmitterOperator emitterOp = (EPDataFlowEmitterOperator)operatorStatePair.getFirst();
            emitters.put(emitterOp.getName(), emitterOp);
        }
        return new EPDataFlowInstanceCaptive(emitters, this.sourceRunnables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws IllegalStateException, InterruptedException {
        String dataFlowName = this.dataflowDesc.getDataflowName();
        if (this.state == EPDataFlowState.INSTANTIATED) {
            throw new IllegalStateException("Data flow '" + dataFlowName + "' instance has not been executed, please use join after start or run");
        }
        if (this.state == EPDataFlowState.CANCELLED) {
            throw new IllegalStateException("Data flow '" + dataFlowName + "' instance has been cancelled and cannot be joined");
        }
        if (this.threads != null) {
            for (Thread thread : this.threads) {
                thread.join();
            }
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            EPDataFlowInstanceImpl ePDataFlowInstanceImpl = this;
            synchronized (ePDataFlowInstanceImpl) {
                if (this.joinedThreadLatches == null) {
                    this.joinedThreadLatches = new ArrayList<CountDownLatch>();
                }
                this.joinedThreadLatches.add(latch);
            }
            if (this.state != EPDataFlowState.COMPLETE) {
                latch.await();
            }
        }
    }

    @Override
    public void cancel() {
        if (this.state == EPDataFlowState.COMPLETE || this.state == EPDataFlowState.CANCELLED) {
            return;
        }
        if (this.state == EPDataFlowState.INSTANTIATED) {
            this.setState(EPDataFlowState.CANCELLED);
            this.sourceRunnables.clear();
            this.callOperatorClose();
            return;
        }
        if (this.threads != null) {
            for (GraphSourceRunnable runnable : this.sourceRunnables) {
                runnable.shutdown();
            }
            for (Thread thread : this.threads) {
                if (!thread.isAlive() || thread.isInterrupted()) continue;
                thread.interrupt();
            }
        } else {
            if (this.runCurrentThread != null) {
                this.runCurrentThread.interrupt();
            }
            this.runCurrentThread = null;
        }
        this.callOperatorClose();
        this.setState(EPDataFlowState.CANCELLED);
        this.sourceRunnables.clear();
    }

    @Override
    public EPDataFlowInstanceStatistics getStatistics() {
        return this.statisticsProvider;
    }

    @Override
    public Object getUserObject() {
        return this.dataFlowInstanceUserObject;
    }

    @Override
    public String getInstanceId() {
        return this.dataFlowInstanceId;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parametersURIs;
    }

    public synchronized void completed() {
        if (this.state != EPDataFlowState.CANCELLED) {
            this.setState(EPDataFlowState.COMPLETE);
        }
        this.callOperatorClose();
        if (this.joinedThreadLatches != null) {
            for (CountDownLatch joinedThread : this.joinedThreadLatches) {
                joinedThread.countDown();
            }
        }
    }

    private void callOperatorOpen() {
        for (Integer opNum : this.dataflowDesc.getOperatorBuildOrder()) {
            Pair<Object, Boolean> operatorStatePair = this.operators.get(opNum);
            if (!(operatorStatePair.getFirst() instanceof DataFlowOperatorLifecycle)) continue;
            try {
                DataFlowOperatorLifecycle lf = (DataFlowOperatorLifecycle)operatorStatePair.getFirst();
                lf.open(new DataFlowOpOpenContext(opNum));
            }
            catch (RuntimeException ex) {
                throw new EPDataFlowExecutionException("Exception encountered opening data flow 'FlowOne' in operator " + operatorStatePair.getFirst().getClass().getSimpleName() + ": " + ex.getMessage(), ex, this.dataflowDesc.getDataflowName());
            }
        }
    }

    private synchronized void callOperatorClose() {
        for (Integer opNum : this.dataflowDesc.getOperatorBuildOrder()) {
            Pair<Object, Boolean> operatorStatePair = this.operators.get(opNum);
            if (!(operatorStatePair.getFirst() instanceof DataFlowOperatorLifecycle) || operatorStatePair.getSecond().booleanValue()) continue;
            try {
                DataFlowOperatorLifecycle lf = (DataFlowOperatorLifecycle)operatorStatePair.getFirst();
                lf.close(new DataFlowOpCloseContext(opNum));
            }
            catch (RuntimeException ex) {
                log.error("Exception encountered closing data flow '" + this.dataflowDesc.getDataflowName() + "': " + ex.getMessage(), (Throwable)ex);
            }
            operatorStatePair.setSecond(true);
        }
    }

    private void checkExecCompleteState() {
        if (this.state == EPDataFlowState.COMPLETE) {
            throw new IllegalStateException("Data flow '" + this.dataflowDesc.getDataflowName() + "' instance has already completed, please use instantiate to run the data flow again");
        }
    }

    private void checkExecRunningState() {
        if (this.state == EPDataFlowState.RUNNING) {
            throw new IllegalStateException("Data flow '" + this.dataflowDesc.getDataflowName() + "' instance is already running");
        }
    }

    private void checkExecCancelledState() {
        if (this.state == EPDataFlowState.CANCELLED) {
            throw new IllegalStateException("Data flow '" + this.dataflowDesc.getDataflowName() + "' instance has been cancelled and cannot be run or started");
        }
    }

    private void setState(EPDataFlowState newState) {
        this.agentInstanceContext.getAuditProvider().dataflowTransition(this.dataflowDesc.getDataflowName(), this.dataFlowInstanceId, this.state, newState, this.agentInstanceContext);
        this.state = newState;
    }
}

