/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.ops;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.common.client.dataflow.util.DataFlowParameterValidation;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeResult;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpOutputPort;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorForge;
import com.espertech.esper.common.internal.epl.dataflow.util.GraphTypeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalWithTypeWidener;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.util.TypeWidenerCustomizer;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeaconSourceForge
implements DataFlowOperatorForge {
    private static final List<String> PARAMETER_PROPERTIES = Arrays.asList("interval", "iterations", "initialDelay");
    @DataFlowOpParameter
    private ExprNode iterations;
    @DataFlowOpParameter
    private ExprNode initialDelay;
    @DataFlowOpParameter
    private ExprNode interval;
    private Map<String, ExprNode> allProperties = new LinkedHashMap<String, ExprNode>();
    private boolean produceEventBean;
    private EventType outputEventType;
    private EventBeanManufacturerForge eventBeanManufacturer;
    private ExprForge[] evaluatorForges;

    @DataFlowOpParameter(all=true)
    public void setProperty(String name, ExprNode value) {
        this.allProperties.put(name, value);
    }

    @Override
    public DataFlowOpForgeInitializeResult initializeForge(DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        this.iterations = DataFlowParameterValidation.validate("iterations", this.iterations, Number.class, context);
        this.initialDelay = DataFlowParameterValidation.validate("initialDelay", this.initialDelay, Number.class, context);
        this.interval = DataFlowParameterValidation.validate("interval", this.interval, Number.class, context);
        if (context.getOutputPorts().size() != 1) {
            throw new IllegalArgumentException("BeaconSource operator requires one output stream but produces " + context.getOutputPorts().size() + " streams");
        }
        DataFlowOpOutputPort port = context.getOutputPorts().get(0);
        if (port.getOptionalDeclaredType() == null || port.getOptionalDeclaredType().getEventType() == null) {
            return this.initializeTypeUndeclared(context);
        }
        return this.initializeTypeDeclared(port, context);
    }

    private DataFlowOpForgeInitializeResult initializeTypeDeclared(DataFlowOpOutputPort port, DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        this.produceEventBean = port.getOptionalDeclaredType() != null && !port.getOptionalDeclaredType().isUnderlying();
        this.outputEventType = port.getOptionalDeclaredType().getEventType();
        Set<String> props = this.allProperties.keySet();
        props.removeAll(PARAMETER_PROPERTIES);
        WriteablePropertyDescriptor[] writables = BeaconSourceForge.setupProperties(props.toArray(new String[props.size()]), this.outputEventType);
        try {
            this.eventBeanManufacturer = EventTypeUtility.getManufacturer(this.outputEventType, writables, context.getServices().getClasspathImportServiceCompileTime(), false, context.getServices().getEventTypeAvroHandler());
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException("Cannot manufacture event for the provided type '" + this.outputEventType.getName() + "': " + e.getMessage(), e);
        }
        int index = 0;
        this.evaluatorForges = new ExprForge[writables.length];
        TypeWidenerCustomizer typeWidenerCustomizer = context.getServices().getEventTypeAvroHandler().getTypeWidenerCustomizer(this.outputEventType);
        for (WriteablePropertyDescriptor writable : writables) {
            TypeWidenerSPI widener;
            ExprNode providedProperty;
            ExprNode exprNode = providedProperty = this.allProperties.get(writable.getPropertyName());
            ExprNode validated = EPLValidationUtil.validateSimpleGetSubtree(ExprNodeOrigin.DATAFLOWBEACON, exprNode, null, false, context.getBase().getStatementRawInfo(), context.getServices());
            try {
                widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(validated), validated.getForge().getEvaluationType(), writable.getType(), writable.getPropertyName(), false, typeWidenerCustomizer, context.getBase().getStatementName());
            }
            catch (TypeWidenerException e) {
                throw new ExprValidationException("Failed for property '" + writable.getPropertyName() + "'");
            }
            this.evaluatorForges[index] = widener != null ? new ExprEvalWithTypeWidener(widener, validated, writable.getType()) : validated.getForge();
            ++index;
        }
        return null;
    }

    private DataFlowOpForgeInitializeResult initializeTypeUndeclared(DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        LinkedHashMap<String, Object> types = new LinkedHashMap<String, Object>();
        Set<String> props = this.allProperties.keySet();
        props.removeAll(PARAMETER_PROPERTIES);
        int count = 0;
        this.evaluatorForges = new ExprForge[props.size()];
        for (String propertyName : props) {
            ExprNode exprNode = this.allProperties.get(propertyName);
            ExprNode validated = EPLValidationUtil.validateSimpleGetSubtree(ExprNodeOrigin.DATAFLOWBEACON, exprNode, null, false, context.getStatementRawInfo(), context.getServices());
            types.put(propertyName, validated.getForge().getEvaluationType());
            this.evaluatorForges[count] = validated.getForge();
            ++count;
        }
        String eventTypeName = context.getServices().getEventTypeNameGeneratorStatement().getDataflowOperatorTypeName(context.getOperatorNumber());
        EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, context.getBase().getModuleName(), EventTypeTypeClass.DBDERIVED, EventTypeApplicationType.OBJECTARR, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        this.outputEventType = BaseNestableEventUtil.makeOATypeCompileTime(metadata, types, null, null, null, null, context.getServices().getBeanEventTypeFactoryPrivate(), context.getServices().getEventTypeCompileTimeResolver());
        context.getServices().getEventTypeCompileTimeRegistry().newType(this.outputEventType);
        return new DataFlowOpForgeInitializeResult(new GraphTypeDesc[]{new GraphTypeDesc(false, true, this.outputEventType)});
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        return new SAIFFInitializeBuilder("com.espertech.esper.runtime.internal.dataflow.op.beaconsource.BeaconSourceFactory", this.getClass(), "factory", parent, symbols, classScope).exprnode("iterations", this.iterations).exprnode("initialDelay", this.initialDelay).exprnode("interval", this.interval).constant("produceEventBean", this.produceEventBean).eventtype("outputEventType", this.outputEventType).forges("propertyEvaluators", this.evaluatorForges).manufacturer("manufacturer", this.eventBeanManufacturer).build();
    }

    private static WriteablePropertyDescriptor[] setupProperties(String[] propertyNamesOffered, EventType outputEventType) throws ExprValidationException {
        Set<WriteablePropertyDescriptor> writeables = EventTypeUtility.getWriteableProperties(outputEventType, false, false);
        ArrayList<WriteablePropertyDescriptor> writablesList = new ArrayList<WriteablePropertyDescriptor>();
        for (int i = 0; i < propertyNamesOffered.length; ++i) {
            String propertyName = propertyNamesOffered[i];
            WriteablePropertyDescriptor writable = EventTypeUtility.findWritable(propertyName, writeables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find writable property '" + propertyName + "' for event type '" + outputEventType.getName() + "'");
            }
            writablesList.add(writable);
        }
        return writablesList.toArray(new WriteablePropertyDescriptor[writablesList.size()]);
    }
}

