/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.ops;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.EventRepresentation;
import com.espertech.esper.common.client.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseExpressions;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitLimitType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitRateType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecOptions;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.ViewSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementLifecycleSvcUtil;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.select.StmtForgeMethodSelectResult;
import com.espertech.esper.common.internal.context.aifactory.select.StmtForgeMethodSelectUtil;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByExpressionHelper;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeResult;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpInputPort;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpOutputPort;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorForge;
import com.espertech.esper.common.internal.epl.dataflow.util.GraphTypeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.util.StatementSpecRawWalkerSubselectAndDeclaredDot;
import com.espertech.esper.common.internal.type.AnnotationEventRepresentation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectForge
implements DataFlowOperatorForge {
    @DataFlowOpParameter
    private StatementSpecRaw select;
    @DataFlowOpParameter
    private boolean iterate;
    private EventType[] eventTypes;
    private boolean submitEventBean;
    private String classNameAIFactoryProvider;
    private int[] originatingStreamToViewableStream;

    @Override
    public DataFlowOpForgeInitializeResult initializeForge(DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (context.getInputPorts().isEmpty()) {
            throw new IllegalArgumentException("Select operator requires at least one input stream");
        }
        if (context.getOutputPorts().size() != 1) {
            throw new IllegalArgumentException("Select operator requires one output stream but produces " + context.getOutputPorts().size() + " streams");
        }
        DataFlowOpOutputPort portZero = context.getOutputPorts().get(0);
        if (portZero.getOptionalDeclaredType() != null && !portZero.getOptionalDeclaredType().isUnderlying()) {
            this.submitEventBean = true;
        }
        int numStreams = context.getInputPorts().size();
        this.eventTypes = new EventType[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            this.eventTypes[i] = context.getInputPorts().get(i).getTypeDesc().getEventType();
        }
        if (this.select.getInsertIntoDesc() != null) {
            throw new ExprValidationException("Insert-into clause is not supported");
        }
        if (this.select.getSelectStreamSelectorEnum() != SelectClauseStreamSelectorEnum.ISTREAM_ONLY) {
            throw new ExprValidationException("Selecting remove-stream is not supported");
        }
        ExprNodeSubselectDeclaredDotVisitor visitor = StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectAndDeclaredDotExpr(this.select);
        GroupByClauseExpressions groupByExpressions = GroupByExpressionHelper.getGroupByRollupExpressions(this.select.getGroupByExpressions(), this.select.getSelectClauseSpec(), this.select.getWhereClause(), this.select.getOrderByList(), null);
        if (!visitor.getSubselects().isEmpty()) {
            throw new ExprValidationException("Subselects are not supported");
        }
        HashMap<Integer, FilterStreamSpecRaw> streams = new HashMap<Integer, FilterStreamSpecRaw>();
        for (int streamNum = 0; streamNum < this.select.getStreamSpecs().size(); ++streamNum) {
            StreamSpecRaw rawStreamSpec = this.select.getStreamSpecs().get(streamNum);
            if (!(rawStreamSpec instanceof FilterStreamSpecRaw)) {
                throw new ExprValidationException("From-clause must contain only streams and cannot contain patterns or other constructs");
            }
            streams.put(streamNum, (FilterStreamSpecRaw)rawStreamSpec);
        }
        ArrayList<FilterStreamSpecCompiled> streamSpecCompileds = new ArrayList<FilterStreamSpecCompiled>();
        this.originatingStreamToViewableStream = new int[this.select.getStreamSpecs().size()];
        for (int streamNum = 0; streamNum < this.select.getStreamSpecs().size(); ++streamNum) {
            FilterStreamSpecRaw filter = (FilterStreamSpecRaw)streams.get(streamNum);
            Map.Entry<Integer, DataFlowOpInputPort> inputPort = this.findInputPort(filter.getRawFilterSpec().getEventTypeName(), context.getInputPorts());
            if (inputPort == null) {
                throw new ExprValidationException("Failed to find stream '" + filter.getRawFilterSpec().getEventTypeName() + "' among input ports, input ports are " + Arrays.toString(this.getInputPortNames(context.getInputPorts())));
            }
            EventType eventType = inputPort.getValue().getTypeDesc().getEventType();
            this.originatingStreamToViewableStream[inputPort.getKey().intValue()] = streamNum;
            String streamAlias = filter.getOptionalStreamName();
            FilterSpecCompiled filterSpecCompiled = new FilterSpecCompiled(eventType, streamAlias, new List[]{Collections.emptyList()}, null);
            ViewSpec[] viewSpecs = this.select.getStreamSpecs().get(streamNum).getViewSpecs();
            FilterStreamSpecCompiled filterStreamSpecCompiled = new FilterStreamSpecCompiled(filterSpecCompiled, viewSpecs, streamAlias, StreamSpecOptions.DEFAULT);
            streamSpecCompileds.add(filterStreamSpecCompiled);
        }
        SelectClauseSpecCompiled selectClauseCompiled = StatementLifecycleSvcUtil.compileSelectClause(this.select.getSelectClauseSpec());
        Annotation[] mergedAnnotations = AnnotationUtil.mergeAnnotations(context.getStatementRawInfo().getAnnotations(), context.getOperatorAnnotations());
        mergedAnnotations = this.addObjectArrayRepresentation(mergedAnnotations);
        StreamSpecCompiled[] streamSpecArray = streamSpecCompileds.toArray(new StreamSpecCompiled[streamSpecCompileds.size()]);
        OutputLimitSpec outputLimitSpec = this.select.getOutputLimitSpec();
        if (this.iterate) {
            if (outputLimitSpec != null) {
                throw new ExprValidationException("Output rate limiting is not supported with 'iterate'");
            }
            outputLimitSpec = new OutputLimitSpec(OutputLimitLimitType.SNAPSHOT, OutputLimitRateType.TERM);
            this.select.setOutputLimitSpec(outputLimitSpec);
        }
        StatementSpecCompiled compiled = new StatementSpecCompiled(this.select, streamSpecArray, selectClauseCompiled, mergedAnnotations, groupByExpressions, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        String dataflowClassPostfix = context.getCodegenEnv().getClassPostfix() + "__dfo" + context.getOperatorNumber();
        StatementSpecCompiled containerStatement = context.getBase().getStatementSpec();
        context.getBase().setStatementSpec(compiled);
        StmtForgeMethodSelectResult forablesResult = StmtForgeMethodSelectUtil.make(true, context.getCodegenEnv().getPackageName(), dataflowClassPostfix, context.getBase(), context.getServices());
        context.getBase().setStatementSpec(containerStatement);
        EventType outputEventType = forablesResult.getEventType();
        DataFlowOpForgeInitializeResult initializeResult = new DataFlowOpForgeInitializeResult();
        initializeResult.setTypeDescriptors(new GraphTypeDesc[]{new GraphTypeDesc(false, true, outputEventType)});
        initializeResult.setAdditionalForgeables(forablesResult.getForgeResult());
        for (StmtClassForgeable forgeable : forablesResult.getForgeResult().getForgeables()) {
            if (forgeable.getForgeableType() != StmtClassForgeableType.AIFACTORYPROVIDER) continue;
            this.classNameAIFactoryProvider = forgeable.getClassName();
        }
        return initializeResult;
    }

    private Annotation[] addObjectArrayRepresentation(Annotation[] mergedAnnotations) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (annotation instanceof EventRepresentation) continue;
            annotations.add(annotation);
        }
        annotations.add(new AnnotationEventRepresentation(EventUnderlyingType.OBJECTARRAY));
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        SAIFFInitializeBuilder builder = new SAIFFInitializeBuilder("com.espertech.esper.runtime.internal.dataflow.op.select.SelectFactory", this.getClass(), "select", parent, symbols, classScope);
        return builder.eventtypesMayNull("eventTypes", this.eventTypes).constant("submitEventBean", this.submitEventBean).constant("iterate", this.iterate).constant("originatingStreamToViewableStream", this.originatingStreamToViewableStream).expression("factoryProvider", CodegenExpressionBuilder.newInstance(this.classNameAIFactoryProvider, symbols.getAddInitSvc(builder.getMethod()))).build();
    }

    private String[] getInputPortNames(Map<Integer, DataFlowOpInputPort> inputPorts) {
        ArrayList<String> portNames = new ArrayList<String>();
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : inputPorts.entrySet()) {
            if (entry.getValue().getOptionalAlias() != null) {
                portNames.add(entry.getValue().getOptionalAlias());
                continue;
            }
            if (entry.getValue().getStreamNames().size() != 1) continue;
            portNames.add(entry.getValue().getStreamNames().iterator().next());
        }
        return portNames.toArray(new String[portNames.size()]);
    }

    private Map.Entry<Integer, DataFlowOpInputPort> findInputPort(String eventTypeName, Map<Integer, DataFlowOpInputPort> inputPorts) {
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : inputPorts.entrySet()) {
            if (entry.getValue().getOptionalAlias() != null && entry.getValue().getOptionalAlias().equals(eventTypeName)) {
                return entry;
            }
            if (entry.getValue().getStreamNames().size() != 1 || !entry.getValue().getStreamNames().iterator().next().equals(eventTypeName)) continue;
            return entry;
        }
        return null;
    }
}

