/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.calop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarForge;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.Calendar;

public class CalendarWithMaxForge
implements CalendarForge,
CalendarOp {
    private final CalendarFieldEnum fieldName;

    public CalendarWithMaxForge(CalendarFieldEnum fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public CalendarOp getEvalOp() {
        return this;
    }

    @Override
    public CodegenExpression codegenCalendar(CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(cal, "set", CodegenExpressionBuilder.constant(this.fieldName.getCalendarField()), CodegenExpressionBuilder.exprDotMethod(cal, "getActualMaximum", CodegenExpressionBuilder.constant(this.fieldName.getCalendarField())));
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        cal.set(this.fieldName.getCalendarField(), cal.getActualMaximum(this.fieldName.getCalendarField()));
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ValueRange range = ldt.range(this.fieldName.getChronoField());
        return ldt.with(this.fieldName.getChronoField(), range.getMaximum());
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CalendarWithMaxForge.codegenLDTZDTMinMax(ldt, true, this.fieldName);
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ValueRange range = zdt.range(this.fieldName.getChronoField());
        return zdt.with(this.fieldName.getChronoField(), range.getMaximum());
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CalendarWithMaxForge.codegenLDTZDTMinMax(zdt, true, this.fieldName);
    }

    protected static CodegenExpression codegenLDTZDTMinMax(CodegenExpression val, boolean max, CalendarFieldEnum fieldName) {
        CodegenExpression chronoField = CodegenExpressionBuilder.enumValue(ChronoField.class, fieldName.getChronoField().name());
        CodegenExpression valueRange = CodegenExpressionBuilder.exprDotMethod(val, "range", chronoField);
        return CodegenExpressionBuilder.exprDotMethod(val, "with", chronoField, CodegenExpressionBuilder.exprDotMethod(valueRange, max ? "getMaximum" : "getMinimum", new CodegenExpression[0]));
    }
}

