/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.calop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarForge;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarWithMaxForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ValueRange;
import java.util.Calendar;

public class CalendarWithMinForge
implements CalendarForge,
CalendarOp {
    private final CalendarFieldEnum fieldName;

    public CalendarWithMinForge(CalendarFieldEnum fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public CalendarOp getEvalOp() {
        return this;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        cal.set(this.fieldName.getCalendarField(), cal.getActualMinimum(this.fieldName.getCalendarField()));
    }

    @Override
    public CodegenExpression codegenCalendar(CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression field = CodegenExpressionBuilder.constant(this.fieldName.getCalendarField());
        return CodegenExpressionBuilder.exprDotMethod(cal, "set", field, CodegenExpressionBuilder.exprDotMethod(cal, "getActualMinimum", field));
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ValueRange range = ldt.range(this.fieldName.getChronoField());
        return ldt.with(this.fieldName.getChronoField(), range.getMinimum());
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ValueRange range = zdt.range(this.fieldName.getChronoField());
        return zdt.with(this.fieldName.getChronoField(), range.getMinimum());
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CalendarWithMaxForge.codegenLDTZDTMinMax(ldt, false, this.fieldName);
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CalendarWithMaxForge.codegenLDTZDTMinMax(zdt, false, this.fieldName);
    }
}

