/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.dtlocal;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsLongForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluator;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsCalBase;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class DTLocalCalOpsLongEval
extends DTLocalEvaluatorCalOpsCalBase
implements DTLocalEvaluator {
    private final TimeZone timeZone;
    private final TimeAbacus timeAbacus;

    public DTLocalCalOpsLongEval(List<CalendarOp> calendarOps, TimeZone timeZone, TimeAbacus timeAbacus) {
        super(calendarOps);
        this.timeZone = timeZone;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Long longValue = (Long)target;
        Calendar cal = Calendar.getInstance(this.timeZone);
        long remainder = this.timeAbacus.calendarSet(longValue, cal);
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        return this.timeAbacus.calendarGet(cal, remainder);
    }

    public static CodegenExpression codegen(DTLocalCalOpsLongForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod methodNode = codegenMethodScope.makeChild(Long.TYPE, DTLocalCalOpsLongEval.class, (CodegenScope)codegenClassScope).addParam(Long.TYPE, "target");
        CodegenBlock block = methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).declareVar(Long.TYPE, "remainder", forge.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("target"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(forge.timeAbacus.calendarGetCodegen(CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.ref("remainder"), codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }
}

