/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanCalOpsForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanIntervalNoEndTSForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanIntervalWithEndForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsCalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsDateForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsLocalDateTimeForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsLongForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsZonedDateTimeForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluator;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalForgeIntervalComp;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLDTIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLocalDateTimeOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLocalDateTimeOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLocalDateTimeReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZDTIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeReformatForge;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitor;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.rettype.ClassEPType;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.List;

public class ExprDotDTForge
implements ExprDotForge {
    private final EPType returnType;
    private final DTLocalForge forge;

    public ExprDotDTForge(List<CalendarForge> calendarForges, TimeAbacus timeAbacus, ReformatForge reformatForge, IntervalForge intervalForge, Class inputType, EventType inputEventType) {
        this.returnType = intervalForge != null ? EPTypeHelper.singleValue(Boolean.class) : (reformatForge != null ? EPTypeHelper.singleValue(reformatForge.getReturnType()) : (inputEventType != null ? EPTypeHelper.singleValue(inputEventType.getPropertyType(inputEventType.getStartTimestampPropertyName())) : EPTypeHelper.singleValue(inputType == Date.class ? java.util.Date.class : inputType)));
        this.forge = this.getForge(calendarForges, timeAbacus, inputType, inputEventType, reformatForge, intervalForge);
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        final DTLocalEvaluator evaluator = this.forge.getDTEvaluator();
        final ExprDotDTForge exprDotForge = this;
        return new ExprDotEval(){

            @Override
            public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                if (target == null) {
                    return null;
                }
                return evaluator.evaluate(target, eventsPerStream, isNewData, exprEvaluatorContext);
            }

            @Override
            public ExprDotForge getDotForge() {
                return exprDotForge;
            }
        };
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, Class innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(((ClassEPType)this.returnType).getType(), ExprDotDTForge.class, (CodegenScope)codegenClassScope).addParam(innerType, "target");
        CodegenBlock block = methodNode.getBlock();
        if (!innerType.isPrimitive()) {
            block.ifRefNullReturnNull("target");
        }
        block.methodReturn(this.forge.codegen(CodegenExpressionBuilder.ref("target"), innerType, methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public EPType getTypeInfo() {
        return this.returnType;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitDateTime();
    }

    public DTLocalForge getForge(List<CalendarForge> calendarForges, TimeAbacus timeAbacus, Class inputType, EventType inputEventType, ReformatForge reformatForge, IntervalForge intervalForge) {
        if (inputEventType == null) {
            if (reformatForge != null) {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalCalReformatForge(reformatForge);
                    }
                    return new DTLocalCalOpsReformatForge(calendarForges, reformatForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, java.util.Date.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalDateReformatForge(reformatForge);
                    }
                    return new DTLocalDateOpsReformatForge(calendarForges, reformatForge);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLongReformatForge(reformatForge);
                    }
                    return new DTLocalLongOpsReformatForge(calendarForges, reformatForge, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLocalDateTimeReformatForge(reformatForge);
                    }
                    return new DTLocalLocalDateTimeOpsReformatForge(calendarForges, reformatForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalZonedDateTimeReformatForge(reformatForge);
                    }
                    return new DTLocalZonedDateTimeOpsReformatForge(calendarForges, reformatForge);
                }
            } else if (intervalForge != null) {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalCalIntervalForge(intervalForge);
                    }
                    return new DTLocalCalOpsIntervalForge(calendarForges, intervalForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, java.util.Date.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalDateIntervalForge(intervalForge);
                    }
                    return new DTLocalDateOpsIntervalForge(calendarForges, intervalForge);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLongIntervalForge(intervalForge);
                    }
                    return new DTLocalLongOpsIntervalForge(calendarForges, intervalForge, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLDTIntervalForge(intervalForge);
                    }
                    return new DTLocalLocalDateTimeOpsIntervalForge(calendarForges, intervalForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalZDTIntervalForge(intervalForge);
                    }
                    return new DTLocalZonedDateTimeOpsIntervalForge(calendarForges, intervalForge);
                }
            } else {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    return new DTLocalCalOpsCalForge(calendarForges);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, java.util.Date.class)) {
                    return new DTLocalCalOpsDateForge(calendarForges);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    return new DTLocalCalOpsLongForge(calendarForges, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    return new DTLocalCalOpsLocalDateTimeForge(calendarForges);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    return new DTLocalCalOpsZonedDateTimeForge(calendarForges);
                }
            }
            throw new IllegalArgumentException("Invalid input type '" + inputType + "'");
        }
        EventPropertyGetterSPI getter = ((EventTypeSPI)inputEventType).getGetterSPI(inputEventType.getStartTimestampPropertyName());
        Class getterResultType = inputEventType.getPropertyType(inputEventType.getStartTimestampPropertyName());
        if (reformatForge != null) {
            DTLocalForge inner = this.getForge(calendarForges, timeAbacus, getterResultType, null, reformatForge, null);
            return new DTLocalBeanReformatForge(getter, getterResultType, inner, reformatForge.getReturnType());
        }
        if (intervalForge == null) {
            DTLocalForge inner = this.getForge(calendarForges, timeAbacus, getterResultType, null, null, null);
            return new DTLocalBeanCalOpsForge(getter, getterResultType, inner, EPTypeHelper.getNormalizedClass(this.returnType));
        }
        if (inputEventType.getEndTimestampPropertyName() == null) {
            DTLocalForge inner = this.getForge(calendarForges, timeAbacus, getterResultType, null, null, intervalForge);
            return new DTLocalBeanIntervalNoEndTSForge(getter, getterResultType, inner, EPTypeHelper.getNormalizedClass(this.returnType));
        }
        EventPropertyGetterSPI getterEndTimestamp = ((EventTypeSPI)inputEventType).getGetterSPI(inputEventType.getEndTimestampPropertyName());
        Class getterEndType = inputEventType.getPropertyType(inputEventType.getEndTimestampPropertyName());
        DTLocalForgeIntervalComp inner = (DTLocalForgeIntervalComp)((Object)this.getForge(calendarForges, timeAbacus, getterResultType, null, null, intervalForge));
        return new DTLocalBeanIntervalWithEndForge(getter, getterResultType, getterEndTimestamp, getterEndType, inner);
    }
}

