/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.interval;

import com.espertech.esper.common.internal.epl.datetime.interval.ExprOptionalConstantForge;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalStartEndParameterPairEval;

public class IntervalStartEndParameterPairForge {
    private final ExprOptionalConstantForge start;
    private final ExprOptionalConstantForge end;

    public IntervalStartEndParameterPairForge(ExprOptionalConstantForge start, ExprOptionalConstantForge end) {
        this.start = start;
        this.end = end;
    }

    public IntervalStartEndParameterPairEval makeEval() {
        return new IntervalStartEndParameterPairEval(this.start.makeEval(), this.end.makeEval());
    }

    public static IntervalStartEndParameterPairForge fromParamsWithSameEnd(ExprOptionalConstantForge[] parameters) {
        ExprOptionalConstantForge start = parameters[0];
        ExprOptionalConstantForge end = parameters.length == 1 ? start : parameters[1];
        return new IntervalStartEndParameterPairForge(start, end);
    }

    public static IntervalStartEndParameterPairForge fromParamsWithLongMaxEnd(ExprOptionalConstantForge[] parameters) {
        ExprOptionalConstantForge start = parameters[0];
        ExprOptionalConstantForge end = parameters.length == 1 ? ExprOptionalConstantForge.make(Long.MAX_VALUE) : parameters[1];
        return new IntervalStartEndParameterPairForge(start, end);
    }

    public ExprOptionalConstantForge getStart() {
        return this.start;
    }

    public ExprOptionalConstantForge getEnd() {
        return this.end;
    }

    public boolean isConstant() {
        return this.start.getOptionalConstant() != null && this.end.getOptionalConstant() != null;
    }
}

