/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheStackEntry;
import com.espertech.esper.common.internal.epl.enummethod.compile.EnumMethodCallStackHelperImpl;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParam;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParamExpr;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeEnumMethod;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeEnumMethodEval;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFP;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPInputEnum;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPProvided;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodInputTypeMatcher;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodTypeEnum;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodUtil;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.util.EPLExpressionParamType;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class ExprDotForgeEnumMethodBase
implements ExprDotForgeEnumMethod,
ExpressionResultCacheStackEntry {
    protected EnumMethodEnum enumMethodEnum;
    protected String enumMethodUsedName;
    protected int streamCountIncoming;
    protected EnumForge enumForge;
    protected int enumEvalNumRequiredEvents;
    protected EPType typeInfo;
    protected boolean cache;

    protected ExprDotForgeEnumMethodBase() {
    }

    public abstract EventType[] getAddStreamTypes(String var1, List<String> var2, EventType var3, Class var4, List<ExprDotEvalParam> var5, StatementRawInfo var6, StatementCompileTimeServices var7);

    public abstract EnumForge getEnumForge(StreamTypeService var1, String var2, List<ExprDotEvalParam> var3, EventType var4, Class var5, int var6, boolean var7, StatementRawInfo var8, StatementCompileTimeServices var9) throws ExprValidationException;

    public EnumMethodEnum getEnumMethodEnum() {
        return this.enumMethodEnum;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitEnumeration(this.enumMethodEnum.getNameCamel());
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        return new ExprDotForgeEnumMethodEval(this, this.enumForge.getEnumEvaluator(), this.cache, this.enumEvalNumRequiredEvents);
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, Class innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprDotForgeEnumMethodEval.codegen(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public void init(Integer streamOfProviderIfApplicable, EnumMethodEnum enumMethodEnum, String enumMethodUsedName, EPType typeInfo, List<ExprNode> parameters, ExprValidationContext validationContext) throws ExprValidationException {
        boolean isInner;
        final EventType eventTypeColl = EPTypeHelper.getEventTypeMultiValued(typeInfo);
        final EventType eventTypeBean = EPTypeHelper.getEventTypeSingleValued(typeInfo);
        final Class collectionComponentType = EPTypeHelper.getClassMultiValued(typeInfo);
        this.enumMethodEnum = enumMethodEnum;
        this.enumMethodUsedName = enumMethodUsedName;
        this.streamCountIncoming = validationContext.getStreamTypeService().getEventTypes().length;
        if (eventTypeColl == null && collectionComponentType == null && eventTypeBean == null) {
            throw new ExprValidationException("Invalid input for built-in enumeration method '" + enumMethodUsedName + "', expecting collection of event-type or scalar values as input, received " + EPTypeHelper.toTypeDescriptive(typeInfo));
        }
        DotMethodFPProvided footprintProvided = DotMethodUtil.getProvidedFootprint(parameters);
        DotMethodInputTypeMatcher inputTypeMatcher = new DotMethodInputTypeMatcher(){

            @Override
            public boolean matches(DotMethodFP footprint) {
                if (footprint.getInput() == DotMethodFPInputEnum.EVENTCOLL && eventTypeBean == null && eventTypeColl == null) {
                    return false;
                }
                return footprint.getInput() != DotMethodFPInputEnum.SCALAR_ANY || collectionComponentType != null;
            }
        };
        DotMethodFP footprint = DotMethodUtil.validateParametersDetermineFootprint(enumMethodEnum.getFootprints(), DotMethodTypeEnum.ENUM, enumMethodUsedName, footprintProvided, inputTypeMatcher);
        if (footprint.getInput() != DotMethodFPInputEnum.ANY) {
            String message = "Invalid input for built-in enumeration method '" + enumMethodUsedName + "' and " + footprint.getParameters().length + "-parameter footprint, expecting collection of ";
            String received = " as input, received " + EPTypeHelper.toTypeDescriptive(typeInfo);
            if (footprint.getInput() == DotMethodFPInputEnum.EVENTCOLL && eventTypeColl == null) {
                throw new ExprValidationException(message + "events" + received);
            }
            if (footprint.getInput().isScalar() && collectionComponentType == null) {
                throw new ExprValidationException(message + "values (typically scalar values)" + received);
            }
            if (footprint.getInput() == DotMethodFPInputEnum.SCALAR_NUMERIC && !JavaClassHelper.isNumeric(collectionComponentType)) {
                throw new ExprValidationException(message + "numeric values" + received);
            }
        }
        EnumMethodCallStackHelperImpl enumCallStackHelper = validationContext.getEnumMethodCallStackHelper();
        enumCallStackHelper.pushStack(this);
        ArrayList<ExprDotEvalParam> bodiesAndParameters = new ArrayList<ExprDotEvalParam>();
        int count = 0;
        EventType inputEventType = eventTypeBean == null ? eventTypeColl : eventTypeBean;
        for (ExprNode node : parameters) {
            ExprDotEvalParam bodyAndParameter = this.getBodyAndParameter(enumMethodUsedName, count++, node, inputEventType, collectionComponentType, validationContext, bodiesAndParameters, footprint);
            bodiesAndParameters.add(bodyAndParameter);
        }
        this.enumForge = this.getEnumForge(validationContext.getStreamTypeService(), enumMethodUsedName, bodiesAndParameters, inputEventType, collectionComponentType, this.streamCountIncoming, validationContext.isDisablePropertyExpressionEventCollCache(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
        this.enumEvalNumRequiredEvents = this.enumForge.getStreamNumSize();
        HashSet<Integer> streamsRequired = new HashSet<Integer>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        for (ExprDotEvalParam desc : bodiesAndParameters) {
            desc.getBody().accept(visitor);
            for (ExprIdentNode ident : visitor.getExprProperties()) {
                streamsRequired.add(ident.getStreamId());
            }
        }
        if (streamOfProviderIfApplicable != null) {
            streamsRequired.add(streamOfProviderIfApplicable);
        }
        boolean bl = isInner = !enumCallStackHelper.popLambda();
        if (isInner) {
            Deque<ExpressionResultCacheStackEntry> parents = enumCallStackHelper.getStack();
            boolean found = false;
            Iterator iterator = streamsRequired.iterator();
            while (iterator.hasNext()) {
                int req = (Integer)iterator.next();
                ExprDotForgeEnumMethodBase first = (ExprDotForgeEnumMethodBase)parents.getFirst();
                int parentIncoming = first.streamCountIncoming - 1;
                int selfAdded = this.streamCountIncoming;
                if (req <= parentIncoming || req >= selfAdded) continue;
                found = true;
            }
            this.cache = !found;
        }
    }

    public void setTypeInfo(EPType typeInfo) {
        this.typeInfo = typeInfo;
    }

    @Override
    public EPType getTypeInfo() {
        return this.typeInfo;
    }

    private ExprDotEvalParam getBodyAndParameter(String enumMethodUsedName, int parameterNum, ExprNode parameterNode, EventType inputEventType, Class collectionComponentType, ExprValidationContext validationContext, List<ExprDotEvalParam> priorParameters, DotMethodFP footprint) throws ExprValidationException {
        if (!(parameterNode instanceof ExprLambdaGoesNode)) {
            return new ExprDotEvalParamExpr(parameterNum, parameterNode, parameterNode.getForge());
        }
        ExprLambdaGoesNode goesNode = (ExprLambdaGoesNode)parameterNode;
        Object[] additionalTypes = this.getAddStreamTypes(enumMethodUsedName, goesNode.getGoesToNames(), inputEventType, collectionComponentType, priorParameters, validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
        Object[] additionalStreamNames = goesNode.getGoesToNames().toArray(new String[goesNode.getGoesToNames().size()]);
        this.validateDuplicateStreamNames(validationContext.getStreamTypeService().getStreamNames(), (String[])additionalStreamNames);
        EventType[] addTypes = (EventType[])CollectionUtil.arrayExpandAddElements((Object)validationContext.getStreamTypeService().getEventTypes(), additionalTypes);
        String[] addNames = (String[])CollectionUtil.arrayExpandAddElements((Object)validationContext.getStreamTypeService().getStreamNames(), additionalStreamNames);
        StreamTypeServiceImpl types = new StreamTypeServiceImpl(addTypes, addNames, new boolean[addTypes.length], false, validationContext.getStreamTypeService().isOptionalStreams());
        ExprNode filter = goesNode.getChildNodes()[0];
        try {
            ExprValidationContext filterValidationContext = new ExprValidationContext(types, validationContext);
            filter = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DECLAREDEXPRBODY, filter, filterValidationContext);
        }
        catch (ExprValidationException ex) {
            throw new ExprValidationException("Error validating enumeration method '" + enumMethodUsedName + "' parameter " + parameterNum + ": " + ex.getMessage(), ex);
        }
        ExprForge filterForge = filter.getForge();
        EPLExpressionParamType expectedType = footprint.getParameters()[parameterNum].getType();
        EPLValidationUtil.validateParameterType(enumMethodUsedName, DotMethodTypeEnum.ENUM.getTypeName(), false, expectedType, null, filterForge.getEvaluationType(), parameterNum, filter);
        int numStreamsIncoming = validationContext.getStreamTypeService().getEventTypes().length;
        return new ExprDotEvalParamLambda(parameterNum, filter, filterForge, numStreamsIncoming, goesNode.getGoesToNames(), (EventType[])additionalTypes);
    }

    private void validateDuplicateStreamNames(String[] streamNames, String[] additionalStreamNames) throws ExprValidationException {
        for (int added = 0; added < additionalStreamNames.length; ++added) {
            for (int exist = 0; exist < streamNames.length; ++exist) {
                if (streamNames[exist] == null || !streamNames[exist].equalsIgnoreCase(additionalStreamNames[added])) continue;
                String message = "Error validating enumeration method '" + this.enumMethodUsedName + "', the lambda-parameter name '" + additionalStreamNames[added] + "' has already been declared in this context";
                throw new ExprValidationException(message);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " lambda=" + (Object)((Object)this.enumMethodEnum);
    }
}

