/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapArrayEvents;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapArrayScalar;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapCollection;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapEventBeanArr;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapEventBeanColl;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapIterableEvents;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapIterableScalar;
import com.espertech.esper.common.internal.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class ExprDotStaticMethodWrapFactory {
    public static ExprDotStaticMethodWrap make(Method method, List<ExprChainedSpec> modifiedChain, String optionalEventTypeName, ExprValidationContext validationContext) throws ExprValidationException {
        Class genericType;
        if (modifiedChain.isEmpty() || !EnumMethodEnum.isEnumerationMethod(modifiedChain.get(0).getName())) {
            return null;
        }
        if (method.getReturnType().isArray() && method.getReturnType().getComponentType() == EventBean.class) {
            EventType eventType = ExprDotStaticMethodWrapFactory.requireEventType(method, optionalEventTypeName, validationContext);
            return new ExprDotStaticMethodWrapEventBeanArr(eventType);
        }
        if (method.getReturnType().isArray()) {
            Class<?> componentType = method.getReturnType().getComponentType();
            if (componentType == null || JavaClassHelper.isJavaBuiltinDataType(componentType)) {
                return new ExprDotStaticMethodWrapArrayScalar(method.getName(), method.getReturnType());
            }
            BeanEventType type = ExprDotStaticMethodWrapFactory.makeBeanType(method.getName(), componentType, validationContext);
            return new ExprDotStaticMethodWrapArrayEvents(null, type);
        }
        if (JavaClassHelper.isImplementsInterface(method.getReturnType(), Collection.class)) {
            genericType = JavaClassHelper.getGenericReturnType(method, true);
            if (genericType == EventBean.class) {
                EventType eventType = ExprDotStaticMethodWrapFactory.requireEventType(method, optionalEventTypeName, validationContext);
                return new ExprDotStaticMethodWrapEventBeanColl(eventType);
            }
            if (genericType == null || JavaClassHelper.isJavaBuiltinDataType(genericType)) {
                return new ExprDotStaticMethodWrapCollection(method.getName(), genericType);
            }
        }
        if (JavaClassHelper.isImplementsInterface(method.getReturnType(), Iterable.class)) {
            genericType = JavaClassHelper.getGenericReturnType(method, true);
            if (genericType == null || JavaClassHelper.isJavaBuiltinDataType(genericType)) {
                return new ExprDotStaticMethodWrapIterableScalar(method.getName(), genericType);
            }
            BeanEventType type = ExprDotStaticMethodWrapFactory.makeBeanType(method.getName(), genericType, validationContext);
            return new ExprDotStaticMethodWrapIterableEvents(validationContext.getEventBeanTypedEventFactory(), type);
        }
        return null;
    }

    private static BeanEventType makeBeanType(String methodName, Class clazz, ExprValidationContext validationContext) {
        String eventTypeName = validationContext.getStatementCompileTimeService().getEventTypeNameGeneratorStatement().getAnonymousTypeNameUDFMethod(methodName, clazz.getName());
        EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, validationContext.getModuleName(), EventTypeTypeClass.UDFDERIVED, EventTypeApplicationType.CLASS, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        BeanEventTypeStem stem = validationContext.getStatementCompileTimeService().getBeanEventTypeStemService().getCreateStem(clazz, null);
        BeanEventType beantype = new BeanEventType(stem, metadata, validationContext.getStatementCompileTimeService().getBeanEventTypeFactoryPrivate(), null, null, null, null);
        validationContext.getStatementCompileTimeService().getEventTypeCompileTimeRegistry().newType(beantype);
        return beantype;
    }

    private static EventType requireEventType(Method method, String optionalEventTypeName, ExprValidationContext ctx) throws ExprValidationException {
        return EventTypeUtility.requireEventType("Method", method.getName(), optionalEventTypeName, ctx.getStatementCompileTimeService().getEventTypeCompileTimeResolver());
    }
}

