/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.agg.method.avg.AggregatorAvgBig;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenParams;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumAverageBigDecimalEventsForge;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumEval;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.type.MathContextCodegenField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumAverageBigDecimalEventsForgeEval
implements EnumEval {
    private static final Logger log = LoggerFactory.getLogger(EnumAverageBigDecimalEventsForgeEval.class);
    private final EnumAverageBigDecimalEventsForge forge;
    private final ExprEvaluator innerExpression;

    public EnumAverageBigDecimalEventsForgeEval(EnumAverageBigDecimalEventsForge forge, ExprEvaluator innerExpression) {
        this.forge = forge;
        this.innerExpression = innerExpression;
    }

    @Override
    public Object evaluateEnumMethod(EventBean[] eventsLambda, Collection enumcoll, boolean isNewData, ExprEvaluatorContext context) {
        AggregatorAvgBigDecimal agg = new AggregatorAvgBigDecimal(this.forge.optionalMathContext);
        Collection beans = enumcoll;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            EventBean next;
            eventsLambda[this.forge.streamNumLambda] = next = (EventBean)iterator.next();
            Number num = (Number)this.innerExpression.evaluate(eventsLambda, isNewData, context);
            if (num == null) continue;
            agg.enter(num);
        }
        return agg.getValue();
    }

    public static CodegenExpression codegen(EnumAverageBigDecimalEventsForge forge, EnumForgeCodegenParams args, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        Class innerType = forge.innerExpression.getEvaluationType();
        CodegenExpressionField math = codegenClassScope.addOrGetFieldSharable(new MathContextCodegenField(forge.optionalMathContext));
        ExprForgeCodegenSymbol scope = new ExprForgeCodegenSymbol(false, null);
        CodegenMethod methodNode = codegenMethodScope.makeChildWithScope(BigDecimal.class, EnumAverageBigDecimalEventsForgeEval.class, scope, codegenClassScope).addParam(EnumForgeCodegenNames.PARAMS);
        CodegenBlock block = methodNode.getBlock();
        block.declareVar(AggregatorAvgBigDecimal.class, "agg", CodegenExpressionBuilder.newInstance(AggregatorAvgBigDecimal.class, math));
        CodegenBlock forEach = block.forEach(EventBean.class, "next", EnumForgeCodegenNames.REF_ENUMCOLL).assignArrayElement(EnumForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constant(forge.streamNumLambda), (CodegenExpression)CodegenExpressionBuilder.ref("next")).declareVar(innerType, "num", forge.innerExpression.evaluateCodegen(innerType, methodNode, scope, codegenClassScope));
        if (!innerType.isPrimitive()) {
            forEach.ifRefNull("num").blockContinue();
        }
        forEach.expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("agg"), "enter", CodegenExpressionBuilder.ref("num"))).blockEnd();
        block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("agg"), "getValue", new CodegenExpression[0]));
        return CodegenExpressionBuilder.localMethod(methodNode, args.getEps(), args.getEnumcoll(), args.getIsNewData(), args.getExprCtx());
    }

    public static class AggregatorAvgBigDecimal {
        private BigDecimal sum = new BigDecimal(0.0);
        private long cnt;
        private MathContext optionalMathContext;

        public AggregatorAvgBigDecimal(MathContext optionalMathContext) {
            this.optionalMathContext = optionalMathContext;
        }

        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            if (object instanceof BigInteger) {
                this.sum = this.sum.add(new BigDecimal((BigInteger)object));
                return;
            }
            this.sum = this.sum.add((BigDecimal)object);
        }

        public BigDecimal getValue() {
            return AggregatorAvgBig.getValueBigDecimalDivide(this.cnt, this.optionalMathContext, this.sum);
        }
    }
}

