/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenParams;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumEval;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumExceptForge;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumIntersectForgeEval;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;

public class EnumExceptForgeEval
implements EnumEval {
    private final EnumExceptForge forge;
    private final ExprEnumerationEval evaluator;

    public EnumExceptForgeEval(EnumExceptForge forge, ExprEnumerationEval evaluator) {
        this.forge = forge;
        this.evaluator = evaluator;
    }

    @Override
    public Object evaluateEnumMethod(EventBean[] eventsLambda, Collection enumcoll, boolean isNewData, ExprEvaluatorContext context) {
        if (enumcoll == null) {
            return null;
        }
        Collection<EventBean> set = this.forge.scalar ? this.evaluator.evaluateGetROCollectionScalar(eventsLambda, isNewData, context) : this.evaluator.evaluateGetROCollectionEvents(eventsLambda, isNewData, context);
        return EnumExceptForgeEval.enumExceptForgeEvalSet(set, enumcoll, this.forge.scalar);
    }

    public static CodegenExpression codegen(EnumExceptForge forge, EnumForgeCodegenParams args, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        ExprForgeCodegenSymbol scope = new ExprForgeCodegenSymbol(false, null);
        CodegenMethod methodNode = codegenMethodScope.makeChildWithScope(Collection.class, EnumIntersectForgeEval.class, scope, codegenClassScope).addParam(EnumForgeCodegenNames.PARAMS);
        CodegenBlock block = methodNode.getBlock();
        if (forge.scalar) {
            block.declareVar(Collection.class, "other", forge.evaluatorForge.evaluateGetROCollectionScalarCodegen(methodNode, scope, codegenClassScope));
        } else {
            block.declareVar(Collection.class, "other", forge.evaluatorForge.evaluateGetROCollectionEventsCodegen(methodNode, scope, codegenClassScope));
        }
        block.methodReturn(CodegenExpressionBuilder.staticMethod(EnumExceptForgeEval.class, "enumExceptForgeEvalSet", CodegenExpressionBuilder.ref("other"), EnumForgeCodegenNames.REF_ENUMCOLL, CodegenExpressionBuilder.constant(forge.scalar)));
        return CodegenExpressionBuilder.localMethod(methodNode, args.getEps(), args.getEnumcoll(), args.getIsNewData(), args.getExprCtx());
    }

    public static Collection enumExceptForgeEvalSet(Collection other, Collection enumcoll, boolean scalar) {
        if (other == null || other.isEmpty() || enumcoll.isEmpty()) {
            return enumcoll;
        }
        if (scalar) {
            ArrayList result = new ArrayList(enumcoll);
            result.removeAll(other);
            return result;
        }
        Collection targetEvents = enumcoll;
        Collection sourceEvents = other;
        ArrayList<EventBean> result = new ArrayList<EventBean>();
        for (EventBean targetEvent : targetEvents) {
            if (targetEvent == null) {
                result.add(null);
                continue;
            }
            boolean found = false;
            for (EventBean sourceEvent : sourceEvents) {
                if (targetEvent == sourceEvent) {
                    found = true;
                    break;
                }
                if (sourceEvent == null || !targetEvent.getUnderlying().equals(sourceEvent.getUnderlying())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(targetEvent);
        }
        return result;
    }
}

