/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.accessagg;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentDefault;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentForge;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentForgeFactory;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationStateKeyWStream;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationStateTypeWStream;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorFirstLastIndexWEvalForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorFirstWEvalForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorLastWEvalForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorLinearType;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorWindowNoEvalForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorWindowWEvalForge;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationForgeFactoryAccessLinear;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationForgeFactoryFirstLastUnbound;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationLinearFactoryDesc;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationStateLinearForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionNode;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ExprAggMultiFunctionLinearAccessNode
extends ExprAggregateNodeBase
implements ExprEnumerationForge,
ExprAggMultiFunctionNode {
    private final AggregationAccessorLinearType stateType;
    private AggregationForgeFactory aggregationForgeFactory;
    private EventType containedType;
    private Class scalarCollectionComponentType;
    private EventType streamType;

    public ExprAggMultiFunctionLinearAccessNode(AggregationAccessorLinearType stateType) {
        super(false);
        this.stateType = stateType;
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationLinearFactoryDesc desc = validationContext.getStatementRawInfo().getStatementType() == StatementType.CREATE_TABLE ? this.handleCreateTable(this.positionalParams, this.stateType, validationContext) : (validationContext.getStatementRawInfo().getIntoTableName() != null ? this.handleIntoTable(this.positionalParams, this.stateType, validationContext) : this.handleNonIntoTable(this.positionalParams, this.stateType, validationContext));
        this.containedType = desc.getEnumerationEventType();
        this.scalarCollectionComponentType = desc.getScalarCollectionType();
        EventType[] streamTypes = validationContext.getStreamTypeService().getEventTypes();
        this.streamType = desc.getStreamNum() >= streamTypes.length ? streamTypes[0] : streamTypes[desc.getStreamNum()];
        this.aggregationForgeFactory = desc.getFactory();
        return this.aggregationForgeFactory;
    }

    @Override
    public AggregationForgeFactory getAggregationForgeFactory() {
        return this.aggregationForgeFactory;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression future = this.getAggFuture(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(future, "getCollectionScalar", CodegenExpressionBuilder.constant(this.column), exprSymbol.getAddEPS(parent), exprSymbol.getAddIsNewData(parent), exprSymbol.getAddExprEvalCtx(parent));
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression future = this.getAggFuture(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(future, "getEventBean", CodegenExpressionBuilder.constant(this.column), exprSymbol.getAddEPS(parent), exprSymbol.getAddIsNewData(parent), exprSymbol.getAddExprEvalCtx(parent));
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression future = this.getAggFuture(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(future, "getCollectionOfEvents", CodegenExpressionBuilder.constant(this.column), exprSymbol.getAddEPS(parent), exprSymbol.getAddIsNewData(parent), exprSymbol.getAddExprEvalCtx(parent));
    }

    private AggregationLinearFactoryDesc handleNonIntoTable(ExprNode[] childNodes, AggregationAccessorLinearType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        boolean istreamOnly;
        ExprForge forge;
        Class resultType;
        EventType containedType;
        int streamNum;
        boolean isWildcard;
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        ExprNode evaluatorIndex = null;
        Class scalarCollectionComponentType = null;
        boolean bl = isWildcard = childNodes.length == 0 || childNodes.length > 0 && childNodes[0] instanceof ExprWildcard;
        if (isWildcard) {
            ExprAggMultiFunctionUtil.validateWildcardStreamNumbers(validationContext.getStreamTypeService(), stateType.toString().toLowerCase(Locale.ENGLISH));
            streamNum = 0;
            containedType = streamTypeService.getEventTypes()[0];
            resultType = containedType.getUnderlyingType();
            TableMetaData tableMetadata = validationContext.getTableCompileTimeResolver().resolveTableFromEventType(containedType);
            forge = ExprNodeUtilityMake.makeUnderlyingForge(0, resultType, tableMetadata);
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, 0);
            if (stateType == AggregationAccessorLinearType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
        } else if (childNodes.length > 0 && childNodes[0] instanceof ExprStreamUnderlyingNode) {
            EventType type;
            streamNum = ExprAggMultiFunctionUtil.validateStreamWildcardGetStreamNum(childNodes[0]);
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, streamNum);
            if (stateType == AggregationAccessorLinearType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
            containedType = type = streamTypeService.getEventTypes()[streamNum];
            resultType = type.getUnderlyingType();
            TableMetaData tableMetadata = validationContext.getTableCompileTimeResolver().resolveTableFromEventType(type);
            forge = ExprNodeUtilityMake.makeUnderlyingForge(streamNum, resultType, tableMetadata);
        } else {
            ExprNode child = childNodes[0];
            Set<Integer> streams = ExprNodeUtilityQuery.getIdentStreamNumbers(child);
            if (streams.isEmpty() || streams.size() > 1) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that any child expressions evaluate properties of the same stream; Use 'firstever' or 'lastever' or 'nth' instead");
            }
            streamNum = streams.iterator().next();
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, streamNum);
            if (stateType == AggregationAccessorLinearType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
            resultType = childNodes[0].getForge().getEvaluationType();
            forge = childNodes[0].getForge();
            containedType = streamNum >= streamTypeService.getEventTypes().length ? streamTypeService.getEventTypes()[0] : streamTypeService.getEventTypes()[streamNum];
            scalarCollectionComponentType = resultType;
        }
        if (childNodes.length > 1) {
            if (stateType == AggregationAccessorLinearType.WINDOW) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " does not accept an index expression; Use 'first' or 'last' instead");
            }
            evaluatorIndex = childNodes[1];
            Class indexResultType = evaluatorIndex.getForge().getEvaluationType();
            if (indexResultType != Integer.class && indexResultType != Integer.TYPE) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires an index expression that returns an integer value");
            }
        }
        if (evaluatorIndex != null) {
            ExprForge forgeIndex;
            boolean isFirst = stateType == AggregationAccessorLinearType.FIRST;
            int constant = -1;
            if (evaluatorIndex.getForge().getForgeConstantType().isCompileTimeConstant()) {
                constant = (Integer)evaluatorIndex.getForge().getExprEvaluator().evaluate(null, true, null);
                forgeIndex = null;
            } else {
                forgeIndex = evaluatorIndex.getForge();
            }
            accessor = new AggregationAccessorFirstLastIndexWEvalForge(streamNum, forge, forgeIndex, constant, isFirst);
        } else if (stateType == AggregationAccessorLinearType.FIRST) {
            accessor = new AggregationAccessorFirstWEvalForge(streamNum, forge);
        } else if (stateType == AggregationAccessorLinearType.LAST) {
            accessor = new AggregationAccessorLastWEvalForge(streamNum, forge);
        } else if (stateType == AggregationAccessorLinearType.WINDOW) {
            accessor = new AggregationAccessorWindowWEvalForge(streamNum, forge, resultType);
        } else {
            throw new IllegalStateException("Access type is undefined or not known as code '" + (Object)((Object)stateType) + "'");
        }
        Class accessorResultType = resultType;
        if (stateType == AggregationAccessorLinearType.WINDOW) {
            accessorResultType = JavaClassHelper.getArrayType(resultType);
        }
        boolean isFafWindow = streamTypeService.isOnDemandStreams() && stateType == AggregationAccessorLinearType.WINDOW;
        TableMetaData tableMetadata = validationContext.getTableCompileTimeResolver().resolveTableFromEventType(containedType);
        if (tableMetadata == null && !isFafWindow && (istreamOnly || streamTypeService.isOnDemandStreams())) {
            if (this.optionalFilter != null) {
                this.positionalParams = ExprNodeUtilityMake.addExpression(this.positionalParams, this.optionalFilter);
            }
            DataInputOutputSerdeForge serde = validationContext.getSerdeResolver().serdeForAggregation(accessorResultType, validationContext.getStatementRawInfo());
            AggregationForgeFactoryFirstLastUnbound factory = new AggregationForgeFactoryFirstLastUnbound(this, accessorResultType, this.optionalFilter != null, serde);
            return new AggregationLinearFactoryDesc(factory, containedType, scalarCollectionComponentType, streamNum);
        }
        AggregationStateKeyWStream stateKey = new AggregationStateKeyWStream(streamNum, containedType, AggregationStateTypeWStream.DATAWINDOWACCESS_LINEAR, ExprNodeUtilityQuery.EMPTY_EXPR_ARRAY, this.optionalFilter);
        ExprForge optionalFilterForge = this.optionalFilter == null ? null : this.optionalFilter.getForge();
        AggregationStateLinearForge stateFactory = new AggregationStateLinearForge(this, streamNum, optionalFilterForge);
        AggregationForgeFactoryAccessLinear factory = new AggregationForgeFactoryAccessLinear(this, accessor, accessorResultType, stateKey, stateFactory, AggregationAgentDefault.INSTANCE, containedType);
        EventType enumerationType = scalarCollectionComponentType == null ? containedType : null;
        List<StmtClassForgeableFactory> serdeForgables = SerdeEventTypeUtility.plan(containedType, validationContext.getStatementRawInfo(), validationContext.getSerdeEventTypeRegistry(), validationContext.getSerdeResolver());
        validationContext.getAdditionalForgeables().addAll(serdeForgables);
        return new AggregationLinearFactoryDesc(factory, enumerationType, scalarCollectionComponentType, streamNum);
    }

    private AggregationLinearFactoryDesc handleCreateTable(ExprNode[] childNodes, AggregationAccessorLinearType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        String message = "For tables columns, the " + stateType.name().toLowerCase(Locale.ENGLISH) + " aggregation function requires the 'window(*)' declaration";
        if (stateType != AggregationAccessorLinearType.WINDOW) {
            throw new ExprValidationException(message);
        }
        if (childNodes.length == 0 || childNodes.length > 1 || !(childNodes[0] instanceof ExprWildcard)) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that the event type is provided");
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[0];
        Class componentType = containedType.getUnderlyingType();
        AggregationAccessorWindowNoEvalForge accessor = new AggregationAccessorWindowNoEvalForge(componentType);
        AggregationStateLinearForge stateFactory = new AggregationStateLinearForge(this, 0, null);
        AggregationForgeFactoryAccessLinear factory = new AggregationForgeFactoryAccessLinear(this, accessor, JavaClassHelper.getArrayType(componentType), null, stateFactory, null, containedType);
        List<StmtClassForgeableFactory> additionalForgeables = SerdeEventTypeUtility.plan(containedType, validationContext.getStatementRawInfo(), validationContext.getSerdeEventTypeRegistry(), validationContext.getSerdeResolver());
        validationContext.getAdditionalForgeables().addAll(additionalForgeables);
        return new AggregationLinearFactoryDesc(factory, containedType, null, 0);
    }

    private AggregationLinearFactoryDesc handleIntoTable(ExprNode[] childNodes, AggregationAccessorLinearType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        int streamNum;
        String message = "For into-table use 'window(*)' or 'window(stream.*)' instead";
        if (stateType != AggregationAccessorLinearType.WINDOW) {
            throw new ExprValidationException(message);
        }
        if (childNodes.length == 0 || childNodes.length > 1) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that at least one stream is provided");
        }
        if (childNodes[0] instanceof ExprWildcard) {
            if (validationContext.getStreamTypeService().getStreamNames().length != 1) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " with wildcard requires a single stream");
            }
            streamNum = 0;
        } else if (childNodes[0] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)childNodes[0];
            streamNum = und.getStreamId();
        } else {
            throw new ExprValidationException(message);
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        Class componentType = containedType.getUnderlyingType();
        AggregationAccessorWindowNoEvalForge accessor = new AggregationAccessorWindowNoEvalForge(componentType);
        AggregationAgentForge agent = AggregationAgentForgeFactory.make(streamNum, this.optionalFilter, validationContext.getClasspathImportService(), validationContext.getStreamTypeService().isOnDemandStreams(), validationContext.getStatementName());
        AggregationForgeFactoryAccessLinear factory = new AggregationForgeFactoryAccessLinear(this, accessor, JavaClassHelper.getArrayType(componentType), null, null, agent, containedType);
        return new AggregationLinearFactoryDesc(factory, containedType, null, 0);
    }

    protected static boolean getIstreamOnly(StreamTypeService streamTypeService, int streamNum) {
        if (streamNum < streamTypeService.getEventTypes().length) {
            return streamTypeService.getIStreamOnly()[streamNum];
        }
        return streamTypeService.getIStreamOnly()[0];
    }

    @Override
    public String getAggregationFunctionName() {
        return this.stateType.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.stateType.toString().toLowerCase(Locale.ENGLISH));
        ExprNodeUtilityPrint.toExpressionStringParams(writer, this.getChildNodes());
    }

    public AggregationAccessorLinearType getStateType() {
        return this.stateType;
    }

    @Override
    public EventType getEventTypeCollection(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        if (this.stateType == AggregationAccessorLinearType.FIRST || this.stateType == AggregationAccessorLinearType.LAST) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public Class getComponentTypeCollection() {
        return this.scalarCollectionComponentType;
    }

    @Override
    public EventType getEventTypeSingle(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        if (this.stateType == AggregationAccessorLinearType.FIRST || this.stateType == AggregationAccessorLinearType.LAST) {
            return this.containedType;
        }
        return null;
    }

    @Override
    protected boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprAggMultiFunctionLinearAccessNode)) {
            return false;
        }
        ExprAggMultiFunctionLinearAccessNode other = (ExprAggMultiFunctionLinearAccessNode)node;
        return this.stateType == other.stateType && this.containedType == other.containedType && this.scalarCollectionComponentType == other.scalarCollectionComponentType;
    }

    private static ExprValidationException makeUnboundValidationEx(AggregationAccessorLinearType stateType) {
        return new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that the aggregated events provide a remove stream; Please define a data window onto the stream or use 'firstever', 'lastever' or 'nth' instead");
    }

    private static String getErrorPrefix(AggregationAccessorLinearType stateType) {
        return ExprAggMultiFunctionUtil.getErrorPrefix(stateType.toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }

    public EventType getStreamType() {
        return this.streamType;
    }
}

