/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.method;

import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.nth.AggregationForgeFactoryNth;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;

public class ExprNthAggNode
extends ExprAggregateNodeBase {
    public ExprNthAggNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        String message = "The nth aggregation function requires two parameters, an expression returning aggregation values and a numeric index constant";
        if (this.positionalParams.length != 2) {
            throw new ExprValidationException(message);
        }
        ExprNode first = this.positionalParams[0];
        ExprNode second = this.positionalParams[1];
        if (!second.getForge().getForgeConstantType().isCompileTimeConstant()) {
            throw new ExprValidationException(message);
        }
        Number num = (Number)second.getForge().getExprEvaluator().evaluate(null, true, null);
        int size = num.intValue();
        if (this.optionalFilter != null) {
            this.positionalParams = ExprNodeUtilityMake.addExpression(this.positionalParams, this.optionalFilter);
        }
        Class childType = first.getForge().getEvaluationType();
        DataInputOutputSerdeForge serde = validationContext.getSerdeResolver().serdeForAggregationDistinct(childType, validationContext.getStatementRawInfo());
        DataInputOutputSerdeForge distinctValueSerde = this.isDistinct ? serde : null;
        return new AggregationForgeFactoryNth(this, childType, serde, distinctValueSerde, size);
    }

    @Override
    public String getAggregationFunctionName() {
        return "nth";
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return node instanceof ExprNthAggNode;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

