/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.method;

import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionForge;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionMode;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionModeCodeGenerated;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionModeManaged;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionModeMultiParam;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionValidationContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.method.plugin.AggregationForgeFactoryPlugin;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprPlugInAggNodeMarker;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityAggregation;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class ExprPlugInAggNode
extends ExprAggregateNodeBase
implements ExprPlugInAggNodeMarker {
    private AggregationFunctionForge aggregationFunctionForge;
    private final String functionName;

    public ExprPlugInAggNode(boolean distinct, AggregationFunctionForge aggregationFunctionForge, String functionName) {
        super(distinct);
        this.aggregationFunctionForge = aggregationFunctionForge;
        this.functionName = functionName;
        aggregationFunctionForge.setFunctionName(functionName);
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        Class[] parameterTypes = new Class[this.positionalParams.length];
        Object[] constant = new Object[this.positionalParams.length];
        boolean[] isConstant = new boolean[this.positionalParams.length];
        ExprNode[] expressions = new ExprNode[this.positionalParams.length];
        int count = 0;
        boolean hasDataWindows = true;
        for (ExprNode child : this.positionalParams) {
            if (child.getForge().getForgeConstantType() == ExprForgeConstantType.COMPILETIMECONST) {
                isConstant[count] = true;
                constant[count] = child.getForge().getExprEvaluator().evaluate(null, true, null);
            }
            parameterTypes[count] = child.getForge().getEvaluationType();
            expressions[count] = child;
            if (!ExprNodeUtilityAggregation.hasRemoveStreamForAggregations(child, validationContext.getStreamTypeService(), validationContext.isResettingAggregations())) {
                hasDataWindows = false;
            }
            if (child instanceof ExprWildcard) {
                ExprAggMultiFunctionUtil.checkWildcardNotJoinOrSubquery(validationContext.getStreamTypeService(), this.functionName);
                parameterTypes[count] = validationContext.getStreamTypeService().getEventTypes()[0].getUnderlyingType();
                isConstant[count] = false;
                constant[count] = null;
            }
            ++count;
        }
        LinkedHashMap<String, List<ExprNode>> namedParameters = null;
        if (this.optionalFilter != null) {
            namedParameters = new LinkedHashMap<String, List<ExprNode>>();
            namedParameters.put("filter", Collections.singletonList(this.optionalFilter));
            this.positionalParams = ExprNodeUtilityMake.addExpression(this.positionalParams, this.optionalFilter);
        }
        AggregationFunctionValidationContext context = new AggregationFunctionValidationContext(parameterTypes, isConstant, constant, super.isDistinct(), hasDataWindows, expressions, namedParameters);
        try {
            if (this.aggregationFunctionForge == null) {
                this.aggregationFunctionForge = validationContext.getClasspathImportService().resolveAggregationFunction(this.functionName);
            }
            this.aggregationFunctionForge.validate(context);
        }
        catch (Exception ex) {
            throw new ExprValidationException("Plug-in aggregation function '" + this.functionName + "' failed validation: " + ex.getMessage(), ex);
        }
        AggregationFunctionMode mode = this.aggregationFunctionForge.getAggregationFunctionMode();
        if (mode == null) {
            throw new ExprValidationException("Aggregation function forge returned a null value for mode");
        }
        if (mode instanceof AggregationFunctionModeManaged) {
            if (this.positionalParams.length > 2) {
                throw new ExprValidationException("Aggregation function forge single-value mode requires zero, one or two parameters");
            }
        } else if (!(mode instanceof AggregationFunctionModeMultiParam) && !(mode instanceof AggregationFunctionModeCodeGenerated)) {
            throw new ExprValidationException("Aggregation function forge returned an unrecognized mode " + mode);
        }
        Class aggregatedValueType = this.getPositionalParams().length == 0 ? null : this.getPositionalParams()[0].getForge().getEvaluationType();
        DataInputOutputSerdeForge distinctForge = this.isDistinct ? validationContext.getSerdeResolver().serdeForAggregationDistinct(aggregatedValueType, validationContext.getStatementRawInfo()) : null;
        return new AggregationForgeFactoryPlugin(this, this.aggregationFunctionForge, mode, aggregatedValueType, distinctForge);
    }

    @Override
    public String getAggregationFunctionName() {
        return this.functionName;
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggNode)) {
            return false;
        }
        ExprPlugInAggNode other = (ExprPlugInAggNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

