/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprFilterSpecLookupable {
    private final String expression;
    private final transient EventPropertyValueGetter getter;
    private final Class returnType;
    private final boolean isNonPropertyGetter;
    private final DataInputOutputSerde<Object> valueSerde;

    public ExprFilterSpecLookupable(String expression, EventPropertyValueGetter getter, Class returnType, boolean isNonPropertyGetter, DataInputOutputSerde<Object> valueSerde) {
        this.expression = expression;
        this.getter = getter;
        this.returnType = JavaClassHelper.getBoxedType(returnType);
        this.isNonPropertyGetter = isNonPropertyGetter;
        this.valueSerde = valueSerde;
    }

    public String getExpression() {
        return this.expression;
    }

    public EventPropertyValueGetter getGetter() {
        return this.getter;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprFilterSpecLookupable that = (ExprFilterSpecLookupable)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public void appendTo(StringWriter writer) {
        writer.append(this.expression);
    }

    public String toString() {
        return "ExprFilterSpecLookupable{expression='" + this.expression + '\'' + '}';
    }

    public boolean isNonPropertyGetter() {
        return this.isNonPropertyGetter;
    }

    public DataInputOutputSerde<Object> getValueSerde() {
        return this.valueSerde;
    }
}

