/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.event.core.EventPropertyValueGetterForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class ExprFilterSpecLookupableForge {
    protected final String expression;
    protected final EventPropertyValueGetterForge optionalEventPropForge;
    protected final Class returnType;
    protected final boolean isNonPropertyGetter;
    protected final DataInputOutputSerdeForge valueSerde;

    public ExprFilterSpecLookupableForge(String expression, EventPropertyValueGetterForge optionalEventPropForge, Class returnType, boolean isNonPropertyGetter, DataInputOutputSerdeForge valueSerde) {
        this.expression = expression;
        this.optionalEventPropForge = optionalEventPropForge;
        this.returnType = JavaClassHelper.getBoxedType(returnType);
        this.isNonPropertyGetter = isNonPropertyGetter;
        this.valueSerde = valueSerde;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getExpression() {
        return this.expression;
    }

    public CodegenMethod makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols, CodegenClassScope classScope) {
        CodegenExpression getterExpr;
        CodegenMethod method = parent.makeChild(ExprFilterSpecLookupable.class, ExprFilterSpecLookupableForge.class, (CodegenScope)classScope);
        if (this.optionalEventPropForge != null) {
            CodegenExpressionNewAnonymousClass anonymous = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), EventPropertyValueGetter.class);
            CodegenMethod get = CodegenMethod.makeParentNode(Object.class, this.getClass(), classScope).addParam(CodegenNamedParam.from(EventBean.class, "bean"));
            anonymous.addMethod("get", get);
            get.getBlock().methodReturn(this.optionalEventPropForge.eventBeanGetCodegen(CodegenExpressionBuilder.ref("bean"), method, classScope));
            getterExpr = anonymous;
        } else {
            getterExpr = CodegenExpressionBuilder.constantNull();
        }
        method.getBlock().declareVar(EventPropertyValueGetter.class, "getter", getterExpr);
        method.getBlock().declareVar(ExprFilterSpecLookupable.class, "lookupable", CodegenExpressionBuilder.newInstance(ExprFilterSpecLookupable.class, CodegenExpressionBuilder.constant(this.expression), CodegenExpressionBuilder.ref("getter"), CodegenExpressionBuilder.enumValue(this.returnType, "class"), CodegenExpressionBuilder.constant(this.isNonPropertyGetter), this.valueSerde.codegen(method, classScope, null))).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getFilterSharedLookupableRegistery", new CodegenExpression[0]).add("registerLookupable", symbols.getAddEventType(method), CodegenExpressionBuilder.ref("lookupable"))).methodReturn(CodegenExpressionBuilder.ref("lookupable"));
        return method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprFilterSpecLookupableForge that = (ExprFilterSpecLookupableForge)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }
}

