/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExpression;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionForge;
import com.espertech.esper.common.client.util.TimePeriod;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDeclaredOrLambdaNode;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprPlugInAggNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprGroupingIdNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeProxy;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeImpl;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeGroupingVisitorWParent;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeViewResourceVisitor;
import com.espertech.esper.common.internal.event.property.MappedPropertyParseResult;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParserNoDep;
import com.espertech.esper.common.internal.settings.ClasspathImportCompileTimeUtil;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import com.espertech.esper.common.internal.settings.ClasspathImportUndefinedException;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.EnumValue;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeUtilityValidate {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeUtilityValidate.class);

    public static void validatePlainExpression(ExprNodeOrigin origin, ExprNode[] expressions) throws ExprValidationException {
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        for (ExprNode expression : expressions) {
            ExprNodeUtilityValidate.validatePlainExpression(origin, expression, summaryVisitor);
        }
    }

    public static void validatePlainExpression(ExprNodeOrigin origin, ExprNode expression) throws ExprValidationException {
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        ExprNodeUtilityValidate.validatePlainExpression(origin, expression, summaryVisitor);
    }

    public static ExprNode getValidatedAssignment(OnTriggerSetAssignment assignment, ExprValidationContext validationContext) throws ExprValidationException {
        Pair<String, ExprNode> strictAssignment = ExprNodeUtilityValidate.checkGetAssignmentToVariableOrProp(assignment.getExpression());
        if (strictAssignment != null) {
            ExprNode validatedRightSide = ExprNodeUtilityValidate.getValidatedSubtreeInternal(strictAssignment.getSecond(), validationContext, true);
            assignment.getExpression().setChildNode(1, validatedRightSide);
            return assignment.getExpression();
        }
        return ExprNodeUtilityValidate.getValidatedSubtreeInternal(assignment.getExpression(), validationContext, true);
    }

    public static String isMinimalExpression(ExprNode expression) {
        ExprNodeSubselectDeclaredDotVisitor subselectVisitor = new ExprNodeSubselectDeclaredDotVisitor();
        expression.accept(subselectVisitor);
        if (subselectVisitor.getSubselects().size() > 0) {
            return "a subselect";
        }
        ExprNodeViewResourceVisitor viewResourceVisitor = new ExprNodeViewResourceVisitor();
        expression.accept(viewResourceVisitor);
        if (viewResourceVisitor.getExprNodes().size() > 0) {
            return "a function that requires view resources (prior, prev)";
        }
        LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(expression, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            return "an aggregation function";
        }
        return null;
    }

    public static ExprNode getValidatedSubtree(ExprNodeOrigin origin, ExprNode exprNode, ExprValidationContext validationContext) throws ExprValidationException {
        if (exprNode instanceof ExprLambdaGoesNode) {
            return exprNode;
        }
        try {
            return ExprNodeUtilityValidate.getValidatedSubtreeInternal(exprNode, validationContext, true);
        }
        catch (ExprValidationException ex) {
            try {
                String text;
                if (exprNode instanceof ExprSubselectNode) {
                    ExprSubselectNode subselect = (ExprSubselectNode)exprNode;
                    text = ExprNodeUtilityMake.getSubqueryInfoText(subselect);
                } else {
                    text = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(exprNode);
                    if (text.length() > 40) {
                        String shortened = text.substring(0, 35);
                        text = shortened + "...(" + text.length() + " chars)";
                    }
                    text = "'" + text + "'";
                }
                throw new ExprValidationException("Failed to validate " + origin.getClauseName() + " expression " + text + ": " + ex.getMessage(), ex);
            }
            catch (RuntimeException rtex) {
                log.debug("Failed to render nice validation message text: " + rtex.getMessage(), (Throwable)rtex);
                throw ex;
            }
        }
    }

    public static boolean validateNamedExpectType(ExprNamedParameterNode namedParameterNode, Class[] expectedTypes) throws ExprValidationException {
        if (namedParameterNode.getChildNodes().length != 1) {
            throw ExprNodeUtilityValidate.getNamedValidationException(namedParameterNode.getParameterName(), expectedTypes);
        }
        ExprNode childNode = namedParameterNode.getChildNodes()[0];
        Class returnType = JavaClassHelper.getBoxedType(childNode.getForge().getEvaluationType());
        boolean found = false;
        for (Class expectedType : expectedTypes) {
            if (expectedType == TimePeriod.class && childNode instanceof ExprTimePeriod) {
                found = true;
                break;
            }
            if (returnType != JavaClassHelper.getBoxedType(expectedType)) continue;
            found = true;
            break;
        }
        if (found) {
            return namedParameterNode.getChildNodes()[0].getForge().getForgeConstantType().isCompileTimeConstant();
        }
        throw ExprNodeUtilityValidate.getNamedValidationException(namedParameterNode.getParameterName(), expectedTypes);
    }

    private static ExprValidationException getNamedValidationException(String parameterName, Class[] expected) {
        String expectedType;
        if (expected.length == 1) {
            expectedType = "a " + JavaClassHelper.getSimpleNameForClass(expected[0]) + "-typed value";
        } else {
            StringWriter buf = new StringWriter();
            buf.append("any of the following types: ");
            String delimiter = "";
            for (Class clazz : expected) {
                buf.append(delimiter);
                buf.append(JavaClassHelper.getSimpleNameForClass(clazz));
                delimiter = ",";
            }
            expectedType = buf.toString();
        }
        String message = "Failed to validate named parameter '" + parameterName + "', expected a single expression returning " + expectedType;
        return new ExprValidationException(message);
    }

    public static Map<String, ExprNamedParameterNode> getNamedExpressionsHandleDups(List<ExprNode> parameters) throws ExprValidationException {
        HashMap<String, ExprNamedParameterNode> nameds = null;
        for (ExprNode node : parameters) {
            String lowerCaseName;
            if (!(node instanceof ExprNamedParameterNode)) continue;
            ExprNamedParameterNode named = (ExprNamedParameterNode)((Object)node);
            if (nameds == null) {
                nameds = new HashMap<String, ExprNamedParameterNode>();
            }
            if (nameds.containsKey(lowerCaseName = named.getParameterName().toLowerCase(Locale.ENGLISH))) {
                throw new ExprValidationException("Duplicate parameter '" + lowerCaseName + "'");
            }
            nameds.put(lowerCaseName, named);
        }
        if (nameds == null) {
            return Collections.emptyMap();
        }
        return nameds;
    }

    public static void validateNamed(Map<String, ExprNamedParameterNode> namedExpressions, String[] namedParameters) throws ExprValidationException {
        for (Map.Entry<String, ExprNamedParameterNode> entry : namedExpressions.entrySet()) {
            boolean found = false;
            for (String named : namedParameters) {
                if (!named.equals(entry.getKey())) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new ExprValidationException("Unexpected named parameter '" + entry.getKey() + "', expecting any of the following: " + CollectionUtil.toStringArray(namedParameters));
        }
    }

    private static ExprNode getValidatedSubtreeInternal(ExprNode exprNode, ExprValidationContext validationContext, boolean isTopLevel) throws ExprValidationException {
        ExprNode result = exprNode;
        if (exprNode instanceof ExprLambdaGoesNode) {
            return exprNode;
        }
        for (int i = 0; i < exprNode.getChildNodes().length; ++i) {
            ExprDeclaredOrLambdaNode node;
            ExprNode childNode = exprNode.getChildNodes()[i];
            if (childNode instanceof ExprDeclaredOrLambdaNode && (node = (ExprDeclaredOrLambdaNode)((Object)childNode)).validated()) continue;
            ExprNode childNodeValidated = ExprNodeUtilityValidate.getValidatedSubtreeInternal(childNode, validationContext, false);
            exprNode.setChildNode(i, childNodeValidated);
        }
        try {
            ExprNode optionalReplacement = exprNode.validate(validationContext);
            if (optionalReplacement != null) {
                return ExprNodeUtilityValidate.getValidatedSubtreeInternal(optionalReplacement, validationContext, isTopLevel);
            }
        }
        catch (ExprValidationException e) {
            if (exprNode instanceof ExprIdentNode) {
                ExprIdentNode identNode = (ExprIdentNode)exprNode;
                try {
                    result = ExprNodeUtilityValidate.resolveStaticMethodOrField(identNode, e, validationContext);
                }
                catch (ExprValidationException ex) {
                    e = ex;
                    result = ExprNodeUtilityValidate.resolveAsStreamName(identNode, e, validationContext);
                }
            }
            throw e;
        }
        if (isTopLevel ? validationContext.isExpressionAudit() : validationContext.isExpressionNestedAudit() && !(result instanceof ExprIdentNode) && !ExprNodeUtilityQuery.isConstant(result)) {
            return (ExprNode)ExprNodeProxy.newInstance(result);
        }
        return result;
    }

    public static void getValidatedSubtree(ExprNodeOrigin origin, ExprNode[] exprNode, ExprValidationContext validationContext) throws ExprValidationException {
        if (exprNode == null) {
            return;
        }
        for (int i = 0; i < exprNode.length; ++i) {
            exprNode[i] = ExprNodeUtilityValidate.getValidatedSubtree(origin, exprNode[i], validationContext);
        }
    }

    public static void getValidatedSubtree(ExprNodeOrigin origin, ExprNode[][] exprNode, ExprValidationContext validationContext) throws ExprValidationException {
        if (exprNode == null) {
            return;
        }
        for (ExprNode[] anExprNode : exprNode) {
            ExprNodeUtilityValidate.getValidatedSubtree(origin, anExprNode, validationContext);
        }
    }

    public static void validate(ExprNodeOrigin origin, List<ExprChainedSpec> chainSpec, ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprChainedSpec chainElement : chainSpec) {
            ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
            for (ExprNode expr : chainElement.getParameters()) {
                validated.add(ExprNodeUtilityValidate.getValidatedSubtree(origin, expr, validationContext));
                if (!(expr instanceof ExprNamedParameterNode)) continue;
                throw new ExprValidationException("Named parameters are not allowed");
            }
            chainElement.setParameters(validated);
        }
    }

    private static void validatePlainExpression(ExprNodeOrigin origin, ExprNode expression, ExprNodeSummaryVisitor summaryVisitor) throws ExprValidationException {
        expression.accept(summaryVisitor);
        if (summaryVisitor.isHasAggregation() || summaryVisitor.isHasSubselect() || summaryVisitor.isHasStreamSelect() || summaryVisitor.isHasPreviousPrior()) {
            String text = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(expression);
            throw new ExprValidationException("Invalid " + origin.getClauseName() + " expression '" + text + "': Aggregation, sub-select, previous or prior functions are not supported in this context");
        }
    }

    private static ExprNode resolveStaticMethodOrField(ExprIdentNode identNode, ExprValidationException propertyException, ExprValidationContext validationContext) throws ExprValidationException {
        MappedPropertyParseResult parse;
        StringBuilder mappedProperty = new StringBuilder(identNode.getUnresolvedPropertyName());
        if (identNode.getStreamOrPropertyName() != null) {
            mappedProperty.insert(0, identNode.getStreamOrPropertyName() + '.');
        }
        if ((parse = PropertyParserNoDep.parseMappedProperty(mappedProperty.toString())) == null) {
            ExprConstantNode constNode = ExprNodeUtilityValidate.resolveIdentAsEnumConst(mappedProperty.toString(), validationContext.getClasspathImportService());
            if (constNode == null) {
                throw propertyException;
            }
            return constNode;
        }
        if (parse.getClassName() != null) {
            List<ExprNode> parameters = Collections.singletonList(new ExprConstantNodeImpl(parse.getArgString()));
            ArrayList<ExprChainedSpec> chain = new ArrayList<ExprChainedSpec>();
            chain.add(new ExprChainedSpec(parse.getClassName(), Collections.emptyList(), false));
            chain.add(new ExprChainedSpec(parse.getMethodName(), parameters, false));
            ConfigurationCompilerExpression exprconfig = validationContext.getStatementCompileTimeService().getConfiguration().getCompiler().getExpression();
            ExprDotNodeImpl result = new ExprDotNodeImpl(chain, exprconfig.isDuckTyping(), exprconfig.isUdfCache());
            try {
                result.validate(validationContext);
            }
            catch (ExprValidationException e) {
                throw new ExprValidationException("Failed to resolve enumeration method, date-time method or mapped property '" + mappedProperty + "': " + e.getMessage());
            }
            return result;
        }
        String functionName = parse.getMethodName();
        try {
            Pair<Class, ClasspathImportSingleRowDesc> classMethodPair = validationContext.getClasspathImportService().resolveSingleRow(functionName);
            List<ExprNode> parameters = Collections.singletonList(new ExprConstantNodeImpl(parse.getArgString()));
            List<ExprChainedSpec> chain = Collections.singletonList(new ExprChainedSpec(classMethodPair.getSecond().getMethodName(), parameters, false));
            ExprPlugInSingleRowNode result = new ExprPlugInSingleRowNode(functionName, classMethodPair.getFirst(), chain, classMethodPair.getSecond());
            try {
                result.validate(validationContext);
            }
            catch (RuntimeException e) {
                throw new ExprValidationException("Plug-in aggregation function '" + parse.getMethodName() + "' failed validation: " + e.getMessage());
            }
            return result;
        }
        catch (ClasspathImportUndefinedException classMethodPair) {
        }
        catch (ClasspathImportException e) {
            throw new IllegalStateException("Error resolving single-row function: " + e.getMessage(), e);
        }
        try {
            AggregationFunctionForge aggregationForge = validationContext.getClasspathImportService().resolveAggregationFunction(parse.getMethodName());
            ExprPlugInAggNode result = new ExprPlugInAggNode(false, aggregationForge, parse.getMethodName());
            result.addChildNode(new ExprConstantNodeImpl(parse.getArgString()));
            try {
                result.validate(validationContext);
            }
            catch (RuntimeException e) {
                throw new ExprValidationException("Plug-in aggregation function '" + parse.getMethodName() + "' failed validation: " + e.getMessage());
            }
            return result;
        }
        catch (ClasspathImportUndefinedException aggregationForge) {
        }
        catch (ClasspathImportException e) {
            throw new IllegalStateException("Error resolving aggregation: " + e.getMessage(), e);
        }
        throw propertyException;
    }

    private static ExprNode resolveAsStreamName(ExprIdentNode identNode, ExprValidationException existingException, ExprValidationContext validationContext) throws ExprValidationException {
        ExprStreamUnderlyingNodeImpl exprStream = new ExprStreamUnderlyingNodeImpl(identNode.getUnresolvedPropertyName(), false);
        try {
            exprStream.validate(validationContext);
        }
        catch (ExprValidationException ex) {
            throw existingException;
        }
        return exprStream;
    }

    private static ExprConstantNode resolveIdentAsEnumConst(String constant, ClasspathImportServiceCompileTime classpathImportService) throws ExprValidationException {
        EnumValue enumValue = ClasspathImportCompileTimeUtil.resolveIdentAsEnum(constant, classpathImportService, false);
        if (enumValue != null) {
            return new ExprConstantNodeImpl(enumValue);
        }
        return null;
    }

    public static Pair<String, ExprNode> checkGetAssignmentToVariableOrProp(ExprNode node) throws ExprValidationException {
        Pair<String, ExprNode> prop = ExprNodeUtilityValidate.checkGetAssignmentToProp(node);
        if (prop != null) {
            return prop;
        }
        if (!(node instanceof ExprEqualsNode)) {
            return null;
        }
        ExprEqualsNode equals = (ExprEqualsNode)node;
        if (equals.getChildNodes()[0] instanceof ExprVariableNode) {
            ExprVariableNode variableNode = (ExprVariableNode)((Object)equals.getChildNodes()[0]);
            return new Pair<String, ExprNode>(variableNode.getVariableNameWithSubProp(), equals.getChildNodes()[1]);
        }
        if (equals.getChildNodes()[0] instanceof ExprTableAccessNode) {
            throw new ExprValidationException("Table access expression not allowed on the left hand side, please remove the table prefix");
        }
        return null;
    }

    public static Pair<String, ExprNode> checkGetAssignmentToProp(ExprNode node) {
        if (!(node instanceof ExprEqualsNode)) {
            return null;
        }
        ExprEqualsNode equals = (ExprEqualsNode)node;
        if (!(equals.getChildNodes()[0] instanceof ExprIdentNode)) {
            return null;
        }
        ExprIdentNode identNode = (ExprIdentNode)equals.getChildNodes()[0];
        return new Pair<String, ExprNode>(identNode.getFullUnresolvedName(), equals.getChildNodes()[1]);
    }

    public static void validateNoSpecialsGroupByExpressions(ExprNode[] groupByNodes) throws ExprValidationException {
        ExprNodeSubselectDeclaredDotVisitor visitorSubselects = new ExprNodeSubselectDeclaredDotVisitor();
        ExprNodeGroupingVisitorWParent visitorGrouping = new ExprNodeGroupingVisitorWParent();
        ArrayList<ExprAggregateNode> aggNodesInGroupBy = new ArrayList<ExprAggregateNode>(1);
        for (ExprNode groupByNode : groupByNodes) {
            groupByNode.accept(visitorSubselects);
            if (visitorSubselects.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within group-by");
            }
            groupByNode.accept(visitorGrouping);
            if (!visitorGrouping.getGroupingIdNodes().isEmpty()) {
                throw ExprGroupingIdNode.makeException("grouping_id");
            }
            if (!visitorGrouping.getGroupingNodes().isEmpty()) {
                throw ExprGroupingIdNode.makeException("grouping");
            }
            ExprAggregateNodeUtil.getAggregatesBottomUp(groupByNode, aggNodesInGroupBy);
            if (aggNodesInGroupBy.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions cannot contain aggregate functions");
        }
    }
}

