/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeVarargOnlyArrayEvalNoCoerce;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeVarargOnlyArrayForgeWithCoerce;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.io.StringWriter;

class ExprNodeVarargOnlyArrayForge
implements ExprForge,
ExprNodeRenderable {
    private final ExprForge[] forges;
    protected final Class varargClass;
    protected final SimpleNumberCoercer[] optionalCoercers;

    public ExprNodeVarargOnlyArrayForge(ExprForge[] forges, Class varargClass, SimpleNumberCoercer[] optionalCoercers) {
        this.forges = forges;
        this.varargClass = varargClass;
        this.optionalCoercers = optionalCoercers;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        if (this.optionalCoercers == null) {
            return new ExprNodeVarargOnlyArrayEvalNoCoerce(this, ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.forges));
        }
        return new ExprNodeVarargOnlyArrayForgeWithCoerce(this, ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.forges));
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class arrayType = JavaClassHelper.getArrayType(this.varargClass);
        CodegenMethod methodNode = codegenMethodScope.makeChild(arrayType, ExprNodeVarargOnlyArrayForge.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(arrayType, "array", CodegenExpressionBuilder.newArrayByLength(this.varargClass, CodegenExpressionBuilder.constant(this.forges.length)));
        for (int i = 0; i < this.forges.length; ++i) {
            Class evalType;
            CodegenExpression expression = this.forges[i].evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope);
            CodegenExpression assignment = this.optionalCoercers == null || this.optionalCoercers[i] == null ? expression : ((evalType = this.forges[i].getEvaluationType()).isPrimitive() ? this.optionalCoercers[i].coerceCodegen(expression, evalType) : this.optionalCoercers[i].coerceCodegenMayNullBoxed(expression, evalType, methodNode, codegenClassScope));
            block.assignArrayElement("array", CodegenExpressionBuilder.constant(i), assignment);
        }
        block.methodReturn(CodegenExpressionBuilder.ref("array"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public Class getEvaluationType() {
        return JavaClassHelper.getArrayType(this.varargClass);
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence) {
        writer.append(this.getClass().getSimpleName());
    }
}

