/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import java.io.StringWriter;

public class ExprStreamUnderlyingNodeImpl
extends ExprNodeBase
implements ExprForgeInstrumentable,
ExprEvaluator,
ExprStreamUnderlyingNode {
    private final String streamName;
    private final boolean isWildcard;
    private int streamNum = -1;
    private Class type;
    private transient EventType eventType;
    private static final long serialVersionUID = 6611578192872250478L;

    public ExprStreamUnderlyingNodeImpl(String streamName, boolean isWildcard) {
        if (streamName == null && !isWildcard) {
            throw new IllegalArgumentException("Stream name is null");
        }
        this.streamName = streamName;
        this.isWildcard = isWildcard;
    }

    @Override
    public Class getEvaluationType() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.type;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        return this.getStreamId();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        return null;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.streamName == null && this.isWildcard) {
            if (validationContext.getStreamTypeService().getStreamNames().length > 1) {
                throw new ExprValidationException("Wildcard must be stream wildcard if specifying multiple streams, use the 'streamname.*' syntax instead");
            }
            this.streamNum = 0;
        } else {
            this.streamNum = validationContext.getStreamTypeService().getStreamNumForStreamName(this.streamName);
        }
        if (this.streamNum == -1) {
            throw new ExprValidationException("Stream by name '" + this.streamName + "' could not be found among all streams");
        }
        this.eventType = validationContext.getStreamTypeService().getEventTypes()[this.streamNum];
        this.type = this.eventType.getUnderlyingType();
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.streamNum;
    }

    public String toString() {
        return "streamName=" + this.streamName + " streamNum=" + this.streamNum;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return event.getUnderlying();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(this.eventType.getUnderlyingType(), ExprStreamUnderlyingNodeImpl.class, (CodegenScope)codegenClassScope);
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
        methodNode.getBlock().declareVar(EventBean.class, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamNum))).ifRefNullReturnNull("event").methodReturn(CodegenExpressionBuilder.cast(this.eventType.getUnderlyingType(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("event"), "getUnderlying", new CodegenExpression[0])));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprStreamUnd", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.streamName);
        if (this.isWildcard) {
            writer.append(".*");
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprStreamUnderlyingNodeImpl)) {
            return false;
        }
        ExprStreamUnderlyingNodeImpl other = (ExprStreamUnderlyingNodeImpl)node;
        if (this.isWildcard != other.isWildcard) {
            return false;
        }
        if (this.isWildcard) {
            return true;
        }
        return this.streamName.equals(other.streamName);
    }
}

