/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeDeployTimeConst;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.type.ClassIdentifierWArray;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprSubstitutionNode
extends ExprNodeBase
implements ExprForge,
ExprNodeDeployTimeConst {
    private String optionalName;
    private ClassIdentifierWArray optionalType;
    private Class type = Object.class;
    private CodegenExpressionField field;

    public ExprSubstitutionNode(String optionalName, ClassIdentifierWArray optionalType) {
        this.optionalName = optionalName;
        this.optionalType = optionalType;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.optionalType != null) {
            Class clazz = null;
            try {
                clazz = JavaClassHelper.getClassForName(this.optionalType.getClassIdentifier(), validationContext.getClasspathImportService().getClassForNameProvider());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = JavaClassHelper.getClassForSimpleName(this.optionalType.getClassIdentifier(), validationContext.getClasspathImportService().getClassForNameProvider());
            }
            if (clazz != null) {
                this.type = clazz;
            } else {
                try {
                    this.type = validationContext.getClasspathImportService().resolveClass(this.optionalType.getClassIdentifier(), false);
                }
                catch (ClasspathImportException e) {
                    throw new ExprValidationException("Failed to resolve type '" + this.optionalType.getClassIdentifier() + "': " + e.getMessage(), e);
                }
            }
            if (this.type != null && this.optionalType.isArrayOfPrimitive() && !this.type.isPrimitive()) {
                throw new ExprValidationException("Invalid use of the 'primitive' keyword for non-primitive type '" + this.type.getName() + "'");
            }
            if (!this.optionalType.isArrayOfPrimitive()) {
                this.type = JavaClassHelper.getBoxedType(this.type);
            }
            this.type = JavaClassHelper.getArrayType(this.type, this.optionalType.getArrayDimensions());
        }
        return null;
    }

    public String getOptionalName() {
        return this.optionalName;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("?");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprSubstitutionNode;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.asField(codegenClassScope);
    }

    @Override
    public CodegenExpression codegenGetDeployTimeConstValue(CodegenClassScope classScope) {
        return this.asField(classScope);
    }

    @Override
    public Class getEvaluationType() {
        return this.type;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.DEPLOYCONST;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return new ExprNodeRenderable(){

            @Override
            public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence) {
                writer.append("?");
            }
        };
    }

    public ClassIdentifierWArray getOptionalType() {
        return this.optionalType;
    }

    public Class getResolvedType() {
        return this.type;
    }

    private CodegenExpressionField asField(CodegenClassScope classScope) {
        if (this.field == null) {
            this.field = CodegenExpressionBuilder.field(classScope.addSubstitutionParameter(this.optionalName, this.type));
        }
        return this.field;
    }
}

