/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.declared.compiletime;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapContext;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapEnv;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapper;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNodeImpl;
import com.espertech.esper.common.internal.epl.script.core.ExprNodeScript;
import com.espertech.esper.common.internal.util.SerializerUtil;
import java.util.Collection;
import java.util.List;

public class ExprDeclaredHelper {
    public static Pair<ExprDeclaredNodeImpl, StatementSpecMapContext> getExistsDeclaredExpr(String name, List<ExprNode> parameters, Collection<ExpressionDeclItem> stmtLocalExpressions, ContextCompileTimeDescriptor contextCompileTimeDescriptor, StatementSpecMapEnv mapEnv) {
        ExpressionDeclItem found;
        if (!stmtLocalExpressions.isEmpty()) {
            for (ExpressionDeclItem declNode : stmtLocalExpressions) {
                if (!declNode.getName().equals(name)) continue;
                Pair<ExprNode, StatementSpecMapContext> pair = ExprDeclaredHelper.getExprDeclaredNode(declNode.getOptionalSoda(), stmtLocalExpressions, contextCompileTimeDescriptor, mapEnv);
                ExprDeclaredNodeImpl declared = new ExprDeclaredNodeImpl(declNode, parameters, contextCompileTimeDescriptor, pair.getFirst());
                return new Pair<ExprDeclaredNodeImpl, StatementSpecMapContext>(declared, pair.getSecond());
            }
        }
        if ((found = mapEnv.getExprDeclaredCompileTimeResolver().resolve(name)) != null) {
            Expression expression = found.getOptionalSoda();
            if (expression == null) {
                byte[] bytes = found.getOptionalSodaBytes().get();
                expression = (Expression)SerializerUtil.byteArrToObject(bytes);
            }
            Pair<ExprNode, StatementSpecMapContext> pair = ExprDeclaredHelper.getExprDeclaredNode(expression, stmtLocalExpressions, contextCompileTimeDescriptor, mapEnv);
            ExprDeclaredNodeImpl declared = new ExprDeclaredNodeImpl(found, parameters, contextCompileTimeDescriptor, pair.getFirst());
            return new Pair<ExprDeclaredNodeImpl, StatementSpecMapContext>(declared, pair.getSecond());
        }
        return null;
    }

    private static Pair<ExprNode, StatementSpecMapContext> getExprDeclaredNode(Expression expression, Collection<ExpressionDeclItem> stmtLocalExpressions, ContextCompileTimeDescriptor contextCompileTimeDescriptor, StatementSpecMapEnv mapEnv) {
        StatementSpecMapContext mapContext = new StatementSpecMapContext(contextCompileTimeDescriptor, mapEnv);
        for (ExpressionDeclItem item : stmtLocalExpressions) {
            mapContext.addExpressionDeclarations(item);
        }
        ExprNode body = StatementSpecMapper.mapExpression(expression, mapContext);
        return new Pair<ExprNode, StatementSpecMapContext>(body, mapContext);
    }

    public static ExprNodeScript getExistsScript(String defaultDialect, String expressionName, List<ExprNode> parameters, Collection<ExpressionScriptProvided> scriptExpressions, StatementSpecMapEnv mapEnv) {
        ExpressionScriptProvided script;
        if (!scriptExpressions.isEmpty() && (script = ExprDeclaredHelper.findScript(expressionName, parameters.size(), scriptExpressions)) != null) {
            return new ExprNodeScript(defaultDialect, script, parameters);
        }
        script = mapEnv.getScriptCompileTimeResolver().resolve(expressionName, parameters.size());
        if (script != null) {
            return new ExprNodeScript(defaultDialect, script, parameters);
        }
        return null;
    }

    private static ExpressionScriptProvided findScript(String name, int parameterCount, Collection<ExpressionScriptProvided> scriptsByName) {
        if (scriptsByName == null || scriptsByName.isEmpty()) {
            return null;
        }
        ExpressionScriptProvided nameMatchedScript = null;
        for (ExpressionScriptProvided script : scriptsByName) {
            if (script.getName().equals(name) && script.getParameterNames().length == parameterCount) {
                return script;
            }
            if (!script.getName().equals(name)) continue;
            nameMatchedScript = script;
        }
        return nameMatchedScript;
    }
}

