/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.declared.compiletime;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDeclaredOrLambdaNode;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeBase;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeConstant;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeNoRewrite;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredForgeRewrite;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentVisitorWParent;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.event.core.EventPropertyValueGetterForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExprDeclaredNodeImpl
extends ExprNodeBase
implements ExprDeclaredNode,
ExprDeclaredOrLambdaNode,
ExprFilterOptimizableNode,
ExprNodeInnerNodeProvider,
ExprConstantNode {
    private final ExpressionDeclItem prototypeWVisibility;
    private List<ExprNode> chainParameters;
    private transient ExprForge forge;
    private ExprNode expressionBodyCopy;
    private transient ExprValidationContext exprValidationContext;

    public ExprDeclaredNodeImpl(ExpressionDeclItem prototype, List<ExprNode> chainParameters, ContextCompileTimeDescriptor contextDescriptor, ExprNode expressionBodyCopy) {
        this.prototypeWVisibility = prototype;
        this.chainParameters = chainParameters;
        this.expressionBodyCopy = expressionBodyCopy;
        if (contextDescriptor == null) {
            return;
        }
        ExprNodeIdentVisitorWParent visitorWParent = new ExprNodeIdentVisitorWParent();
        expressionBodyCopy.accept(visitorWParent);
        for (Pair<ExprNode, ExprIdentNode> pair : visitorWParent.getIdentNodes()) {
            String streamOrProp = pair.getSecond().getStreamOrPropertyName();
            if (streamOrProp == null || !contextDescriptor.getContextPropertyRegistry().isContextPropertyPrefix(streamOrProp)) continue;
            ExprContextPropertyNodeImpl context = new ExprContextPropertyNodeImpl(pair.getSecond().getUnresolvedPropertyName());
            if (pair.getFirst() == null) {
                this.expressionBodyCopy = context;
                continue;
            }
            ExprNodeUtilityModify.replaceChildNode(pair.getFirst(), pair.getSecond(), context);
        }
    }

    @Override
    public ExprForge getForge() {
        ExprDeclaredNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode getBody() {
        return this.expressionBodyCopy;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return this.chainParameters;
    }

    @Override
    public boolean validated() {
        return this.forge != null;
    }

    @Override
    public Class getConstantType() {
        ExprDeclaredNodeImpl.checkValidated(this.forge);
        return this.forge.getEvaluationType();
    }

    @Override
    public Object getConstantValue() {
        return this.forge.getExprEvaluator().evaluate(null, true, null);
    }

    @Override
    public LinkedHashMap<String, Integer> getOuterStreamNames(Map<String, Integer> outerStreamNames) throws ExprValidationException {
        this.checkParameterCount();
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        LinkedHashMap<String, Integer> streamParameters = new LinkedHashMap<String, Integer>();
        for (int param = 0; param < this.chainParameters.size(); ++param) {
            if (!(this.chainParameters.get(param) instanceof ExprIdentNode)) {
                throw new ExprValidationException("Sub-selects in an expression declaration require passing only stream names as parameters");
            }
            String parameterName = ((ExprIdentNode)this.chainParameters.get(param)).getUnresolvedPropertyName();
            Integer streamIdFound = outerStreamNames.get(parameterName);
            if (streamIdFound == null) {
                throw new ExprValidationException("Failed validation of expression declaration '" + prototype.getName() + "': Invalid parameter to expression declaration, parameter " + param + " is not the name of a stream in the query");
            }
            String prototypeName = prototype.getParametersNames()[param];
            streamParameters.put(prototypeName, streamIdFound);
        }
        return streamParameters;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.exprValidationContext = validationContext;
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        if (prototype.isAlias()) {
            try {
                this.expressionBodyCopy = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.ALIASEXPRBODY, this.expressionBodyCopy, validationContext);
            }
            catch (ExprValidationException ex) {
                String message = "Error validating expression alias '" + prototype.getName() + "': " + ex.getMessage();
                throw new ExprValidationException(message, ex);
            }
            this.forge = this.expressionBodyCopy.getForge();
            return null;
        }
        if (this.forge != null) {
            return null;
        }
        if (this.getChildNodes().length > 0) {
            throw new IllegalStateException("Execution node has its own child nodes");
        }
        ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
        for (ExprNode expr : this.chainParameters) {
            validated.add(ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DECLAREDEXPRPARAM, expr, validationContext));
        }
        this.chainParameters = validated;
        this.checkParameterCount();
        EventType[] eventTypes = new EventType[prototype.getParametersNames().length];
        String[] streamNames = new String[prototype.getParametersNames().length];
        boolean[] isIStreamOnly = new boolean[prototype.getParametersNames().length];
        int[] streamsIdsPerStream = new int[prototype.getParametersNames().length];
        boolean allStreamIdsMatch = true;
        for (int i = 0; i < prototype.getParametersNames().length; ++i) {
            ExprNode parameter = this.chainParameters.get(i);
            streamNames[i] = prototype.getParametersNames()[i];
            if (parameter instanceof ExprStreamUnderlyingNode) {
                ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)parameter;
                eventTypes[i] = validationContext.getStreamTypeService().getEventTypes()[und.getStreamId()];
                isIStreamOnly[i] = validationContext.getStreamTypeService().getIStreamOnly()[und.getStreamId()];
                streamsIdsPerStream[i] = und.getStreamId();
            } else if (parameter instanceof ExprWildcard) {
                if (validationContext.getStreamTypeService().getEventTypes().length != 1) {
                    throw new ExprValidationException("Expression '" + prototype.getName() + "' only allows a wildcard parameter if there is a single stream available, please use a stream or tag name instead");
                }
                eventTypes[i] = validationContext.getStreamTypeService().getEventTypes()[0];
                isIStreamOnly[i] = validationContext.getStreamTypeService().getIStreamOnly()[0];
                streamsIdsPerStream[i] = 0;
            } else {
                throw new ExprValidationException("Expression '" + prototype.getName() + "' requires a stream name as a parameter");
            }
            if (streamsIdsPerStream[i] == i) continue;
            allStreamIdsMatch = false;
        }
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        StreamTypeServiceImpl copyTypes = new StreamTypeServiceImpl(eventTypes, streamNames, isIStreamOnly, streamTypeService.isOnDemandStreams(), streamTypeService.isOptionalStreams());
        copyTypes.setRequireStreamNames(true);
        try {
            ExprValidationContext expressionBodyContext = new ExprValidationContext(copyTypes, validationContext);
            this.expressionBodyCopy = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DECLAREDEXPRBODY, this.expressionBodyCopy, expressionBodyContext);
        }
        catch (ExprValidationException ex) {
            String message = "Error validating expression declaration '" + prototype.getName() + "': " + ex.getMessage();
            throw new ExprValidationException(message, ex);
        }
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        this.expressionBodyCopy.accept(summaryVisitor);
        boolean isCache = !summaryVisitor.isHasAggregation() && !summaryVisitor.isHasPreviousPrior();
        boolean audit = AuditEnum.EXPRDEF.getAudit(validationContext.getAnnotations()) != null;
        String statementName = validationContext.getStatementName();
        this.forge = this.expressionBodyCopy.getForge().getForgeConstantType().isConstant() ? new ExprDeclaredForgeConstant(this, this.expressionBodyCopy.getForge().getEvaluationType(), prototype, this.expressionBodyCopy.getForge().getExprEvaluator().evaluate(null, true, null), audit, statementName) : (prototype.getParametersNames().length == 0 || allStreamIdsMatch && prototype.getParametersNames().length == streamTypeService.getEventTypes().length ? new ExprDeclaredForgeNoRewrite(this, this.expressionBodyCopy.getForge(), isCache, audit, statementName) : new ExprDeclaredForgeRewrite(this, this.expressionBodyCopy.getForge(), isCache &= validationContext.getStatementCompileTimeService().getConfiguration().getCompiler().getExecution().isEnabledDeclaredExprValueCache(), streamsIdsPerStream, audit, statementName));
        return null;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return true;
    }

    @Override
    public ExprFilterSpecLookupableForge getFilterLookupable() {
        if (!(this.forge instanceof ExprDeclaredForgeBase)) {
            return null;
        }
        ExprDeclaredForgeBase declaredForge = (ExprDeclaredForgeBase)this.forge;
        ExprForge forge = declaredForge.getInnerForge();
        DataInputOutputSerdeForge serde = this.exprValidationContext.getSerdeResolver().serdeForFilter(forge.getEvaluationType(), this.exprValidationContext.getStatementRawInfo());
        return new ExprFilterSpecLookupableForge(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this), new DeclaredNodeEventPropertyGetterForge(forge), forge.getEvaluationType(), true, serde);
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprDeclaredNodeImpl)) {
            return false;
        }
        ExprDeclaredNodeImpl otherExprCaseNode = (ExprDeclaredNodeImpl)node;
        return ExprNodeUtilityCompare.deepEquals(this.expressionBodyCopy, otherExprCaseNode, false);
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        if (visitor.isVisit(this) && this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    public ExprNode getExpressionBodyCopy() {
        return this.expressionBodyCopy;
    }

    @Override
    public ExpressionDeclItem getPrototype() {
        return this.prototypeWVisibility;
    }

    public ExpressionDeclItem getPrototypeWVisibility() {
        return this.prototypeWVisibility;
    }

    @Override
    public List<ExprNode> getChainParameters() {
        return this.chainParameters;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprDeclaredNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    private void checkParameterCount() throws ExprValidationException {
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        if (this.chainParameters.size() != prototype.getParametersNames().length) {
            throw new ExprValidationException("Parameter count mismatches for declared expression '" + prototype.getName() + "', expected " + prototype.getParametersNames().length + " parameters but received " + this.chainParameters.size() + " parameters");
        }
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        ExpressionDeclItem prototype = this.prototypeWVisibility;
        writer.append(prototype.getName());
        if (prototype.isAlias()) {
            return;
        }
        writer.append("(");
        String delimiter = "";
        for (ExprNode parameter : this.chainParameters) {
            writer.append(delimiter);
            parameter.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.append(")");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    private static final class DeclaredNodeEventPropertyGetterForge
    implements EventPropertyValueGetterForge {
        private final ExprForge exprForge;

        public DeclaredNodeEventPropertyGetterForge(ExprForge exprForge) {
            this.exprForge = exprForge;
        }

        @Override
        public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
            CodegenMethod method = parent.makeChild(this.exprForge.getEvaluationType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(EventBean.class, "bean");
            CodegenMethod exprMethod = CodegenLegoMethodExpression.codegenExpression(this.exprForge, method, codegenClassScope);
            method.getBlock().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.newArrayByLength(EventBean.class, CodegenExpressionBuilder.constant(1))).assignArrayElement(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("bean")).methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull()));
            return CodegenExpressionBuilder.localMethod(method, beanExpression);
        }
    }
}

