/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitor;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuckEvalPlain;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuckEvalUnderlying;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuckEvalWrapArray;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import java.lang.reflect.Method;

public class ExprDotMethodForgeNoDuck
implements ExprDotForge {
    private final String optionalStatementName;
    private final Method method;
    private final ExprForge[] parameters;
    private final Type type;

    public ExprDotMethodForgeNoDuck(String optionalStatementName, Method method, ExprForge[] parameters, Type type) {
        this.optionalStatementName = optionalStatementName;
        this.method = method;
        this.parameters = parameters;
        this.type = type;
    }

    @Override
    public EPType getTypeInfo() {
        if (this.type == Type.WRAPARRAY) {
            return EPTypeHelper.collectionOfSingleValue(this.method.getReturnType().getComponentType());
        }
        return EPTypeHelper.fromMethod(this.method);
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitMethod(this.method.getName());
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.parameters);
        if (this.type == Type.WRAPARRAY) {
            return new ExprDotMethodForgeNoDuckEvalWrapArray(this, evaluators);
        }
        if (this.type == Type.PLAIN) {
            return new ExprDotMethodForgeNoDuckEvalPlain(this, evaluators);
        }
        return new ExprDotMethodForgeNoDuckEvalUnderlying(this, evaluators);
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, Class innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.type == Type.WRAPARRAY) {
            return ExprDotMethodForgeNoDuckEvalWrapArray.codegenWrapArray(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
        }
        if (this.type == Type.PLAIN) {
            return ExprDotMethodForgeNoDuckEvalPlain.codegenPlain(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
        }
        return ExprDotMethodForgeNoDuckEvalUnderlying.codegenUnderlying(this, inner, innerType, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    public String getOptionalStatementName() {
        return this.optionalStatementName;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExprForge[] getParameters() {
        return this.parameters;
    }

    public static enum Type {
        WRAPARRAY,
        UNDERLYING,
        PLAIN;

    }
}

