/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.codegen.StaticMethodCallHelper;
import com.espertech.esper.common.internal.epl.expression.codegen.StaticMethodCodegenArgDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStaticMethod;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import com.espertech.esper.common.internal.rettype.ClassEPType;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeCodegenSharable;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprDotNodeForgeStaticMethodEval
implements ExprEvaluator,
EventPropertyGetter {
    private static final Logger log = LoggerFactory.getLogger(ExprDotNodeForgeStaticMethodEval.class);
    public static final String METHOD_STATICMETHODEVALHANDLEINVOCATIONEXCEPTION = "staticMethodEvalHandleInvocationException";
    private final ExprDotNodeForgeStaticMethod forge;
    private final ExprEvaluator[] childEvals;
    private final ExprDotEval[] chainEval;

    public ExprDotNodeForgeStaticMethodEval(ExprDotNodeForgeStaticMethod forge, ExprEvaluator[] childEvals, ExprDotEval[] chainEval) {
        this.forge = forge;
        this.childEvals = childEvals;
        this.chainEval = chainEval;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] args = new Object[this.childEvals.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.childEvals[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            Object result = this.forge.getStaticMethod().invoke(this.forge.getTargetObject(), args);
            result = ExprDotNodeUtility.evaluateChainWithWrap(this.forge.getResultWrapLambda(), result, null, this.forge.getStaticMethod().getReturnType(), this.chainEval, this.forge.getChainForges(), eventsPerStream, isNewData, exprEvaluatorContext);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExprDotNodeForgeStaticMethodEval.staticMethodEvalHandleInvocationException(null, this.forge.getStaticMethod().getName(), this.forge.getStaticMethod().getParameterTypes(), this.forge.getClassOrPropertyName(), args, e, this.forge.isRethrowExceptions());
            return null;
        }
    }

    public static CodegenExpression codegenExprEval(ExprDotNodeForgeStaticMethod forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField isCachedMember = null;
        CodegenExpressionField cachedResultMember = null;
        if (forge.isConstantParameters()) {
            isCachedMember = codegenClassScope.addFieldUnshared(false, Boolean.TYPE, CodegenExpressionBuilder.constantFalse());
            cachedResultMember = codegenClassScope.addFieldUnshared(false, Object.class, CodegenExpressionBuilder.constantNull());
        }
        Class<?> returnType = forge.getStaticMethod().getReturnType();
        CodegenMethod methodNode = codegenMethodScope.makeChild(forge.getEvaluationType(), ExprDotNodeForgeStaticMethodEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock();
        if (forge.isConstantParameters()) {
            CodegenBlock ifCached = block.ifCondition(isCachedMember);
            if (returnType == Void.TYPE) {
                ifCached.blockReturnNoValue();
            } else {
                ifCached.blockReturn(CodegenExpressionBuilder.cast(forge.getEvaluationType(), (CodegenExpression)cachedResultMember));
            }
        }
        StaticMethodCodegenArgDesc[] args = StaticMethodCallHelper.allArgumentExpressions(forge.getChildForges(), forge.getStaticMethod(), methodNode, exprSymbol, codegenClassScope);
        StaticMethodCallHelper.appendArgExpressions(args, methodNode.getBlock());
        CodegenBlock tryBlock = block.tryCatch();
        CodegenExpression invoke = StaticMethodCallHelper.codegenInvokeExpression(forge.getTargetObject(), forge.getStaticMethod(), args, codegenClassScope);
        if (returnType == Void.TYPE) {
            tryBlock.expression(invoke);
            if (forge.isConstantParameters()) {
                tryBlock.assignRef(isCachedMember, CodegenExpressionBuilder.constantTrue());
            }
            tryBlock.blockReturnNoValue();
        } else {
            tryBlock.declareVar(returnType, "result", invoke);
            if (forge.getChainForges().length == 0) {
                CodegenExpression typeInformation = CodegenExpressionBuilder.constantNull();
                if (codegenClassScope.isInstrumented()) {
                    typeInformation = codegenClassScope.addOrGetFieldSharable(new EPTypeCodegenSharable(new ClassEPType(forge.getEvaluationType()), codegenClassScope));
                }
                tryBlock.apply(InstrumentationCode.instblock(codegenClassScope, "qExprDotChain", typeInformation, CodegenExpressionBuilder.ref("result"), CodegenExpressionBuilder.constant(0)));
                if (forge.isConstantParameters()) {
                    tryBlock.assignRef(cachedResultMember, (CodegenExpression)CodegenExpressionBuilder.ref("result"));
                    tryBlock.assignRef(isCachedMember, CodegenExpressionBuilder.constantTrue());
                }
                tryBlock.apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChain", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.ref("result"));
            } else {
                EPType typeInfo = forge.getResultWrapLambda() != null ? forge.getResultWrapLambda().getTypeInfo() : new ClassEPType(Object.class);
                CodegenExpression typeInformation = CodegenExpressionBuilder.constantNull();
                if (codegenClassScope.isInstrumented()) {
                    typeInformation = codegenClassScope.addOrGetFieldSharable(new EPTypeCodegenSharable(typeInfo, codegenClassScope));
                }
                tryBlock.apply(InstrumentationCode.instblock(codegenClassScope, "qExprDotChain", typeInformation, CodegenExpressionBuilder.ref("result"), CodegenExpressionBuilder.constant(forge.getChainForges().length))).declareVar(forge.getEvaluationType(), "chain", ExprDotNodeUtility.evaluateChainCodegen(methodNode, exprSymbol, codegenClassScope, CodegenExpressionBuilder.ref("result"), returnType, forge.getChainForges(), forge.getResultWrapLambda()));
                if (forge.isConstantParameters()) {
                    tryBlock.assignRef(cachedResultMember, (CodegenExpression)CodegenExpressionBuilder.ref("chain"));
                    tryBlock.assignRef(isCachedMember, CodegenExpressionBuilder.constantTrue());
                }
                tryBlock.apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChain", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.ref("chain"));
            }
        }
        StaticMethodCallHelper.appendCatch(tryBlock, forge.getStaticMethod(), forge.getOptionalStatementName(), forge.getClassOrPropertyName(), forge.isRethrowExceptions(), args);
        if (returnType == Void.TYPE) {
            block.methodEnd();
        } else {
            block.methodReturn(CodegenExpressionBuilder.constantNull());
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] args = new Object[this.childEvals.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.childEvals[i].evaluate(new EventBean[]{eventBean}, true, null);
        }
        try {
            return this.forge.getStaticMethod().invoke(this.forge.getTargetObject(), args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExprDotNodeForgeStaticMethodEval.staticMethodEvalHandleInvocationException(this.forge.getOptionalStatementName(), this.forge.getStaticMethod().getName(), this.forge.getStaticMethod().getParameterTypes(), this.forge.getClassOrPropertyName(), args, e, this.forge.isRethrowExceptions());
            return null;
        }
    }

    public static CodegenExpression codegenGet(CodegenExpression beanExpression, ExprDotNodeForgeStaticMethod forge, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod methodNode = codegenMethodScope.makeChildWithScope(forge.getEvaluationType(), ExprDotNodeForgeStaticMethodEval.class, exprSymbol, codegenClassScope).addParam(ExprForgeCodegenNames.PARAMS);
        StaticMethodCodegenArgDesc[] args = StaticMethodCallHelper.allArgumentExpressions(forge.getChildForges(), forge.getStaticMethod(), methodNode, exprSymbol, codegenClassScope);
        exprSymbol.derivedSymbolsCodegen(methodNode, methodNode.getBlock(), codegenClassScope);
        StaticMethodCallHelper.appendArgExpressions(args, methodNode.getBlock());
        CodegenBlock tryBlock = methodNode.getBlock().tryCatch();
        CodegenExpression invoke = StaticMethodCallHelper.codegenInvokeExpression(forge.getTargetObject(), forge.getStaticMethod(), args, codegenClassScope);
        tryBlock.blockReturn(invoke);
        StaticMethodCallHelper.appendCatch(tryBlock, forge.getStaticMethod(), forge.getOptionalStatementName(), forge.getClassOrPropertyName(), forge.isRethrowExceptions(), args);
        methodNode.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        return CodegenExpressionBuilder.localMethod(methodNode, CodegenExpressionBuilder.newArrayWithInit(EventBean.class, beanExpression), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull());
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }

    public static void staticMethodEvalHandleInvocationException(String optionalStatementName, String methodName, Class[] parameterTypes, String classOrPropertyName, Object[] args, Throwable thrown, boolean rethrow) {
        Throwable indication = thrown instanceof InvocationTargetException ? ((InvocationTargetException)thrown).getTargetException() : thrown;
        String message = JavaClassHelper.getMessageInvocationTarget(optionalStatementName, methodName, parameterTypes, classOrPropertyName, args, indication);
        log.error(message, indication);
        if (rethrow) {
            throw new EPException(message, indication);
        }
    }
}

