/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import com.espertech.esper.common.internal.rettype.EPTypeCodegenSharable;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;

public class ExprDotNodeForgeStreamEvalMethod
implements ExprEvaluator {
    private final ExprDotNodeForgeStream forge;
    private final ExprDotEval[] evaluators;

    public ExprDotNodeForgeStreamEvalMethod(ExprDotNodeForgeStream forge, ExprDotEval[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.forge.getStreamNumber()];
        if (event == null) {
            return null;
        }
        Object inner = event.getUnderlying();
        inner = ExprDotNodeUtility.evaluateChain(this.forge.getEvaluators(), this.evaluators, inner, eventsPerStream, isNewData, exprEvaluatorContext);
        return inner;
    }

    public static CodegenExpression codegen(ExprDotNodeForgeStream forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class evaluationType = forge.getEvaluationType();
        Class eventUndType = forge.getEventType().getUnderlyingType();
        CodegenMethod methodNode = codegenMethodScope.makeChild(evaluationType, ExprDotNodeForgeStreamEvalMethod.class, (CodegenScope)codegenClassScope);
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
        CodegenBlock block = methodNode.getBlock().apply(InstrumentationCode.instblock(codegenClassScope, "qExprStreamUndMethod", CodegenExpressionBuilder.constant(ExprNodeUtilityPrint.toExpressionStringMinPrecedence(forge)))).declareVar(EventBean.class, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(forge.getStreamNumber())));
        if (evaluationType == Void.TYPE) {
            block.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("event"))).apply(InstrumentationCode.instblock(codegenClassScope, "aExprStreamUndMethod", CodegenExpressionBuilder.constantNull())).blockReturnNoValue();
        } else {
            block.ifRefNull("event").apply(InstrumentationCode.instblock(codegenClassScope, "aExprStreamUndMethod", CodegenExpressionBuilder.constantNull())).blockReturn(CodegenExpressionBuilder.constantNull());
        }
        CodegenExpression typeInformation = CodegenExpressionBuilder.constantNull();
        if (codegenClassScope.isInstrumented()) {
            typeInformation = codegenClassScope.addOrGetFieldSharable(new EPTypeCodegenSharable(EPTypeHelper.singleValue(forge.getEventType().getUnderlyingType()), codegenClassScope));
        }
        block.declareVar(eventUndType, "inner", CodegenExpressionBuilder.cast(eventUndType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("event"), "getUnderlying", new CodegenExpression[0]))).apply(InstrumentationCode.instblock(codegenClassScope, "qExprDotChain", typeInformation, CodegenExpressionBuilder.ref("inner"), CodegenExpressionBuilder.constant(forge.getEvaluators().length)));
        CodegenExpression invoke = ExprDotNodeUtility.evaluateChainCodegen(methodNode, exprSymbol, codegenClassScope, CodegenExpressionBuilder.ref("inner"), eventUndType, forge.getEvaluators(), null);
        if (evaluationType == Void.TYPE) {
            block.expression(invoke).apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChain", new CodegenExpression[0])).apply(InstrumentationCode.instblock(codegenClassScope, "aExprStreamUndMethod", CodegenExpressionBuilder.constantNull())).methodEnd();
        } else {
            block.declareVar(evaluationType, "result", invoke).apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChain", new CodegenExpression[0])).apply(InstrumentationCode.instblock(codegenClassScope, "aExprStreamUndMethod", CodegenExpressionBuilder.ref("result"))).methodReturn(CodegenExpressionBuilder.ref("result"));
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

