/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapArrayScalar;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotNonLambdaFragmentForge;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityResolve;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationPropertyException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprAppDotMethodImpl;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForgeForProps;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeLocal;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeTableAccess;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodForgeTableIdent;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeAggregationMethodRootNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputExpr;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgePropertyExpr;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeRootChild;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStaticMethod;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeTransposeAsStream;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeVariable;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeRealizedChain;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.epl.expression.dot.propertydot.PropertyDotNonLambdaIndexedForge;
import com.espertech.esper.common.internal.epl.expression.dot.propertydot.PropertyDotNonLambdaMappedForge;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeSubprop;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodBase;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodPointInsideRectange;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodRectangeIntersectsRectangle;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeUtil;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnAggregation;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterIndexedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterMappedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParserNoDep;
import com.espertech.esper.common.internal.rettype.ClassEPType;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import com.espertech.esper.common.internal.settings.ClasspathImportCompileTimeUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExprDotNodeImpl
extends ExprNodeBase
implements ExprDotNode,
ExprStreamRefNode,
ExprNodeInnerNodeProvider {
    private final List<ExprChainedSpec> chainSpec;
    private final boolean isDuckTyping;
    private final boolean isUDFCache;
    private transient ExprDotNodeForge forge;

    public ExprDotNodeImpl(List<ExprChainedSpec> chainSpec, boolean isDuckTyping, boolean isUDFCache) {
        this.chainSpec = new ArrayList<ExprChainedSpec>(chainSpec);
        this.isDuckTyping = isDuckTyping;
        this.isUDFCache = isUDFCache;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtilMethodDesc method;
        Pair<ExprDotNodeAggregationMethodRootNode, List<ExprChainedSpec>> aggregationMethodNode;
        Pair<ExprNode, List<ExprChainedSpec>> tableNode;
        ExprAppDotMethodImpl appDotMethod = this.getAppDotMethod(validationContext.isFilterExpression());
        if (appDotMethod != null) {
            return appDotMethod;
        }
        if (validationContext.getStreamTypeService().hasTableTypes() && validationContext.getTableCompileTimeResolver() != null && this.chainSpec.size() > 1 && this.chainSpec.get(0).isProperty() && (tableNode = TableCompileTimeUtil.getTableNodeChainable(validationContext.getStreamTypeService(), this.chainSpec, validationContext.getClasspathImportService(), validationContext.getTableCompileTimeResolver())) != null) {
            ExprNode node = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DOTNODE, tableNode.getFirst(), validationContext);
            if (tableNode.getSecond().isEmpty()) {
                return node;
            }
            this.chainSpec.clear();
            this.chainSpec.addAll((Collection<ExprChainedSpec>)tableNode.getSecond());
            this.addChildNode(node);
        }
        if ((aggregationMethodNode = this.handleAggregationMethod(validationContext)) != null) {
            if (aggregationMethodNode.getSecond().isEmpty()) {
                return aggregationMethodNode.getFirst();
            }
            this.chainSpec.clear();
            this.chainSpec.addAll((Collection<ExprChainedSpec>)aggregationMethodNode.getSecond());
            this.getChildNodes()[0] = aggregationMethodNode.getFirst();
        }
        ExprNodeUtilityValidate.validate(ExprNodeOrigin.DOTNODEPARAMETER, this.chainSpec, validationContext);
        boolean hasEnumerationMethod = false;
        for (ExprChainedSpec chain : this.chainSpec) {
            if (!EnumMethodEnum.isEnumerationMethod(chain.getName())) continue;
            hasEnumerationMethod = true;
            break;
        }
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        if (this.getChildNodes().length != 0) {
            ExprNode rootNode = this.getChildNodes()[0];
            ExprDotEnumerationSourceForge enumSrc = ExprDotNodeUtility.getEnumerationSource(rootNode, validationContext.getStreamTypeService(), hasEnumerationMethod, validationContext.isDisablePropertyExpressionEventCollCache(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
            EPType typeInfo = enumSrc.getReturnType() == null ? EPTypeHelper.singleValue(rootNode.getForge().getEvaluationType()) : enumSrc.getReturnType();
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(enumSrc.getStreamOfProviderIfApplicable(), typeInfo, this.chainSpec, validationContext, this.isDuckTyping, new ExprDotNodeFilterAnalyzerInputExpr());
            this.forge = new ExprDotNodeForgeRootChild(this, null, null, null, hasEnumerationMethod, rootNode.getForge(), enumSrc.getEnumeration(), typeInfo, evals.getChain(), evals.getChainWithUnpack(), false);
            return null;
        }
        if (this.chainSpec.size() == 1) {
            ExprChainedSpec spec = this.chainSpec.get(0);
            if (spec.getParameters().isEmpty()) {
                throw this.handleNotFound(spec.getName());
            }
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, spec.getName(), streamTypeService.hasPropertyAgnosticType(), false, validationContext.getTableCompileTimeResolver());
            }
            catch (ExprValidationPropertyException typeInfo) {
                // empty catch block
            }
            if (propertyInfoPair == null && spec.getName().toLowerCase(Locale.ENGLISH).equals("transpose")) {
                if (spec.getParameters().size() != 1) {
                    throw new ExprValidationException("The transpose function requires a single parameter expression");
                }
                this.forge = new ExprDotNodeForgeTransposeAsStream(this, this.chainSpec.get(0).getParameters().get(0).getForge());
            } else {
                if (spec.getParameters().size() != 1) {
                    throw this.handleNotFound(spec.getName());
                }
                if (propertyInfoPair == null) {
                    throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + spec.getName() + "' could not be resolved");
                }
                this.forge = this.getPropertyPairEvaluator(spec.getParameters().get(0).getForge(), propertyInfoPair, validationContext);
            }
            return null;
        }
        ExprValidationException prefixedStreamNumException = null;
        int prefixedStreamNumber = this.prefixedStreamName(this.chainSpec, validationContext.getStreamTypeService());
        if (prefixedStreamNumber != -1) {
            ExprChainedSpec specAfterStreamName = this.chainSpec.get(1);
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                String propName = this.chainSpec.get(0).getName() + "." + specAfterStreamName.getName();
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, propName, streamTypeService.hasPropertyAgnosticType(), false, validationContext.getTableCompileTimeResolver());
            }
            catch (ExprValidationPropertyException propName) {
                // empty catch block
            }
            if (propertyInfoPair != null) {
                if (specAfterStreamName.getParameters().size() != 1) {
                    throw this.handleNotFound(specAfterStreamName.getName());
                }
                this.forge = this.getPropertyPairEvaluator(specAfterStreamName.getParameters().get(0).getForge(), propertyInfoPair, validationContext);
                return null;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[prefixedStreamNumber];
            Class type = eventType.getUnderlyingType();
            ArrayList<ExprChainedSpec> remainderChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
            remainderChain.remove(0);
            ExprValidationException methodEx = null;
            ExprDotForge[] underlyingMethodChain = null;
            try {
                EPType typeInfo = EPTypeHelper.singleValue(type);
                if (validationContext.getTableCompileTimeResolver().resolveTableFromEventType(eventType) != null) {
                    typeInfo = new ClassEPType(Object[].class);
                }
                underlyingMethodChain = ExprDotNodeUtility.getChainEvaluators(prefixedStreamNumber, typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber)).getChainWithUnpack();
            }
            catch (ExprValidationException ex) {
                methodEx = ex;
            }
            ExprDotForge[] eventTypeMethodChain = null;
            ExprValidationException enumDatetimeEx = null;
            FilterExprAnalyzerAffector filterExprAnalyzerAffector = null;
            try {
                EPType typeInfo = EPTypeHelper.singleEvent(eventType);
                ExprDotNodeRealizedChain chain = ExprDotNodeUtility.getChainEvaluators(prefixedStreamNumber, typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber));
                eventTypeMethodChain = chain.getChainWithUnpack();
                filterExprAnalyzerAffector = chain.getFilterAnalyzerDesc();
            }
            catch (ExprValidationException ex) {
                enumDatetimeEx = ex;
            }
            if (underlyingMethodChain != null) {
                this.forge = new ExprDotNodeForgeStream(this, filterExprAnalyzerAffector, prefixedStreamNumber, eventType, underlyingMethodChain, true);
            } else if (eventTypeMethodChain != null) {
                this.forge = new ExprDotNodeForgeStream(this, filterExprAnalyzerAffector, prefixedStreamNumber, eventType, eventTypeMethodChain, false);
            }
            if (this.forge != null) {
                return null;
            }
            prefixedStreamNumException = ExprDotNodeUtility.isDatetimeOrEnumMethod(((ExprChainedSpec)remainderChain.get(0)).getName()) ? enumDatetimeEx : new ExprValidationException("Failed to solve '" + ((ExprChainedSpec)remainderChain.get(0)).getName() + "' to either an date-time or enumeration method, an event property or a method on the event underlying object: " + methodEx.getMessage(), methodEx);
        }
        ArrayList<ExprChainedSpec> modifiedChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
        ExprChainedSpec firstItem = (ExprChainedSpec)modifiedChain.remove(0);
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
        try {
            propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, firstItem.getName(), streamTypeService.hasPropertyAgnosticType(), true, validationContext.getTableCompileTimeResolver());
        }
        catch (ExprValidationPropertyException type) {
            // empty catch block
        }
        if (propertyInfoPair != null) {
            ExprDotNodeRealizedChain evals;
            EPType inputType;
            EPType typeInfo;
            EventPropertyGetterSPI getter;
            String propertyName = ((PropertyResolutionDescriptor)propertyInfoPair.getFirst()).getPropertyName();
            int streamId = propertyInfoPair.getFirst().getStreamNum();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            ExprEnumerationForge enumerationForge = null;
            ExprForge rootNodeForge = null;
            if (firstItem.getParameters().isEmpty()) {
                getter = ((EventTypeSPI)streamType).getGetterSPI(propertyInfoPair.getFirst().getPropertyName());
                ExprDotEnumerationSourceForgeForProps propertyEval = ExprDotNodeUtility.getPropertyEnumerationSource(propertyInfoPair.getFirst().getPropertyName(), streamId, streamType, hasEnumerationMethod, validationContext.isDisablePropertyExpressionEventCollCache());
                typeInfo = propertyEval.getReturnType();
                enumerationForge = propertyEval.getEnumeration();
                inputType = propertyEval.getReturnType();
                rootNodeForge = new PropertyDotNonLambdaForge(streamId, getter, JavaClassHelper.getBoxedType(propertyInfoPair.getFirst().getPropertyType()));
            } else {
                EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamTypeService.getEventTypes()[propertyInfoPair.getFirst().getStreamNum()], firstItem.getName());
                if (firstItem.getParameters().size() > 1) {
                    throw new ExprValidationException("Property '" + firstItem.getName() + "' may not be accessed passing 2 or more parameters");
                }
                ExprForge paramEval = firstItem.getParameters().get(0).getForge();
                inputType = typeInfo = EPTypeHelper.singleValue(desc.getPropertyComponentType());
                getter = null;
                if (desc.isMapped()) {
                    if (paramEval.getEvaluationType() != String.class) {
                        throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(paramEval.getEvaluationType()));
                    }
                    EventPropertyGetterMappedSPI mappedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterMappedSPI(propertyInfoPair.getFirst().getPropertyName());
                    if (mappedGetter == null) {
                        throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                    }
                    rootNodeForge = new PropertyDotNonLambdaMappedForge(streamId, mappedGetter, paramEval, desc.getPropertyComponentType());
                }
                if (desc.isIndexed()) {
                    if (JavaClassHelper.getBoxedType(paramEval.getEvaluationType()) != Integer.class) {
                        throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(paramEval.getEvaluationType()));
                    }
                    EventPropertyGetterIndexedSPI indexedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterIndexedSPI(propertyInfoPair.getFirst().getPropertyName());
                    if (indexedGetter == null) {
                        throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                    }
                    rootNodeForge = new PropertyDotNonLambdaIndexedForge(streamId, indexedGetter, paramEval, desc.getPropertyComponentType());
                }
            }
            if (typeInfo == null) {
                throw new ExprValidationException("Property '" + propertyName + "' is not a mapped or indexed property");
            }
            ExprDotNodeFilterAnalyzerInputProp filterAnalyzerInputProp = new ExprDotNodeFilterAnalyzerInputProp(propertyInfoPair.getFirst().getStreamNum(), propertyInfoPair.getFirst().getPropertyName());
            boolean rootIsEventBean = false;
            try {
                evals = ExprDotNodeUtility.getChainEvaluators(streamId, inputType, modifiedChain, validationContext, this.isDuckTyping, filterAnalyzerInputProp);
            }
            catch (ExprValidationException ex) {
                FragmentEventType fragment = propertyInfoPair.getFirst().getFragmentEventType();
                if (fragment == null) {
                    throw ex;
                }
                EPType fragmentTypeInfo = fragment.isIndexed() ? EPTypeHelper.collectionOfEvents(fragment.getFragmentType()) : EPTypeHelper.singleEvent(fragment.getFragmentType());
                rootIsEventBean = true;
                evals = ExprDotNodeUtility.getChainEvaluators(propertyInfoPair.getFirst().getStreamNum(), fragmentTypeInfo, modifiedChain, validationContext, this.isDuckTyping, filterAnalyzerInputProp);
                rootNodeForge = new PropertyDotNonLambdaFragmentForge(streamId, getter);
            }
            FilterExprAnalyzerAffector filterExprAnalyzerAffector = evals.getFilterAnalyzerDesc();
            int streamNumReferenced = propertyInfoPair.getFirst().getStreamNum();
            String rootPropertyName = propertyInfoPair.getFirst().getPropertyName();
            this.forge = new ExprDotNodeForgeRootChild(this, filterExprAnalyzerAffector, streamNumReferenced, rootPropertyName, hasEnumerationMethod, rootNodeForge, enumerationForge, inputType, evals.getChain(), evals.getChainWithUnpack(), !rootIsEventBean);
            return null;
        }
        VariableMetaData variable = validationContext.getVariableCompileTimeResolver().resolve(firstItem.getName());
        if (variable != null) {
            ExprDotStaticMethodWrapArrayScalar wrap;
            EPType typeInfo;
            if (variable.getOptionalContextName() != null) {
                throw new ExprValidationException("Method invocation on context-specific variable is not supported");
            }
            if (variable.getType().isArray()) {
                typeInfo = EPTypeHelper.collectionOfSingleValue(variable.getType().getComponentType());
                wrap = new ExprDotStaticMethodWrapArrayScalar(variable.getVariableName(), variable.getType());
            } else if (variable.getEventType() != null) {
                typeInfo = EPTypeHelper.singleEvent(variable.getEventType());
                wrap = null;
            } else {
                typeInfo = EPTypeHelper.singleValue(variable.getType());
                wrap = null;
            }
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.forge = new ExprDotNodeForgeVariable(this, variable, wrap, evals.getChainWithUnpack());
            return null;
        }
        Object enumconstant = ClasspathImportCompileTimeUtil.resolveIdentAsEnumConst(firstItem.getName(), validationContext.getClasspathImportService(), false);
        if (enumconstant != null) {
            final ExprChainedSpec methodSpec = (ExprChainedSpec)modifiedChain.get(0);
            final String enumvalue = firstItem.getName();
            ExprNodeUtilResolveExceptionHandler handler = new ExprNodeUtilResolveExceptionHandler(){

                @Override
                public ExprValidationException handle(Exception ex) {
                    return new ExprValidationException("Failed to resolve method '" + methodSpec.getName() + "' on enumeration value '" + enumvalue + "': " + ex.getMessage());
                }
            };
            EventType wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
            ExprNodeUtilMethodDesc methodDesc = ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(enumconstant.getClass().getName(), enumconstant.getClass(), methodSpec.getName(), methodSpec.getParameters(), wildcardType != null, wildcardType, handler, methodSpec.getName(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
            modifiedChain.remove(0);
            ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(methodDesc.getReflectionMethod(), modifiedChain, null, validationContext);
            EPType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPTypeHelper.singleValue(methodDesc.getReflectionMethod().getReturnType());
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.forge = new ExprDotNodeForgeStaticMethod(this, false, firstItem.getName(), methodDesc.getReflectionMethod(), methodDesc.getChildForges(), false, evals.getChainWithUnpack(), optionalLambdaWrap, false, enumconstant, validationContext.getStatementName());
            return null;
        }
        if (prefixedStreamNumException != null) {
            throw prefixedStreamNumException;
        }
        ExprChainedSpec secondItem = (ExprChainedSpec)modifiedChain.remove(0);
        boolean allowWildcard = validationContext.getStreamTypeService().getEventTypes().length == 1;
        EventType streamZeroType = null;
        if (validationContext.getStreamTypeService().getEventTypes().length > 0) {
            streamZeroType = validationContext.getStreamTypeService().getEventTypes()[0];
        }
        boolean isConstantParameters = (method = ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(firstItem.getName(), null, secondItem.getName(), secondItem.getParameters(), allowWildcard, streamZeroType, new ExprNodeUtilResolveExceptionHandlerDefault(firstItem.getName() + "." + secondItem.getName(), false), secondItem.getName(), validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService())).isAllConstants() && this.isUDFCache;
        boolean isReturnsConstantResult = isConstantParameters && modifiedChain.isEmpty();
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(method.getReflectionMethod(), modifiedChain, null, validationContext);
        EPType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPTypeHelper.singleValue(method.getReflectionMethod().getReturnType());
        ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
        this.forge = new ExprDotNodeForgeStaticMethod(this, isReturnsConstantResult, firstItem.getName(), method.getReflectionMethod(), method.getChildForges(), isConstantParameters, evals.getChainWithUnpack(), optionalLambdaWrap, false, null, validationContext.getStatementName());
        return null;
    }

    private Pair<ExprDotNodeAggregationMethodRootNode, List<ExprChainedSpec>> handleAggregationMethod(ExprValidationContext validationContext) throws ExprValidationException {
        TableMetadataColumn column;
        ExprNodeBase tableSubprop;
        ExprDotNodeAggregationMethodForge aggregationMethodForge;
        Property prop;
        if (this.chainSpec.isEmpty() || this.getChildNodes().length == 0) {
            return null;
        }
        ExprNode rootNode = this.getChildNodes()[0];
        ExprChainedSpec chainFirst = this.chainSpec.get(0);
        ExprNode[] aggMethodParams = chainFirst.getParameters().toArray(new ExprNode[0]);
        String aggMethodName = chainFirst.getName();
        if (chainFirst.isProperty() && (prop = PropertyParserNoDep.parseAndWalkLaxToSimple(chainFirst.getName(), false)) instanceof MappedProperty) {
            MappedProperty mappedProperty = (MappedProperty)prop;
            aggMethodName = mappedProperty.getPropertyNameAtomic();
            aggMethodParams = new ExprNode[]{new ExprConstantNodeImpl(mappedProperty.getKey())};
        }
        if (!(rootNode instanceof ExprTableAccessNodeSubprop || rootNode instanceof ExprAggMultiFunctionNode || rootNode instanceof ExprTableIdentNode)) {
            return null;
        }
        if (rootNode instanceof ExprAggMultiFunctionNode) {
            ExprAggMultiFunctionNode mf = (ExprAggMultiFunctionNode)rootNode;
            if (!mf.getAggregationForgeFactory().getAggregationPortableValidation().isAggregationMethod(aggMethodName, aggMethodParams, validationContext)) {
                return null;
            }
            aggregationMethodForge = new ExprDotNodeAggregationMethodForgeLocal(this, aggMethodName, aggMethodParams, mf.getAggregationForgeFactory().getAggregationPortableValidation(), mf);
        } else if (rootNode instanceof ExprTableIdentNode) {
            tableSubprop = (ExprTableIdentNode)rootNode;
            column = ((ExprTableIdentNode)tableSubprop).getTableMetadata().getColumns().get(((ExprTableIdentNode)tableSubprop).getColumnName());
            if (!(column instanceof TableMetadataColumnAggregation)) {
                return null;
            }
            TableMetadataColumnAggregation columnAggregation = (TableMetadataColumnAggregation)column;
            if (columnAggregation.isMethodAgg() || !columnAggregation.getAggregationPortableValidation().isAggregationMethod(aggMethodName, aggMethodParams, validationContext)) {
                return null;
            }
            aggregationMethodForge = new ExprDotNodeAggregationMethodForgeTableIdent(this, aggMethodName, aggMethodParams, columnAggregation.getAggregationPortableValidation(), (ExprTableIdentNode)tableSubprop, columnAggregation);
        } else if (rootNode instanceof ExprTableAccessNodeSubprop) {
            tableSubprop = (ExprTableAccessNodeSubprop)rootNode;
            column = ((ExprTableAccessNode)tableSubprop).getTableMeta().getColumns().get(((ExprTableAccessNodeSubprop)tableSubprop).getSubpropName());
            if (!(column instanceof TableMetadataColumnAggregation)) {
                return null;
            }
            TableMetadataColumnAggregation columnAggregation = (TableMetadataColumnAggregation)column;
            if (columnAggregation.isMethodAgg() || !columnAggregation.getAggregationPortableValidation().isAggregationMethod(aggMethodName, aggMethodParams, validationContext)) {
                return null;
            }
            aggregationMethodForge = new ExprDotNodeAggregationMethodForgeTableAccess(this, aggMethodName, aggMethodParams, columnAggregation.getAggregationPortableValidation(), (ExprTableAccessNodeSubprop)tableSubprop, columnAggregation);
        } else {
            throw new IllegalStateException("Unhandled aggregation method root node");
        }
        aggregationMethodForge.validate(validationContext);
        ArrayList<ExprChainedSpec> newChain = this.chainSpec.size() == 1 ? Collections.emptyList() : new ArrayList<ExprChainedSpec>(this.chainSpec.subList(1, this.chainSpec.size()));
        ExprDotNodeAggregationMethodRootNode root = new ExprDotNodeAggregationMethodRootNode(aggregationMethodForge);
        root.addChildNode(rootNode);
        return new Pair<ExprDotNodeAggregationMethodRootNode, List<ExprChainedSpec>>(root, newChain);
    }

    @Override
    public FilterExprAnalyzerAffector getAffector(boolean isOuterJoin) {
        ExprDotNodeImpl.checkValidated(this.forge);
        return isOuterJoin ? null : this.forge.getFilterExprAnalyzerAffector();
    }

    private ExprDotNodeForge getPropertyPairEvaluator(ExprForge parameterForge, Pair<PropertyResolutionDescriptor, String> propertyInfoPair, ExprValidationContext validationContext) throws ExprValidationException {
        String propertyName = propertyInfoPair.getFirst().getPropertyName();
        EventPropertyDescriptor propertyDesc = EventTypeUtility.getNestablePropertyDescriptor(propertyInfoPair.getFirst().getStreamEventType(), propertyName);
        if (propertyDesc == null || !propertyDesc.isMapped() && !propertyDesc.isIndexed()) {
            throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + propertyName + "' could not be resolved");
        }
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        EventPropertyGetterMappedSPI mappedGetter = null;
        EventPropertyGetterIndexedSPI indexedGetter = null;
        Class propertyType = Object.class;
        if (propertyDesc.isMapped()) {
            if (parameterForge.getEvaluationType() != String.class) {
                throw new ExprValidationException("Parameter expression to mapped property '" + propertyDesc.getPropertyName() + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterForge.getEvaluationType()));
            }
            mappedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterMappedSPI(propertyInfoPair.getFirst().getPropertyName());
            if (mappedGetter == null) {
                throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
            }
        } else {
            if (JavaClassHelper.getBoxedType(parameterForge.getEvaluationType()) != Integer.class) {
                throw new ExprValidationException("Parameter expression to indexed property '" + propertyDesc.getPropertyName() + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterForge.getEvaluationType()));
            }
            indexedGetter = ((EventTypeSPI)propertyInfoPair.getFirst().getStreamEventType()).getGetterIndexedSPI(propertyInfoPair.getFirst().getPropertyName());
            if (indexedGetter == null) {
                throw new ExprValidationException("Indexed property named '" + propertyName + "' failed to obtain getter-object");
            }
        }
        if (propertyDesc.getPropertyComponentType() != null) {
            propertyType = JavaClassHelper.getBoxedType(propertyDesc.getPropertyComponentType());
        }
        return new ExprDotNodeForgePropertyExpr(this, validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterForge, propertyType, indexedGetter, mappedGetter);
    }

    private int prefixedStreamName(List<ExprChainedSpec> chainSpec, StreamTypeService streamTypeService) {
        if (chainSpec.size() < 1) {
            return -1;
        }
        ExprChainedSpec spec = chainSpec.get(0);
        if (spec.getParameters().size() > 0 && !spec.isProperty()) {
            return -1;
        }
        return streamTypeService.getStreamNumForStreamName(spec.getName());
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtilityModify.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    @Override
    public List<ExprChainedSpec> getChainSpec() {
        return this.chainSpec;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    public boolean isConstantResult() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.isReturnsConstantResult();
    }

    @Override
    public ExprForge getForge() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.getStreamNumReferenced();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        ExprDotNodeImpl.checkValidated(this.forge);
        return this.forge.getRootPropertyName();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.getChildNodes().length != 0) {
            writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.getChildNodes()[0]));
        }
        ExprNodeUtilityPrint.toExpressionString(this.chainSpec, writer, this.getChildNodes().length != 0, null);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.MINIMUM;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprDotNodeImpl)) {
            return false;
        }
        ExprDotNodeImpl other = (ExprDotNodeImpl)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtilityQuery.collectChainParameters(this.chainSpec);
    }

    @Override
    public VariableMetaData isVariableOpGetName(VariableCompileTimeResolver variableCompileTimeResolver) {
        if (this.chainSpec.size() > 0 && this.chainSpec.get(0).isProperty()) {
            return variableCompileTimeResolver.resolve(this.chainSpec.get(0).getName());
        }
        return null;
    }

    private ExprValidationException handleNotFound(String name) {
        String appDotMethodDidYouMean = this.getAppDotMethodDidYouMean();
        String message = "Unknown single-row function, expression declaration, script or aggregation function named '" + name + "' could not be resolved";
        if (appDotMethodDidYouMean != null) {
            message = message + " (did you mean '" + appDotMethodDidYouMean + "')";
        }
        return new ExprValidationException(message);
    }

    private String getAppDotMethodDidYouMean() {
        String lhsName = this.chainSpec.get(0).getName().toLowerCase(Locale.ENGLISH);
        if (lhsName.equals("rectangle")) {
            return "rectangle.intersects";
        }
        if (lhsName.equals("point")) {
            return "point.inside";
        }
        return null;
    }

    private ExprAppDotMethodImpl getAppDotMethod(boolean filterExpression) throws ExprValidationException {
        boolean rectangleIntersectsRectangle;
        boolean rectangleIntersects;
        if (this.chainSpec.size() < 2) {
            return null;
        }
        String lhsName = this.chainSpec.get(0).getName().toLowerCase(Locale.ENGLISH);
        String operationName = this.chainSpec.get(1).getName().toLowerCase(Locale.ENGLISH);
        boolean pointInside = lhsName.equals("point") && operationName.equals("inside");
        boolean bl = rectangleIntersects = lhsName.equals("rectangle") && operationName.equals("intersects");
        if (!pointInside && !rectangleIntersects) {
            return null;
        }
        if (this.chainSpec.get(1).getParameters().size() != 1) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        ExprNode param = this.chainSpec.get(1).getParameters().get(0);
        if (!(param instanceof ExprDotNode)) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        ExprDotNode compared = (ExprDotNode)this.chainSpec.get(1).getParameters().get(0);
        if (compared.getChainSpec().size() != 1) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        String rhsName = compared.getChainSpec().get(0).getName().toLowerCase(Locale.ENGLISH);
        boolean pointInsideRectangle = pointInside && rhsName.equals("rectangle");
        boolean bl2 = rectangleIntersectsRectangle = rectangleIntersects && rhsName.equals("rectangle");
        if (!pointInsideRectangle && !rectangleIntersectsRectangle) {
            throw this.getAppDocMethodException(lhsName, operationName);
        }
        List<ExprNode> lhsExpressions = this.chainSpec.get(0).getParameters();
        ExprNode[] indexNamedParameter = null;
        ArrayList<ExprNode> lhsExpressionsValues = new ArrayList<ExprNode>();
        for (ExprNode lhsExpression : lhsExpressions) {
            if (lhsExpression instanceof ExprNamedParameterNode) {
                ExprNamedParameterNode named = (ExprNamedParameterNode)((Object)lhsExpression);
                if (named.getParameterName().toLowerCase(Locale.ENGLISH).equals("filterindex")) {
                    if (!filterExpression) {
                        throw new ExprValidationException("The '" + named.getParameterName() + "' named parameter can only be used in in filter expressions");
                    }
                    indexNamedParameter = named.getChildNodes();
                    continue;
                }
                throw new ExprValidationException(lhsName + " does not accept '" + named.getParameterName() + "' as a named parameter");
            }
            lhsExpressionsValues.add(lhsExpression);
        }
        ExprNode[] lhs = ExprNodeUtilityQuery.toArray(lhsExpressionsValues);
        ExprNode[] rhs = ExprNodeUtilityQuery.toArray(compared.getChainSpec().get(0).getParameters());
        SettingsApplicationDotMethodBase predefined = pointInsideRectangle ? new SettingsApplicationDotMethodPointInsideRectange(this, lhsName, lhs, operationName, rhsName, rhs, indexNamedParameter) : new SettingsApplicationDotMethodRectangeIntersectsRectangle(this, lhsName, lhs, operationName, rhsName, rhs, indexNamedParameter);
        return new ExprAppDotMethodImpl(predefined);
    }

    private ExprValidationException getAppDocMethodException(String lhsName, String operationName) {
        return new ExprValidationException(lhsName + "." + operationName + " requires a single rectangle as parameter");
    }
}

