/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.common.internal.epl.datetime.eval.ExprDotDTFactory;
import com.espertech.esper.common.internal.epl.datetime.eval.ExprDotDTMethodDesc;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeEnumMethod;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeProperty;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeUnpackBean;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeUnpackBeanTable;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeUnpackCollEventBean;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotForgeUnpackCollEventBeanTable;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotEventCollectionForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotEventSingleForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotScalarArrayForge;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotScalarCollection;
import com.espertech.esper.common.internal.epl.enummethod.dot.PropertyDotScalarIterable;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationGivenEventForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityResolve;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEnumerationSourceForgeForProps;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitorImpl;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForgeArrayGet;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForgeArraySize;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeDuck;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotMethodForgeNoDuck;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeRealizedChain;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import com.espertech.esper.common.internal.rettype.ClassEPType;
import com.espertech.esper.common.internal.rettype.ClassMultiValuedEPType;
import com.espertech.esper.common.internal.rettype.EPType;
import com.espertech.esper.common.internal.rettype.EPTypeCodegenSharable;
import com.espertech.esper.common.internal.rettype.EPTypeHelper;
import com.espertech.esper.common.internal.rettype.EventEPType;
import com.espertech.esper.common.internal.rettype.EventMultiValuedEPType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ExprDotNodeUtility {
    public static ObjectArrayEventType makeTransientOAType(String enumMethod, String propertyName, Class type, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) {
        HashMap<String, Object> propsResult = new HashMap<String, Object>();
        propsResult.put(propertyName, JavaClassHelper.getBoxedType(type));
        String eventTypeName = services.getEventTypeNameGeneratorStatement().getAnonymousTypeNameEnumMethod(enumMethod, propertyName);
        EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, statementRawInfo.getModuleName(), EventTypeTypeClass.ENUMDERIVED, EventTypeApplicationType.OBJECTARR, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        ObjectArrayEventType oatype = BaseNestableEventUtil.makeOATypeCompileTime(metadata, propsResult, null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
        services.getEventTypeCompileTimeRegistry().newType(oatype);
        return oatype;
    }

    public static boolean isDatetimeOrEnumMethod(String name) {
        return EnumMethodEnum.isEnumerationMethod(name) || DatetimeMethodEnum.isDateTimeMethod(name);
    }

    public static ExprDotEnumerationSourceForge getEnumerationSource(ExprNode inputExpression, StreamTypeService streamTypeService, boolean hasEnumerationMethod, boolean disablePropertyExpressionEventCollCache, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        ExprForge rootNodeForge = inputExpression.getForge();
        ExprEnumerationForge rootLambdaForge = null;
        EPType info = null;
        if (rootNodeForge instanceof ExprEnumerationForge) {
            Class componentType;
            EventType eventTypeSingle;
            rootLambdaForge = (ExprEnumerationForge)((Object)rootNodeForge);
            EventType eventTypeCollection = rootLambdaForge.getEventTypeCollection(statementRawInfo, compileTimeServices);
            if (eventTypeCollection != null) {
                info = EPTypeHelper.collectionOfEvents(eventTypeCollection);
            }
            if (info == null && (eventTypeSingle = rootLambdaForge.getEventTypeSingle(statementRawInfo, compileTimeServices)) != null) {
                info = EPTypeHelper.singleEvent(eventTypeSingle);
            }
            if (info == null && (componentType = rootLambdaForge.getComponentTypeCollection()) != null) {
                info = EPTypeHelper.collectionOfSingleValue(rootLambdaForge.getComponentTypeCollection());
            }
            if (info == null) {
                rootLambdaForge = null;
            }
        } else if (inputExpression instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)inputExpression;
            int streamId = identNode.getStreamId();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            return ExprDotNodeUtility.getPropertyEnumerationSource(identNode.getResolvedPropertyName(), streamId, streamType, hasEnumerationMethod, disablePropertyExpressionEventCollCache);
        }
        return new ExprDotEnumerationSourceForge(info, null, rootLambdaForge);
    }

    public static ExprDotEnumerationSourceForgeForProps getPropertyEnumerationSource(String propertyName, int streamId, EventType streamType, boolean allowEnumType, boolean disablePropertyExpressionEventCollCache) {
        Class propertyType = streamType.getPropertyType(propertyName);
        EPType typeInfo = EPTypeHelper.singleValue(propertyType);
        if (!allowEnumType) {
            return new ExprDotEnumerationSourceForgeForProps(null, typeInfo, streamId, null);
        }
        FragmentEventType fragmentEventType = streamType.getFragmentType(propertyName);
        EventPropertyGetterSPI getter = ((EventTypeSPI)streamType).getGetterSPI(propertyName);
        ExprNodeRenderable enumEvaluator = null;
        if (getter != null && fragmentEventType != null) {
            if (fragmentEventType.isIndexed()) {
                enumEvaluator = new PropertyDotEventCollectionForge(propertyName, streamId, fragmentEventType.getFragmentType(), getter, disablePropertyExpressionEventCollCache);
                typeInfo = EPTypeHelper.collectionOfEvents(fragmentEventType.getFragmentType());
            } else {
                enumEvaluator = new PropertyDotEventSingleForge(streamId, fragmentEventType.getFragmentType(), getter);
                typeInfo = EPTypeHelper.singleEvent(fragmentEventType.getFragmentType());
            }
        } else {
            EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamType, propertyName);
            if (desc != null && desc.isIndexed() && !desc.isRequiresIndex() && desc.getPropertyComponentType() != null) {
                if (JavaClassHelper.isImplementsInterface(propertyType, Collection.class)) {
                    enumEvaluator = new PropertyDotScalarCollection(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (JavaClassHelper.isImplementsInterface(propertyType, Iterable.class)) {
                    enumEvaluator = new PropertyDotScalarIterable(propertyName, streamId, getter, desc.getPropertyComponentType(), propertyType);
                } else if (propertyType.isArray()) {
                    enumEvaluator = new PropertyDotScalarArrayForge(propertyName, streamId, getter, desc.getPropertyComponentType(), desc.getPropertyType());
                } else {
                    throw new IllegalStateException("Property indicated indexed-type but failed to find proper collection adapter for use with enumeration methods");
                }
                typeInfo = EPTypeHelper.collectionOfSingleValue(desc.getPropertyComponentType());
            }
        }
        return new ExprDotEnumerationSourceForgeForProps((ExprEnumerationForge)((Object)enumEvaluator), typeInfo, streamId, (ExprEnumerationGivenEventForge)((Object)enumEvaluator));
    }

    public static EventType[] getSingleLambdaParamEventType(String enumMethodUsedName, List<String> goesToNames, EventType inputEventType, Class collectionComponentType, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) {
        if (inputEventType != null) {
            return new EventType[]{inputEventType};
        }
        return new EventType[]{ExprDotNodeUtility.makeTransientOAType(enumMethodUsedName, goesToNames.get(0), collectionComponentType, statementRawInfo, services)};
    }

    public static ExprDotEval[] getEvaluators(ExprDotForge[] forges) {
        ExprDotEval[] evals = new ExprDotEval[forges.length];
        for (int i = 0; i < forges.length; ++i) {
            evals[i] = forges[i].getDotEvaluator();
        }
        return evals;
    }

    public static Object evaluateChain(ExprDotForge[] forges, ExprDotEval[] evaluators, Object inner, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprDotEval methodEval;
        ExprDotEval[] exprDotEvalArray = evaluators;
        int n = exprDotEvalArray.length;
        for (int i = 0; i < n && (inner = (methodEval = exprDotEvalArray[i]).evaluate(inner, eventsPerStream, isNewData, context)) != null; ++i) {
        }
        return inner;
    }

    public static ExprDotNodeRealizedChain getChainEvaluators(Integer streamOfProviderIfApplicable, EPType inputType, List<ExprChainedSpec> chainSpec, ExprValidationContext validationContext, boolean isDuckTyping, ExprDotNodeFilterAnalyzerInput inputDesc) throws ExprValidationException {
        ArrayList<ExprDotForge> methodForges = new ArrayList<ExprDotForge>();
        EPType currentInputType = inputType;
        EnumMethodEnum lastLambdaFunc = null;
        ExprChainedSpec lastElement = chainSpec.isEmpty() ? null : chainSpec.get(chainSpec.size() - 1);
        FilterExprAnalyzerAffector filterAnalyzerDesc = null;
        ArrayDeque<ExprChainedSpec> chainSpecStack = new ArrayDeque<ExprChainedSpec>(chainSpec);
        while (!chainSpecStack.isEmpty()) {
            ExprChainedSpec chainElement = (ExprChainedSpec)chainSpecStack.removeFirst();
            lastLambdaFunc = null;
            ExprForge[] paramForges = new ExprForge[chainElement.getParameters().size()];
            Class[] paramTypes = new Class[chainElement.getParameters().size()];
            for (int i = 0; i < chainElement.getParameters().size(); ++i) {
                paramForges[i] = chainElement.getParameters().get(i).getForge();
                paramTypes[i] = paramForges[i].getEvaluationType();
            }
            if (currentInputType instanceof ClassMultiValuedEPType) {
                ClassMultiValuedEPType type = (ClassMultiValuedEPType)currentInputType;
                if (chainElement.getName().toLowerCase(Locale.ENGLISH).equals("size") && paramTypes.length == 0 && lastElement == chainElement) {
                    ExprDotForgeArraySize sizeExpr = new ExprDotForgeArraySize();
                    methodForges.add(sizeExpr);
                    currentInputType = sizeExpr.getTypeInfo();
                    continue;
                }
                if (chainElement.getName().toLowerCase(Locale.ENGLISH).equals("get") && paramTypes.length == 1 && JavaClassHelper.getBoxedType(paramTypes[0]) == Integer.class) {
                    Class componentType = JavaClassHelper.getBoxedType(type.getComponent());
                    ExprDotForgeArrayGet get = new ExprDotForgeArrayGet(paramForges[0], componentType);
                    methodForges.add(get);
                    currentInputType = get.getTypeInfo();
                    continue;
                }
            }
            boolean matchingMethod = false;
            Class methodTarget = ExprDotNodeUtility.getMethodTarget(currentInputType);
            if (methodTarget != null) {
                try {
                    ExprDotNodeUtility.getValidateMethodDescriptor(methodTarget, chainElement.getName(), chainElement.getParameters(), validationContext);
                    matchingMethod = true;
                }
                catch (ExprValidationException get) {
                    // empty catch block
                }
            }
            if (EnumMethodEnum.isEnumerationMethod(chainElement.getName()) && (!matchingMethod || methodTarget.isArray() || JavaClassHelper.isImplementsInterface(methodTarget, Collection.class))) {
                EnumMethodEnum enumerationMethod = EnumMethodEnum.fromName(chainElement.getName());
                ExprDotForgeEnumMethod eval = (ExprDotForgeEnumMethod)JavaClassHelper.instantiate(ExprDotForgeEnumMethod.class, enumerationMethod.getImplementation());
                if (currentInputType instanceof ClassEPType && JavaClassHelper.isImplementsInterface(((ClassEPType)currentInputType).getType(), Collection.class)) {
                    currentInputType = EPTypeHelper.collectionOfSingleValue(Object.class);
                }
                eval.init(streamOfProviderIfApplicable, enumerationMethod, chainElement.getName(), currentInputType, chainElement.getParameters(), validationContext);
                currentInputType = eval.getTypeInfo();
                if (currentInputType == null) {
                    throw new IllegalStateException("Enumeration method '" + chainElement.getName() + "' has not returned type information");
                }
                methodForges.add(eval);
                lastLambdaFunc = enumerationMethod;
                continue;
            }
            if (DatetimeMethodEnum.isDateTimeMethod(chainElement.getName()) && (!matchingMethod || methodTarget == Calendar.class || methodTarget == Date.class)) {
                DatetimeMethodEnum datetimeMethod = DatetimeMethodEnum.fromName(chainElement.getName());
                ExprDotDTMethodDesc datetimeImpl = ExprDotDTFactory.validateMake(validationContext.getStreamTypeService(), chainSpecStack, datetimeMethod, chainElement.getName(), currentInputType, chainElement.getParameters(), inputDesc, validationContext.getClasspathImportService().getTimeAbacus(), null, validationContext.getTableCompileTimeResolver());
                currentInputType = datetimeImpl.getReturnType();
                if (currentInputType == null) {
                    throw new IllegalStateException("Date-time method '" + chainElement.getName() + "' has not returned type information");
                }
                methodForges.add(datetimeImpl.getForge());
                filterAnalyzerDesc = datetimeImpl.getIntervalFilterDesc();
                continue;
            }
            if (currentInputType instanceof EventEPType) {
                EventTypeSPI inputEventType = (EventTypeSPI)((EventEPType)currentInputType).getType();
                Class type = inputEventType.getPropertyType(chainElement.getName());
                EventPropertyGetterSPI getter = inputEventType.getGetterSPI(chainElement.getName());
                if (type != null && getter != null) {
                    ExprDotForgeProperty noduck = new ExprDotForgeProperty(getter, EPTypeHelper.singleValue(JavaClassHelper.getBoxedType(type)));
                    methodForges.add(noduck);
                    currentInputType = EPTypeHelper.singleValue(EPTypeHelper.getClassSingleValued(noduck.getTypeInfo()));
                    continue;
                }
            }
            if (methodTarget != null) {
                try {
                    ExprNodeUtilMethodDesc desc = ExprDotNodeUtility.getValidateMethodDescriptor(methodTarget, chainElement.getName(), chainElement.getParameters(), validationContext);
                    paramForges = desc.getChildForges();
                    ExprDotMethodForgeNoDuck forge = currentInputType instanceof ClassEPType ? (desc.getReflectionMethod().getReturnType().isArray() && !chainSpecStack.isEmpty() && EnumMethodEnum.isEnumerationMethod(((ExprChainedSpec)chainSpecStack.getFirst()).getName()) ? new ExprDotMethodForgeNoDuck(validationContext.getStatementName(), desc.getReflectionMethod(), paramForges, ExprDotMethodForgeNoDuck.Type.WRAPARRAY) : new ExprDotMethodForgeNoDuck(validationContext.getStatementName(), desc.getReflectionMethod(), paramForges, ExprDotMethodForgeNoDuck.Type.PLAIN)) : new ExprDotMethodForgeNoDuck(validationContext.getStatementName(), desc.getReflectionMethod(), paramForges, ExprDotMethodForgeNoDuck.Type.UNDERLYING);
                    methodForges.add(forge);
                    currentInputType = forge.getTypeInfo();
                }
                catch (Exception e) {
                    if (!isDuckTyping) {
                        throw new ExprValidationException(e.getMessage(), e);
                    }
                    ExprDotMethodForgeDuck duck = new ExprDotMethodForgeDuck(validationContext.getStatementName(), validationContext.getClasspathImportService(), chainElement.getName(), paramTypes, paramForges);
                    methodForges.add(duck);
                    currentInputType = duck.getTypeInfo();
                }
                continue;
            }
            String message = "Could not find event property or method named '" + chainElement.getName() + "' in " + EPTypeHelper.toTypeDescriptive(currentInputType);
            throw new ExprValidationException(message);
        }
        ExprDotForge[] intermediateEvals = methodForges.toArray(new ExprDotForge[methodForges.size()]);
        if (lastLambdaFunc != null) {
            ExprDotEval finalEval = null;
            if (currentInputType instanceof EventMultiValuedEPType) {
                EventMultiValuedEPType mvType = (EventMultiValuedEPType)currentInputType;
                TableMetaData tableMetadata = validationContext.getTableCompileTimeResolver().resolveTableFromEventType(mvType.getComponent());
                finalEval = tableMetadata != null ? new ExprDotForgeUnpackCollEventBeanTable(mvType.getComponent(), tableMetadata) : new ExprDotForgeUnpackCollEventBean(mvType.getComponent());
            } else if (currentInputType instanceof EventEPType) {
                EventEPType epType = (EventEPType)currentInputType;
                TableMetaData tableMetadata = validationContext.getTableCompileTimeResolver().resolveTableFromEventType(epType.getType());
                finalEval = tableMetadata != null ? new ExprDotForgeUnpackBeanTable(epType.getType(), tableMetadata) : new ExprDotForgeUnpackBean(epType.getType());
            }
            if (finalEval != null) {
                methodForges.add((ExprDotForge)((Object)finalEval));
            }
        }
        ExprDotForge[] unpackingForges = methodForges.toArray(new ExprDotForge[methodForges.size()]);
        return new ExprDotNodeRealizedChain(intermediateEvals, unpackingForges, filterAnalyzerDesc);
    }

    private static Class getMethodTarget(EPType currentInputType) {
        if (currentInputType instanceof ClassEPType) {
            return ((ClassEPType)currentInputType).getType();
        }
        if (currentInputType instanceof EventEPType) {
            return ((EventEPType)currentInputType).getType().getUnderlyingType();
        }
        return null;
    }

    public static Object evaluateChainWithWrap(ExprDotStaticMethodWrap resultWrapLambda, Object result, EventType optionalResultSingleEventType, Class resultType, ExprDotEval[] chainEval, ExprDotForge[] chainForges, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (result == null) {
            return null;
        }
        if (resultWrapLambda != null) {
            result = resultWrapLambda.convertNonNull(result);
        }
        for (ExprDotEval aChainEval : chainEval) {
            if ((result = aChainEval.evaluate(result, eventsPerStream, newData, exprEvaluatorContext)) != null) continue;
            return result;
        }
        return result;
    }

    public static CodegenExpression evaluateChainCodegen(CodegenMethod parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, CodegenExpression inner, Class innerType, ExprDotForge[] forges, ExprDotStaticMethodWrap optionalResultWrapLambda) {
        Class currentTargetType;
        if (forges.length == 0) {
            return inner;
        }
        ExprDotForge last = forges[forges.length - 1];
        Class lastType = EPTypeHelper.getCodegenReturnType(last.getTypeInfo());
        CodegenMethod methodNode = parent.makeChild(lastType, ExprDotNodeUtility.class, (CodegenScope)codegenClassScope).addParam(innerType, "inner");
        CodegenBlock block = methodNode.getBlock();
        String currentTarget = "wrapped";
        if (optionalResultWrapLambda != null) {
            currentTargetType = EPTypeHelper.getCodegenReturnType(optionalResultWrapLambda.getTypeInfo());
            if (lastType != Void.TYPE) {
                block.ifRefNullReturnNull("inner");
            }
            block.declareVar(currentTargetType, "wrapped", optionalResultWrapLambda.codegenConvertNonNull(CodegenExpressionBuilder.ref("inner"), methodNode, codegenClassScope));
        } else {
            block.declareVar(innerType, "wrapped", (CodegenExpression)CodegenExpressionBuilder.ref("inner"));
            currentTargetType = innerType;
        }
        String refname = null;
        ExprDotEvalVisitorImpl instrumentationName = new ExprDotEvalVisitorImpl();
        for (int i = 0; i < forges.length; ++i) {
            Class reftype;
            refname = "r" + i;
            forges[i].visit(instrumentationName);
            block.apply(InstrumentationCode.instblock(codegenClassScope, "qExprDotChainElement", CodegenExpressionBuilder.constant(i), CodegenExpressionBuilder.constant(instrumentationName.getMethodType()), CodegenExpressionBuilder.constant(instrumentationName.getMethodName())));
            CodegenExpression typeInformation = CodegenExpressionBuilder.constantNull();
            if (codegenClassScope.isInstrumented()) {
                typeInformation = codegenClassScope.addOrGetFieldSharable(new EPTypeCodegenSharable(forges[i].getTypeInfo(), codegenClassScope));
            }
            if ((reftype = EPTypeHelper.getCodegenReturnType(forges[i].getTypeInfo())) == Void.TYPE) {
                block.expression(forges[i].codegen(CodegenExpressionBuilder.ref(currentTarget), currentTargetType, methodNode, exprSymbol, codegenClassScope)).apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChainElement", typeInformation, CodegenExpressionBuilder.constantNull()));
                continue;
            }
            block.declareVar(reftype, refname, forges[i].codegen(CodegenExpressionBuilder.ref(currentTarget), currentTargetType, methodNode, exprSymbol, codegenClassScope));
            currentTarget = refname;
            currentTargetType = reftype;
            if (!reftype.isPrimitive()) {
                CodegenBlock ifBlock = block.ifRefNull(refname).apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChainElement", typeInformation, CodegenExpressionBuilder.constantNull()));
                if (lastType != Void.TYPE) {
                    ifBlock.blockReturn(CodegenExpressionBuilder.constantNull());
                } else {
                    ifBlock.blockEnd();
                }
            }
            block.apply(InstrumentationCode.instblock(codegenClassScope, "aExprDotChainElement", typeInformation, CodegenExpressionBuilder.ref(refname)));
        }
        if (lastType == Void.TYPE) {
            block.methodEnd();
        } else {
            block.methodReturn(CodegenExpressionBuilder.ref(refname));
        }
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    private static ExprNodeUtilMethodDesc getValidateMethodDescriptor(Class methodTarget, final String methodName, List<ExprNode> parameters, ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtilResolveExceptionHandler exceptionHandler = new ExprNodeUtilResolveExceptionHandler(){

            @Override
            public ExprValidationException handle(Exception e) {
                return new ExprValidationException("Failed to resolve method '" + methodName + "': " + e.getMessage(), e);
            }
        };
        EventType wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
        return ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(methodTarget.getName(), methodTarget, methodName, parameters, wildcardType != null, wildcardType, exceptionHandler, methodName, validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
    }
}

