/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.etc;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import java.io.StringWriter;

public class ExprEvalUnderlyingEvaluator
implements ExprEvaluator,
ExprForge {
    private final int streamNum;
    private final Class resultType;

    public ExprEvalUnderlyingEvaluator(int streamNum, Class resultType) {
        this.streamNum = streamNum;
        this.resultType = resultType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (eventsPerStream == null) {
            return null;
        }
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return event.getUnderlying();
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(this.resultType, this.getClass(), (CodegenScope)codegenClassScope);
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
        methodNode.getBlock().ifNullReturnNull(refEPS).declareVar(EventBean.class, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamNum))).ifRefNullReturnNull("event").methodReturn(CodegenExpressionBuilder.cast(requiredType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("event"), "getUnderlying", new CodegenExpression[0])));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public Class getEvaluationType() {
        return this.resultType;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return new ExprNodeRenderable(){

            @Override
            public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence) {
                writer.append(this.getClass().getSimpleName());
            }
        };
    }
}

