/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCompareEquals;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCaseNodeForge;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCaseNodeForgeEvalSyntax1;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;
import java.util.Map;

public class ExprCaseNodeForgeEvalSyntax2
implements ExprEvaluator {
    private final ExprCaseNodeForge forge;
    private final List<UniformPair<ExprEvaluator>> whenThenNodeList;
    private final ExprEvaluator compareExprNode;
    private final ExprEvaluator optionalElseExprNode;

    ExprCaseNodeForgeEvalSyntax2(ExprCaseNodeForge forge, List<UniformPair<ExprEvaluator>> whenThenNodeList, ExprEvaluator compareExprNode, ExprEvaluator optionalElseExprNode) {
        this.forge = forge;
        this.whenThenNodeList = whenThenNodeList;
        this.compareExprNode = compareExprNode;
        this.optionalElseExprNode = optionalElseExprNode;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object checkResult = this.compareExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprEvaluator> p : this.whenThenNodeList) {
            Object whenResult = p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (!this.compare(checkResult, whenResult)) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.forge.getEvaluationType() && this.forge.isNumericResult()) {
            caseResult = JavaClassHelper.coerceBoxed((Number)caseResult, this.forge.getEvaluationType());
        }
        return caseResult;
    }

    public static CodegenExpression codegen(ExprCaseNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class evaluationType = forge.getEvaluationType() == null ? Map.class : forge.getEvaluationType();
        Class compareType = forge.getOptionalCompareExprNode().getForge().getEvaluationType();
        CodegenMethod methodNode = codegenMethodScope.makeChild(evaluationType, ExprCaseNodeForgeEvalSyntax2.class, (CodegenScope)codegenClassScope);
        Class checkResultType = compareType == null ? Object.class : compareType;
        CodegenBlock block = methodNode.getBlock().declareVar(checkResultType, "checkResult", forge.getOptionalCompareExprNode().getForge().evaluateCodegen(checkResultType, methodNode, exprSymbol, codegenClassScope));
        int num = 0;
        for (UniformPair<ExprNode> pair : forge.getWhenThenNodeList()) {
            String refname = "r" + num;
            Class lhsType = pair.getFirst().getForge().getEvaluationType();
            Class lhsDeclaredType = lhsType == null ? Object.class : lhsType;
            block.declareVar(lhsDeclaredType, refname, pair.getFirst().getForge().evaluateCodegen(lhsDeclaredType, methodNode, exprSymbol, codegenClassScope));
            CodegenExpression compareExpression = ExprCaseNodeForgeEvalSyntax2.codegenCompare(CodegenExpressionBuilder.ref("checkResult"), compareType, CodegenExpressionBuilder.ref(refname), pair.getFirst().getForge().getEvaluationType(), forge, methodNode, codegenClassScope);
            block.ifCondition(compareExpression).blockReturn(ExprCaseNodeForgeEvalSyntax1.codegenToType(forge, pair.getSecond(), methodNode, exprSymbol, codegenClassScope));
            ++num;
        }
        if (forge.getOptionalElseExprNode() != null) {
            block.methodReturn(ExprCaseNodeForgeEvalSyntax1.codegenToType(forge, forge.getOptionalElseExprNode(), methodNode, exprSymbol, codegenClassScope));
        } else {
            block.methodReturn(CodegenExpressionBuilder.constantNull());
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    private boolean compare(Object leftResult, Object rightResult) {
        if (leftResult == null) {
            return rightResult == null;
        }
        if (rightResult == null) {
            return false;
        }
        if (!this.forge.isMustCoerce()) {
            return leftResult.equals(rightResult);
        }
        Number left = this.forge.getCoercer().coerceBoxed((Number)leftResult);
        Number right = this.forge.getCoercer().coerceBoxed((Number)rightResult);
        return left.equals(right);
    }

    private static CodegenExpression codegenCompare(CodegenExpressionRef lhs, Class lhsType, CodegenExpressionRef rhs, Class rhsType, ExprCaseNodeForge forge, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod method;
        if (lhsType == null) {
            return CodegenExpressionBuilder.equalsNull(rhs);
        }
        if (rhsType == null) {
            return CodegenExpressionBuilder.equalsNull(lhs);
        }
        if (lhsType.isPrimitive() && rhsType.isPrimitive() && !forge.isMustCoerce()) {
            return CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(lhs, lhsType, rhs, rhsType);
        }
        CodegenBlock block = codegenMethodScope.makeChild(Boolean.TYPE, ExprCaseNodeForgeEvalSyntax2.class, (CodegenScope)codegenClassScope).addParam(lhsType, "leftResult").addParam(rhsType, "rightResult").getBlock();
        if (!lhsType.isPrimitive()) {
            CodegenBlock ifBlock = block.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("leftResult")));
            if (rhsType.isPrimitive()) {
                ifBlock.blockReturn(CodegenExpressionBuilder.constantFalse());
            } else {
                ifBlock.blockReturn(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("rightResult")));
            }
        }
        if (!rhsType.isPrimitive()) {
            block.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("rightResult"))).blockReturn(CodegenExpressionBuilder.constantFalse());
        }
        if (!forge.isMustCoerce()) {
            method = block.methodReturn(CodegenLegoCompareEquals.codegenEqualsNonNullNoCoerce(CodegenExpressionBuilder.ref("leftResult"), lhsType, CodegenExpressionBuilder.ref("rightResult"), rhsType));
        } else {
            block.declareVar(Number.class, "left", forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref("leftResult"), lhsType));
            block.declareVar(Number.class, "right", forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref("rightResult"), rhsType));
            method = block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("left"), "equals", CodegenExpressionBuilder.ref("right")));
        }
        return CodegenExpressionBuilder.localMethodBuild(method).pass(lhs).pass(rhs).call();
    }
}

