/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCastNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCastNodeForgeConstEval;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCastNodeForgeNonConstEval;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;

public class ExprCastNodeForge
implements ExprForgeInstrumentable {
    private final ExprCastNode parent;
    private final ExprCastNode.CasterParserComputerForge casterParserComputerForge;
    private final Class targetType;
    private final boolean isConstant;
    private final Object constant;

    ExprCastNodeForge(ExprCastNode parent, ExprCastNode.CasterParserComputerForge casterParserComputerForge, Class targetType, boolean isConstant, Object constant) {
        this.parent = parent;
        this.casterParserComputerForge = casterParserComputerForge;
        this.targetType = targetType;
        this.isConstant = isConstant;
        this.constant = constant;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        if (this.isConstant) {
            return ExprForgeConstantType.DEPLOYCONST;
        }
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        if (this.isConstant) {
            return new ExprCastNodeForgeConstEval(this, this.constant);
        }
        return new ExprCastNodeForgeNonConstEval(this, this.parent.getChildNodes()[0].getForge().getExprEvaluator(), this.casterParserComputerForge.getEvaluatorComputer());
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.isConstant) {
            if (this.constant == null) {
                return CodegenExpressionBuilder.constantNull();
            }
            return ExprCastNodeForgeConstEval.codegen(this, codegenClassScope);
        }
        return ExprCastNodeForgeNonConstEval.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprCast", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public Class getEvaluationType() {
        return this.targetType;
    }

    @Override
    public ExprCastNode getForgeRenderable() {
        return this.parent;
    }

    public ExprCastNode.CasterParserComputerForge getCasterParserComputerForge() {
        return this.casterParserComputerForge;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public Object getConstant() {
        return this.constant;
    }
}

