/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprEventIdentityEqualsNodeForge;
import java.io.StringWriter;

public class ExprEventIdentityEqualsNode
extends ExprNodeBase {
    public static final String NAME = "event_identity_equals";
    private ExprEventIdentityEqualsNodeForge forge;

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("event_identity_equalsrequires two parameters");
        }
        ExprStreamUnderlyingNode undOne = this.checkStreamUnd(this.getChildNodes()[0]);
        ExprStreamUnderlyingNode undTwo = this.checkStreamUnd(this.getChildNodes()[1]);
        if (undOne.getEventType() != undTwo.getEventType()) {
            throw new ExprValidationException("event_identity_equals received two different event types as parameter, type '" + undOne.getEventType().getName() + "' is not the same as type '" + undTwo.getEventType().getName() + "'");
        }
        this.forge = new ExprEventIdentityEqualsNodeForge(this, undOne, undTwo);
        return null;
    }

    private ExprStreamUnderlyingNode checkStreamUnd(ExprNode childNode) throws ExprValidationException {
        if (!(childNode instanceof ExprStreamUnderlyingNode)) {
            throw new ExprValidationException("event_identity_equals requires a parameter that resolves to an event but received '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(childNode) + "'");
        }
        return (ExprStreamUnderlyingNode)childNode;
    }

    @Override
    public ExprForge getForge() {
        ExprEventIdentityEqualsNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprEventIdentityEqualsNode;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(NAME);
        ExprNodeUtilityPrint.toExpressionStringParams(writer, this.getChildNodes());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }
}

