/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForge;

public class ExprEqualsAllAnyNodeForgeEvalAnyNoColl
implements ExprEvaluator {
    private final ExprEqualsAllAnyNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprEqualsAllAnyNodeForgeEvalAnyNoColl(ExprEqualsAllAnyNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object result = this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
        return result;
    }

    private Object evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object leftResult = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (this.forge.isMustCoerce() && leftResult != null) {
            leftResult = this.forge.getCoercer().coerceBoxed((Number)leftResult);
        }
        return this.compareAny(leftResult, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private Object compareAny(Object leftResult, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        boolean isNot = this.forge.getForgeRenderable().isNot();
        boolean hasNonNullRow = false;
        boolean hasNullRow = false;
        int len = this.forge.getForgeRenderable().getChildNodes().length - 1;
        for (int i = 1; i <= len; ++i) {
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (leftResult == null) {
                return null;
            }
            if (rightResult == null) {
                hasNullRow = true;
                continue;
            }
            hasNonNullRow = true;
            if (!this.forge.isMustCoerce()) {
                if ((isNot || !leftResult.equals(rightResult)) && (!isNot || leftResult.equals(rightResult))) continue;
                return true;
            }
            Number right = this.forge.getCoercer().coerceBoxed((Number)rightResult);
            if ((isNot || !leftResult.equals(right)) && (!isNot || leftResult.equals(right))) continue;
            return true;
        }
        if (!hasNonNullRow || hasNullRow) {
            return null;
        }
        return false;
    }
}

