/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForgeCoercion;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForgeNC;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.Map;

public class ExprEqualsNodeImpl
extends ExprNodeBase
implements ExprEqualsNode {
    private static final long serialVersionUID = 5504809379222369952L;
    private final boolean isNotEquals;
    private final boolean isIs;
    private transient ExprEqualsNodeForge forge;

    public ExprEqualsNodeImpl(boolean isNotEquals, boolean isIs) {
        this.isNotEquals = isNotEquals;
        this.isIs = isIs;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprEqualsNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprEqualsNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Invalid use of equals, expecting left-hand side and right-hand side but received " + this.getChildNodes().length + " expressions");
        }
        ExprNode lhs = this.getChildNodes()[0];
        ExprNode rhs = this.getChildNodes()[1];
        Class typeOne = JavaClassHelper.getBoxedType(lhs.getForge().getEvaluationType());
        Class typeTwo = JavaClassHelper.getBoxedType(rhs.getForge().getEvaluationType());
        if (typeOne == null || typeTwo == null) {
            this.forge = new ExprEqualsNodeForgeNC(this);
            return null;
        }
        if (typeOne.equals(typeTwo) || typeOne.isAssignableFrom(typeTwo)) {
            this.forge = new ExprEqualsNodeForgeNC(this);
            return null;
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        if (coercionType == JavaClassHelper.getBoxedType(typeOne) && coercionType == JavaClassHelper.getBoxedType(typeTwo)) {
            this.forge = new ExprEqualsNodeForgeNC(this);
        } else {
            if (!JavaClassHelper.isNumeric(coercionType)) {
                throw new ExprValidationException("Cannot convert datatype '" + coercionType.getName() + "' to a value that fits both type '" + typeOne.getName() + "' and type '" + typeTwo.getName() + "'");
            }
            SimpleNumberCoercer numberCoercerLHS = SimpleNumberCoercerFactory.getCoercer(typeOne, coercionType);
            SimpleNumberCoercer numberCoercerRHS = SimpleNumberCoercerFactory.getCoercer(typeTwo, coercionType);
            this.forge = new ExprEqualsNodeForgeCoercion(this, numberCoercerLHS, numberCoercerRHS);
        }
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        if (this.isIs) {
            writer.append(" is ");
            if (this.isNotEquals) {
                writer.append("not ");
            }
        } else if (!this.isNotEquals) {
            writer.append("=");
        } else {
            writer.append("!=");
        }
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.EQUALS;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprEqualsNode)) {
            return false;
        }
        ExprEqualsNode other = (ExprEqualsNode)node;
        return other.isNotEquals() == this.isNotEquals;
    }

    @Override
    public boolean isNotEquals() {
        return this.isNotEquals;
    }

    @Override
    public boolean isIs() {
        return this.isIs;
    }
}

