/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForgeConst;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForgeNonconst;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.LikeUtil;
import java.io.StringWriter;

public class ExprLikeNode
extends ExprNodeBase {
    private static final long serialVersionUID = 34888860063217132L;
    private final boolean isNot;
    private transient ExprLikeNodeForge forge;

    public ExprLikeNode(boolean not) {
        this.isNot = not;
    }

    public Class getEvaluationType() {
        return Boolean.class;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprLikeNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprLikeNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2 && this.getChildNodes().length != 3) {
            throw new ExprValidationException("The 'like' operator requires 2 (no escape) or 3 (with escape) child expressions");
        }
        Class evalChildType = this.getChildNodes()[0].getForge().getEvaluationType();
        boolean isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !isNumericValue) {
            throw new ExprValidationException("The 'like' operator requires a String or numeric type left-hand expression");
        }
        Class patternChildType = this.getChildNodes()[1].getForge().getEvaluationType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The 'like' operator requires a String-type pattern expression");
        }
        boolean isConstantPattern = this.getChildNodes()[1].getForge().getForgeConstantType().isCompileTimeConstant();
        boolean isConstantEscape = true;
        if (this.getChildNodes().length == 3) {
            if (this.getChildNodes()[2].getForge().getEvaluationType() != String.class) {
                throw new ExprValidationException("The 'like' operator escape parameter requires a character-type value");
            }
            isConstantEscape = this.getChildNodes()[2].getForge().getForgeConstantType().isCompileTimeConstant();
        }
        if (isConstantPattern && isConstantEscape) {
            String patternVal = (String)this.getChildNodes()[1].getForge().getExprEvaluator().evaluate(null, true, null);
            if (patternVal == null) {
                throw new ExprValidationException("The 'like' operator pattern returned null");
            }
            String escape = "\\";
            Character escapeCharacter = null;
            if (this.getChildNodes().length == 3) {
                escape = (String)this.getChildNodes()[2].getForge().getExprEvaluator().evaluate(null, true, null);
            }
            if (escape.length() > 0) {
                escapeCharacter = Character.valueOf(escape.charAt(0));
            }
            LikeUtil likeUtil = new LikeUtil(patternVal, escapeCharacter, false);
            CodegenExpression likeUtilInit = CodegenExpressionBuilder.newInstance(LikeUtil.class, CodegenExpressionBuilder.constant(patternVal), CodegenExpressionBuilder.constant(escapeCharacter), CodegenExpressionBuilder.constantFalse());
            this.forge = new ExprLikeNodeForgeConst(this, isNumericValue, likeUtil, likeUtilInit);
        } else {
            this.forge = new ExprLikeNodeForgeNonconst(this, isNumericValue);
        }
        return null;
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprLikeNode)) {
            return false;
        }
        ExprLikeNode other = (ExprLikeNode)node;
        return this.isNot == other.isNot;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        if (this.isNot) {
            writer.append(" not");
        }
        writer.append(" like ");
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
        if (this.getChildNodes().length == 3) {
            writer.append(" escape ");
            this.getChildNodes()[2].toEPL(writer, this.getPrecedence());
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    public boolean isNot() {
        return this.isNot;
    }
}

