/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprLikeNodeForgeConst;
import com.espertech.esper.common.internal.util.LikeUtil;

public class ExprLikeNodeForgeConstEval
implements ExprEvaluator {
    private final ExprLikeNodeForgeConst forge;
    private final ExprEvaluator lhsEval;

    ExprLikeNodeForgeConstEval(ExprLikeNodeForgeConst forge, ExprEvaluator lhsEval) {
        this.forge = forge;
        this.lhsEval = lhsEval;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object value = this.lhsEval.evaluate(eventsPerStream, isNewData, context);
        if (value == null) {
            return null;
        }
        if (this.forge.isNumericValue()) {
            value = value.toString();
        }
        boolean result = this.forge.getForgeRenderable().isNot() ^ this.forge.getLikeUtil().compare((String)value);
        return result;
    }

    public static CodegenMethod codegen(ExprLikeNodeForgeConst forge, ExprNode lhs, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField mLikeUtil = codegenClassScope.addFieldUnshared(true, LikeUtil.class, forge.getLikeUtilInit());
        CodegenMethod methodNode = codegenMethodScope.makeChild(Boolean.class, ExprLikeNodeForgeConstEval.class, (CodegenScope)codegenClassScope);
        if (!forge.isNumericValue()) {
            methodNode.getBlock().declareVar(String.class, "value", lhs.getForge().evaluateCodegen(String.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("value").methodReturn(ExprLikeNodeForgeConstEval.getLikeCode(forge, mLikeUtil, CodegenExpressionBuilder.ref("value")));
        } else {
            methodNode.getBlock().declareVar(Object.class, "value", lhs.getForge().evaluateCodegen(Object.class, methodNode, exprSymbol, codegenClassScope)).ifRefNullReturnNull("value").methodReturn(ExprLikeNodeForgeConstEval.getLikeCode(forge, mLikeUtil, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "toString", new CodegenExpression[0])));
        }
        return methodNode;
    }

    static CodegenExpression getLikeCode(ExprLikeNodeForge forge, CodegenExpression refLike, CodegenExpression stringExpr) {
        CodegenExpression eval = CodegenExpressionBuilder.exprDotMethod(refLike, "compare", stringExpr);
        return !forge.getForgeRenderable().isNot() ? eval : CodegenExpressionBuilder.not(eval);
    }
}

