/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprMathNodeForge;
import com.espertech.esper.common.internal.type.MathArithTypeEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.math.BigDecimal;

public class ExprMathNode
extends ExprNodeBase {
    private static final long serialVersionUID = 6479683588602862158L;
    private final MathArithTypeEnum mathArithTypeEnum;
    private final boolean isIntegerDivision;
    private final boolean isDivisionByZeroReturnsNull;
    private transient ExprMathNodeForge forge;

    public ExprMathNode(MathArithTypeEnum mathArithTypeEnum, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull) {
        this.mathArithTypeEnum = mathArithTypeEnum;
        this.isIntegerDivision = isIntegerDivision;
        this.isDivisionByZeroReturnsNull = isDivisionByZeroReturnsNull;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprMathNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprMathNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Arithmatic node must have 2 parameters");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getForge().getEvaluationType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        ExprNode lhs = this.getChildNodes()[0];
        ExprNode rhs = this.getChildNodes()[1];
        Class lhsType = lhs.getForge().getEvaluationType();
        Class rhsType = rhs.getForge().getEvaluationType();
        Class resultType = !(lhsType != Short.TYPE && lhsType != Short.class || rhsType != Short.TYPE && rhsType != Short.class) ? Integer.class : (!(lhsType != Byte.TYPE && lhsType != Byte.class || rhsType != Byte.TYPE && rhsType != Byte.class) ? Integer.class : (lhsType.equals(rhsType) ? JavaClassHelper.getBoxedType(rhsType) : JavaClassHelper.getArithmaticCoercionType(lhsType, rhsType)));
        if (this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE && !this.isIntegerDivision && resultType != BigDecimal.class) {
            resultType = Double.class;
        }
        MathArithTypeEnum.Computer arithTypeEnumComputer = this.mathArithTypeEnum.getComputer(resultType, lhsType, rhsType, this.isIntegerDivision, this.isDivisionByZeroReturnsNull, validationContext.getClasspathImportService().getDefaultMathContext());
        this.forge = new ExprMathNodeForge(this, arithTypeEnumComputer, resultType);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        writer.append(this.mathArithTypeEnum.getExpressionText());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        if (this.mathArithTypeEnum == MathArithTypeEnum.MULTIPLY || this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE || this.mathArithTypeEnum == MathArithTypeEnum.MODULO) {
            return ExprPrecedenceEnum.MULTIPLY;
        }
        return ExprPrecedenceEnum.ADDITIVE;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprMathNode)) {
            return false;
        }
        ExprMathNode other = (ExprMathNode)node;
        return other.mathArithTypeEnum == this.mathArithTypeEnum;
    }

    public MathArithTypeEnum getMathArithTypeEnum() {
        return this.mathArithTypeEnum;
    }
}

