/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewInstanceNodeForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.InstanceManufacturerFactory;
import com.espertech.esper.common.internal.event.bean.manufacturer.InstanceManufacturerFactoryFactory;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import java.io.StringWriter;

public class ExprNewInstanceNode
extends ExprNodeBase {
    private static final long serialVersionUID = 1354077020397807076L;
    private final String classIdent;
    private transient ExprNewInstanceNodeForge forge;

    public ExprNewInstanceNode(String classIdent) {
        this.classIdent = classIdent;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprNewInstanceNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprNewInstanceNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class targetClass;
        try {
            targetClass = validationContext.getClasspathImportService().resolveClass(this.classIdent, false);
        }
        catch (ClasspathImportException e) {
            throw new ExprValidationException("Failed to resolve new-operator class name '" + this.classIdent + "'");
        }
        InstanceManufacturerFactory manufacturerFactory = InstanceManufacturerFactoryFactory.getManufacturer(targetClass, validationContext.getClasspathImportService(), this.getChildNodes());
        this.forge = new ExprNewInstanceNodeForge(this, targetClass, manufacturerFactory);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    public String getClassIdent() {
        return this.classIdent;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprNewInstanceNode)) {
            return false;
        }
        ExprNewInstanceNode other = (ExprNewInstanceNode)node;
        return other.classIdent.equals(this.classIdent);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("new ");
        writer.write(this.classIdent);
        ExprNodeUtilityPrint.toExpressionStringParams(writer, this.getChildNodes());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }
}

