/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpAllAnyNodeForge;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExprRelationalOpAllAnyNode
extends ExprNodeBase {
    private static final long serialVersionUID = -9212002972361997109L;
    private final RelationalOpEnum relationalOpEnum;
    private final boolean isAll;
    private transient ExprRelationalOpAllAnyNodeForge forge;

    public ExprRelationalOpAllAnyNode(RelationalOpEnum relationalOpEnum, boolean isAll) {
        this.relationalOpEnum = relationalOpEnum;
        this.isAll = isAll;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprRelationalOpAllAnyNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        return this.forge;
    }

    public boolean isConstantResult() {
        return false;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length < 1) {
            throw new IllegalStateException("Group relational op node must have 1 or more parameters");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes()[0].getForge().getEvaluationType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        boolean hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            Class propType = this.getChildNodes()[i + 1].getForge().getEvaluationType();
            if (propType.isArray()) {
                hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        if (coercionType != String.class && !JavaClassHelper.isNumeric(coercionType)) {
            throw new ExprValidationException("Implicit conversion from datatype '" + coercionType.getSimpleName() + "' to numeric is not allowed");
        }
        RelationalOpEnum.Computer computer = this.relationalOpEnum.getComputer(coercionType, coercionType, coercionType);
        this.forge = new ExprRelationalOpAllAnyNodeForge(this, computer, hasCollectionOrArray);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        writer.append(this.relationalOpEnum.getExpressionText());
        if (this.isAll) {
            writer.append("all");
        } else {
            writer.append("any");
        }
        writer.append("(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            writer.append(delimiter);
            this.getChildNodes()[i + 1].toEPL(writer, this.getPrecedence());
            delimiter = ",";
        }
        writer.append(")");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprRelationalOpAllAnyNode)) {
            return false;
        }
        ExprRelationalOpAllAnyNode other = (ExprRelationalOpAllAnyNode)node;
        return other.relationalOpEnum == this.relationalOpEnum && other.isAll == this.isAll;
    }
}

